/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesMnp {
    static boolean debug;
    static boolean verbose;

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-ud", "0", "testHg3766Chr1", "./tests/test.mnp.01.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.snpEffCmd();
        snpeff.setVerbose(verbose);
        snpeff.setSupressOutput(!verbose);
        snpeff.setDebug(debug);
        List<VcfEntry> results = snpeff.run(true);
        Assert.assertEquals(1L, results.size());
        VcfEntry result2 = results.get(0);
        for (VcfEffect eff : result2.parseEffects()) {
            String aa = eff.getAa();
            String aaNumStr = aa.substring(1, aa.length() - 1);
            int aanum = Gpr.parseIntSafe(aaNumStr);
            if (verbose) {
                System.out.println("AA: '" + eff.getAa() + "'\tAA Num Str: '" + aaNumStr + "'\teff: " + eff);
            }
            if (aanum > 0) continue;
            throw new RuntimeException("Missing AA number!");
        }
    }

    static {
        verbose = debug = false;
    }
}

