/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesHgvsUpDownStream {
    boolean debug;
    boolean verbose;

    public TestCasesHgvsUpDownStream() {
        this.verbose = this.debug = false;
    }

    public List<VcfEntry> snpEffect(String genome, String vcfFile, String[] otherArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (otherArgs != null) {
            for (String a : otherArgs) {
                args.add(a);
            }
        }
        args.add(genome);
        args.add(vcfFile);
        SnpEff cmd = new SnpEff(args.toArray(new String[0]));
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        cmdEff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        Assert.assertFalse("Annotation finished with errors", cmdEff.getTotalErrs() > 0);
        return list2;
    }

    @Test
    public void test_01_hgvs_upstream() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr2", "tests/hgvs_upstream.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (!veff.getTranscriptId().equals("NM_000463.2")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_02_hgvs_downstream() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr2", "tests/hgvs_downstream.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (!veff.getTranscriptId().equals("NM_000463.2")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_03_hgvs_upstream_del() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg3765Chr22", "tests/hgvs_upstream_del.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (!veff.getTranscriptId().equals("ENST00000404751")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_04_hgvs_upstream_negative_strand() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr17", "tests/hgvs_upstream_negative_strand.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (!veff.getTranscriptId().equals("NM_000199.3")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_05_hgvs_downstream_negative_strand() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr17", "tests/hgvs_downstream_negative_strand.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (!veff.getTranscriptId().equals("NM_000199.3")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }
}

