/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesHgvsLarge {
    boolean debug;
    boolean verbose;

    public TestCasesHgvsLarge() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_13_large_Del_Hgvs() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr22";
        String vcf = "tests/test_large_del_hgvs_13.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        for (VcfEffect veff : ve.parseEffects()) {
            if (this.verbose) {
                System.out.println(veff);
            }
            if (this.verbose) {
                System.out.println("\tAA change    : " + veff.getAa());
            }
            Assert.assertTrue(veff.getAa() == null || veff.getAa().length() < 100);
            if (this.verbose) {
                System.out.println("\tCodon change : " + veff.getCodon());
            }
            Assert.assertTrue(veff.getCodon() == null || veff.getCodon().length() < 100);
        }
    }
}

