/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.binseq.GenomicSequences;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesGenomicSequences {
    boolean debug;
    boolean verbose;

    public TestCasesGenomicSequences() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr1";
        String[] args = new String[]{genome};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.load();
        GenomicSequences genomicSequences = snpeff.getConfig().getGenome().getGenomicSequences();
        int i = 1;
        for (Gene g : snpeff.getConfig().getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    Gpr.showMark(i++, 100);
                    String seq2 = genomicSequences.querySequence(ex);
                    if (this.verbose) {
                        System.out.println(g.getGeneName() + "\t" + tr.getId() + "\t" + ex.getId() + "\n\t" + ex.getSequence() + "\n\t" + seq2);
                    }
                    Assert.assertNotNull(seq2 == null);
                    Assert.assertEquals(seq2, ex.getSequence());
                }
            }
        }
        System.err.println("\n");
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr22";
        String[] args = new String[]{genome};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.load();
        GenomicSequences genomicSequences = snpeff.getConfig().getGenome().getGenomicSequences();
        genomicSequences.setDisableLoad(true);
        int i = 1;
        for (Gene g : snpeff.getConfig().getGenome().getGenes()) {
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    Gpr.showMark(i++, 100);
                    String seq2 = genomicSequences.querySequence(ex);
                    if (this.verbose) {
                        System.out.println(g.getGeneName() + "\t" + tr.getId() + "\t" + ex.getId() + "\n\t" + ex.getSequence() + "\n\t" + seq2);
                    }
                    Assert.assertNotNull(seq2 == null);
                    Assert.assertEquals(seq2, ex.getSequence());
                }
            }
        }
        System.err.println("\n");
    }
}

