/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCasesEmbl {
    public static boolean debug = false;
    int exonToStringVersionOri;

    @After
    public void after() {
        Exon.ToStringVersion = this.exonToStringVersionOri;
    }

    @Before
    public void before() {
        this.exonToStringVersionOri = Exon.ToStringVersion;
        Exon.ToStringVersion = 1;
    }

    public SnpEffectPredictor build(String genome, String emblFile) {
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryEmbl sepEmbl = new SnpEffPredictorFactoryEmbl(config, emblFile);
        SnpEffectPredictor sep = sepEmbl.create();
        return sep;
    }

    @Test
    public void testCase_Exon_Simple() {
        Gpr.debug("Test");
        String genome = "testEmblPberghei";
        String resultFile = "tests/testEmblPberghei.genes.embl";
        SnpEffectPredictor sep = this.build(genome, resultFile);
        int pos = 4055;
        for (Gene g : sep.getGenome().getGenes()) {
            if (debug) {
                System.out.println("Gene: '" + g.getGeneName() + "', '" + g.getId() + "'");
            }
            for (Transcript tr : g) {
                if (debug) {
                    System.out.println("\tTranscript: '" + tr.getId() + "'");
                }
                for (Exon e : tr) {
                    if (debug) {
                        System.out.println("\t\tExon (" + e.getStrand() + "): '" + e.getId() + "'\t" + e.toStr());
                    }
                    if (!e.intersects(pos)) continue;
                    String seq2 = e.getSequence();
                    String base = e.basesAtPos(pos, 1);
                    if (debug) {
                        System.out.println("Seq : " + seq2 + "\nBase: " + base);
                    }
                    Assert.assertEquals("g", base);
                }
            }
        }
    }
}

