/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesCodingTag {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-ud", "0", "-noOut", "testHg19Chr1", "./tests/missing_coding_tr_tag.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.getChromosomeName() + "\t" + ve.getStart() + "\t" + ve.getInfoStr());
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (veff.getImpact() != VariantEffect.EffectImpact.MODERATE) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                }
                Assert.assertFalse(veff.getBioType() == null || veff.getBioType().isEmpty());
            }
        }
    }
}

