/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesCancer {
    boolean debug;
    boolean verbose;

    public TestCasesCancer() {
        this.verbose = this.debug = false;
    }

    public void snpEffect(String vcfFile, String txtFile, String aaHgsv, String genotype) {
        String[] argsVcf = new String[]{"-classic", "-cancer", "-hgvs", "testHg3766Chr1", vcfFile};
        String[] argsTxt = new String[]{"-classic", "-cancer", "-cancerSamples", txtFile, "-hgvs", "testHg3766Chr1", vcfFile};
        String[] args = txtFile == null ? argsVcf : argsTxt;
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        boolean found = false;
        for (VcfEntry vcfEntry : list2) {
            if (this.debug) {
                System.err.println(vcfEntry);
            }
            for (VcfEffect eff : vcfEntry.parseEffects()) {
                if (this.debug) {
                    System.err.println("\t" + eff + "\n\t\tAA : " + eff.getAa() + "\n\t\tGenotype: " + eff.getGenotype());
                }
                if (!genotype.equals(eff.getGenotype())) continue;
                Assert.assertEquals(aaHgsv, eff.getAa());
                found = true;
            }
        }
        if (!found) {
            throw new RuntimeException("Genotype '" + genotype + "' not found.");
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String file = "tests/test.cancer.snp.01.vcf";
        this.snpEffect(file, null, "p.Leu1?/c.1A>G", "G-C");
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String fileVcf = "tests/test.cancer_no_ped.vcf";
        String fileTxt = "tests/test.cancer_no_ped.txt";
        this.snpEffect(fileVcf, fileTxt, "p.Leu1?/c.1A>G", "G-C");
    }

    @Test
    public void test_03_cancer_concurrent_modification() {
        Gpr.debug("Test");
        String[] args = new String[]{"-cancer", "-cancerSamples", "tests/test_cancer_concurrent_modification.txt", "-ud", "0", "-strict", "testHg3775Chr1", "tests/test_cancer_concurrent_modification.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.snpEffCmd();
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setVerbose(this.verbose);
        List<VcfEntry> vcfEnties = snpeff.run(true);
        Assert.assertFalse("Annotation finished with errors", snpeff.getTotalErrs() > 0);
        int countCancer = 0;
        int countCancerWarnings = 0;
        for (VcfEntry ve : vcfEnties) {
            if (this.verbose) {
                System.out.println(ve);
            }
            List<VcfEffect> veffs = ve.parseEffects();
            for (VcfEffect veff : veffs) {
                if (this.verbose) {
                    System.out.println("\t" + veff.getAllele() + "\t" + veff);
                }
                if (veff.getAllele().indexOf(45) <= 0) continue;
                ++countCancer;
                System.out.println("\t\t" + veff.getErrorsWarning());
                if (veff.getErrorsWarning() == null || veff.getErrorsWarning().isEmpty()) continue;
                ++countCancerWarnings;
            }
        }
        Assert.assertTrue("Cancer effects not found", countCancer > 0);
        Assert.assertTrue("There should be no warnings: countCancerWarnings = " + countCancerWarnings, countCancerWarnings == 0);
    }
}

