/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.CommandLine;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class IntegrationTest {
    public final int BUFFER_SIZE = 0xA00000;
    public static final int MAX_LINES_DIFF = 20;
    protected boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String command(CommandLine command) {
        PrintStream oldOut = System.out;
        String standardOutput = "";
        ByteArrayOutputStream output2 = new ByteArrayOutputStream(0xA00000);
        try {
            System.setOut(new PrintStream(output2));
            command.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            standardOutput = output2.toString();
            System.setOut(oldOut);
        }
        return standardOutput;
    }

    public void command(CommandLine command, String expectedOutputFile) {
        if (this.verbose) {
            System.err.println("Executing command '" + this.showCommand(command) + "'");
        }
        String actualOutput = this.command(command);
        actualOutput = this.removeVcfHeader(actualOutput);
        if (this.verbose) {
            System.err.println("Reading results file '" + expectedOutputFile + "'");
        }
        String expectedOutput = Gpr.readFile(expectedOutputFile);
        expectedOutput = this.removeVcfHeader(expectedOutput);
        int expectedOutputCountLines = expectedOutput.split("\n").length;
        int actualOutputCountLines = actualOutput.split("\n").length;
        if (this.verbose) {
            System.err.println("Comparing outputs\t\tExpected size: " + expectedOutput.length() + " (" + expectedOutputCountLines + " lines)\t\tActual size: " + actualOutput.length() + " (" + actualOutputCountLines + " lines)");
        }
        if (!expectedOutput.equals(actualOutput)) {
            String msg = "Outputs differ!\n\tFile    : '" + expectedOutputFile + "'\n\tCommand : '" + this.showCommand(command) + "'";
            System.err.println(msg);
            System.err.println(this.showDiff(expectedOutput, actualOutput));
            throw new RuntimeException(msg);
        }
    }

    String removeVcfHeader(String lines2) {
        StringBuilder sb = new StringBuilder();
        for (String l : lines2.split("\n")) {
            if (l.startsWith("#")) continue;
            sb.append(l + "\n");
        }
        return sb.toString();
    }

    public String showCommand(CommandLine command) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(command.getClass().getSimpleName() + " ");
        for (String arg : command.getArgs()) {
            cmd.append(arg + " ");
        }
        return cmd.toString();
    }

    public String showDiff(String s1, String s2) {
        StringBuilder diff2 = new StringBuilder();
        String[] lines1 = s1.split("\n");
        String[] lines2 = s2.split("\n");
        diff2.append("Number of lines: " + lines1.length + " vs " + lines2.length + "\n");
        int min2 = Math.min(lines1.length, lines2.length);
        int countLinesDiff = 0;
        for (int i = 0; i < min2; ++i) {
            if (!lines1[i].equals(lines2[i])) {
                ++countLinesDiff;
                diff2.append(String.format("%10d\t|%s|\n", i + 1, lines1[i]));
                diff2.append(String.format("          \t|%s|\n", lines2[i]));
                diff2.append(String.format("          \t|%s|\n\n", this.showDiffLine(lines1[i], lines2[i])));
            }
            if (countLinesDiff > 20) break;
        }
        return diff2.toString();
    }

    public String showDiffLine(String l1, String l2) {
        int max2 = Math.max(l1.length(), l2.length());
        char[] d = new char[max2];
        for (int i = 0; i < max2; ++i) {
            d[i] = i >= l1.length() || i >= l2.length() ? 124 : (l1.charAt(i) != l2.charAt(i) ? 124 : (l1.charAt(i) == '\t' ? 9 : 32));
        }
        return new String(d);
    }
}

