/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.vcf.VcfConsequence;
import ca.mcgill.mcb.pcingola.vcf.VcfConsequenceHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;

public class CompareToVep {
    boolean debug = false;
    boolean verbose = false;
    boolean compareEffect = true;
    boolean compareHgvsDna = false;
    boolean compareHgvsProt = false;
    boolean onlyProtein = false;
    boolean shiftHgvs = false;
    boolean strict = false;
    boolean throwException = true;
    String genomeName;
    String[] addArgs;
    VcfConsequenceHeader vcfCsqHeader;
    SnpEffCmdEff cmdEff;
    int countHgvsDna;
    int countHgvsProt;
    int countEff;

    public CompareToVep(String genomeName, boolean verbose) {
        this.genomeName = genomeName;
        this.verbose = verbose;
    }

    public CompareToVep(String genomeName, String[] addArgs, boolean verbose) {
        this.genomeName = genomeName;
        this.addArgs = addArgs;
        this.verbose = verbose;
    }

    String[] args(String genomeName, String vcf) {
        LinkedList<String> args = new LinkedList<String>();
        if (this.addArgs != null) {
            for (String arg : this.addArgs) {
                args.add(arg);
            }
        }
        args.add("-noStats");
        args.add("-noLog");
        if (this.strict) {
            args.add("-strict");
        }
        if (this.onlyProtein) {
            args.add("-onlyProtein");
        }
        if (!this.shiftHgvs) {
            args.add("-noShiftHgvs");
        }
        args.add("-formatEff");
        args.add(genomeName);
        args.add(vcf);
        return args.toArray(new String[0]);
    }

    boolean canCompare(VcfEffect eff, VcfConsequence csq) {
        return !this.compareHgvsDna || eff.getEffectType() != EffectType.DOWNSTREAM && eff.getEffectType() != EffectType.UPSTREAM;
    }

    public boolean checkComapred() {
        if (this.compareHgvsDna || this.compareHgvsProt) {
            return this.countHgvsDna + this.countHgvsProt > 0;
        }
        return this.countEff > 0;
    }

    boolean compare(List<VcfEffect> effs, List<VcfConsequence> csqs) {
        HashSet<String> trIds = new HashSet<String>();
        for (VcfEffect eff : effs) {
            trIds.add(eff.getTranscriptId());
        }
        for (String trId : trIds) {
            boolean match = this.compare(effs, csqs, trId);
            if (match) continue;
            return false;
        }
        return true;
    }

    boolean compare(List<VcfEffect> effs, List<VcfConsequence> csqs, String trId) {
        if (trId == null) {
            return true;
        }
        boolean ok = false;
        if (this.verbose) {
            Transcript tr = this.cmdEff.getConfig().getSnpEffectPredictor().getTranscript(trId);
            if (tr != null) {
                System.out.println("\n\t\tTranscript : '" + tr.getId() + "'");
                System.out.println("\t\tStrand     : '" + (tr.isStrandPlus() ? "+" : "-") + "'");
                System.out.println("\t\tCDS        : '" + tr.cds() + "'");
                System.out.println("\t\tProtein    : '" + tr.protein() + "'");
            } else {
                System.out.println("Transcript " + trId + " not found.");
            }
        }
        for (VcfEffect eff : effs) {
            if (!trId.equals(eff.getTranscriptId())) continue;
            boolean match = this.compare(eff, csqs);
            if (this.verbose) {
                String matched = match ? "OK" : "NO";
                System.out.println("\t\t\t" + matched + " Match");
            }
            ok |= match;
        }
        return ok;
    }

    boolean compare(String effSo, String csqSo) {
        if (effSo.equals(csqSo)) {
            return true;
        }
        if (effSo.equals("inframe_deletion") && csqSo.equals("feature_truncation")) {
            return true;
        }
        if (effSo.equals("disruptive_inframe_insertion") && csqSo.equals("inframe_insertion")) {
            return true;
        }
        if (effSo.equals("disruptive_inframe_deletion") && csqSo.equals("inframe_deletion")) {
            return true;
        }
        if (effSo.equals("disruptive_inframe_deletion") && csqSo.equals("feature_truncation")) {
            return true;
        }
        if (effSo.equals("synonymous_variant") && csqSo.equals("coding_sequence_variant")) {
            return true;
        }
        return effSo.equals("non_coding_exon_variant") && csqSo.equals("NMD_transcript_variant");
    }

    boolean compare(VcfEffect eff, List<VcfConsequence> csqs) {
        String effStr = eff.getEffectsStrSo();
        boolean foundTranscript = false;
        for (String et : effStr.split("\\+")) {
            if (this.verbose) {
                System.out.println("\t\t" + et + "\t" + eff.getTranscriptId());
            }
            for (VcfConsequence csq : csqs) {
                if (!csq.getFeature().equals(eff.getTranscriptId()) || !this.canCompare(eff, csq)) continue;
                foundTranscript = true;
                if (!this.compare(eff, csq)) continue;
                return true;
            }
        }
        return !foundTranscript;
    }

    boolean compare(VcfEffect eff, VcfConsequence csq) {
        if (this.compareEffect) {
            return this.compareEffect(eff, csq);
        }
        if (this.compareHgvsDna || this.compareHgvsProt) {
            return this.compareHgvs(eff, csq);
        }
        throw new RuntimeException("Nothing to compare!");
    }

    boolean compareEffect(VcfEffect eff, VcfConsequence csq) {
        String[] effectTypes = eff.getEffectTypesStr().split("\\+");
        String[] consecuences = csq.getConsequence().split("&");
        for (String et : effectTypes) {
            for (String cons : consecuences) {
                if (this.compare(et, cons)) {
                    ++this.countEff;
                    if (this.verbose) {
                        System.out.println("\t\t\tOK :" + eff.getTranscriptId() + "\t" + et + "\t" + cons);
                    }
                    return true;
                }
                if (!this.verbose) continue;
                System.out.println("\t\t\t    " + eff.getTranscriptId() + "\t" + et + "\t" + cons);
            }
        }
        return false;
    }

    boolean compareHgvs(VcfEffect eff, VcfConsequence csq) {
        if (this.verbose) {
            String effHgsvDna = eff.getHgvsDna();
            String effHgsvProt = eff.getHgvsProt();
            System.out.println("\t\t\teff     : " + eff.getEffectTypesStr() + "\n\t\t\tcsq     : " + csq.getConsequence() + "\n\t\t\ttrId    : " + eff.getTranscriptId() + "\t" + csq.getFeature() + "\n\t\t\thgsv.c  : '" + effHgsvDna + "'\t'" + csq.getHgvsDna() + "'\t" + (this.compareHgvsDna(eff, csq) ? "OK" : "BAD") + "\n\t\t\thgsv.p  : '" + effHgsvProt + "'\t'" + csq.getHgvsProt() + "'\t" + (this.compareHgvsProt(eff, csq) ? "OK" : "BAD") + "\n");
        }
        return !(this.compareHgvsDna && !this.compareHgvsDna(eff, csq) || this.compareHgvsProt && !this.compareHgvsProt(eff, csq));
    }

    boolean compareHgvsDna(VcfEffect eff, VcfConsequence csq) {
        String effHgsv = eff.getHgvsDna();
        String csqHgvs = csq.getHgvsDna();
        if (csqHgvs.isEmpty() && (effHgsv == null || effHgsv.isEmpty())) {
            return true;
        }
        if (!csqHgvs.isEmpty() && (effHgsv == null || effHgsv.isEmpty())) {
            return false;
        }
        if (csqHgvs.isEmpty() && (effHgsv != null || !effHgsv.isEmpty())) {
            return false;
        }
        boolean eq2 = (csqHgvs = csqHgvs.substring(csqHgvs.indexOf(58) + 1)).equals(effHgsv);
        if (eq2) {
            ++this.countHgvsDna;
        }
        return eq2;
    }

    boolean compareHgvsProt(VcfEffect eff, VcfConsequence csq) {
        String effHgsv = eff.getHgvsProt();
        String csqHgvs = csq.getHgvsProt();
        if (csqHgvs.isEmpty() && (effHgsv == null || effHgsv.isEmpty())) {
            return true;
        }
        if (!csqHgvs.isEmpty() && (effHgsv == null || effHgsv.isEmpty())) {
            return false;
        }
        if (csqHgvs.isEmpty() && (effHgsv != null || !effHgsv.isEmpty())) {
            return false;
        }
        if (csqHgvs.endsWith("(p.%3D)")) {
            return true;
        }
        csqHgvs = csqHgvs.substring(csqHgvs.indexOf(58) + 1);
        boolean eq2 = csqHgvs.equals(effHgsv);
        if (csqHgvs.indexOf("fs") > 0 && effHgsv.endsWith("fs")) {
            String effHgsvFs = effHgsv.substring(0, effHgsv.length() - 2);
            String csqHgsvFs = csqHgvs.substring(0, csqHgvs.indexOf("fs") - 3);
            eq2 = csqHgsvFs.equals(effHgsvFs);
        }
        if (eq2) {
            ++this.countHgvsProt;
        }
        return eq2;
    }

    public void compareVep(String vcf) {
        if (this.verbose) {
            System.out.println(this.getClass().getSimpleName() + ": Compare VEP, genome " + this.genomeName + ", file " + vcf);
        }
        this.parseCsqHeader(vcf);
        List<VcfEntry> vcfEnties = this.runSnpEff(this.args(this.genomeName, vcf));
        for (VcfEntry ve : vcfEnties) {
            List<VcfConsequence> csqs = VcfConsequence.parse(this.vcfCsqHeader, ve);
            List<VcfEffect> effs = ve.parseEffects();
            if (this.verbose) {
                System.out.println(ve);
                System.out.println("\tCSQ:");
                for (VcfConsequence csq : csqs) {
                    System.out.println("\t\t" + csq);
                }
                System.out.println("\tEFF:");
                for (VcfEffect eff : effs) {
                    System.out.println("\t\t" + eff);
                }
                System.out.println("\tCompare:");
            }
            Assert.assertTrue("EFF and CSQ do not match", this.compare(effs, csqs));
        }
    }

    void parseCsqHeader(String vcfFileName) {
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        vcf.next();
        this.vcfCsqHeader = new VcfConsequenceHeader(vcf);
    }

    List<VcfEntry> runSnpEff(String[] args) {
        SnpEff cmd = new SnpEff(args);
        this.cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        this.cmdEff.setVerbose(this.verbose);
        this.cmdEff.setSupressOutput(!this.verbose);
        this.cmdEff.setDebug(this.debug);
        this.cmdEff.getConfig();
        List<VcfEntry> vcfEnties = this.cmdEff.run(true);
        return vcfEnties;
    }

    public void setCompareHgvs() {
        this.compareEffect = false;
        this.compareHgvsProt = true;
        this.compareHgvsDna = true;
    }

    public void setCompareHgvsDna(boolean compareHgvsDna) {
        this.compareHgvsDna = compareHgvsDna;
    }

    public void setCompareHgvsProt(boolean compareHgvsProt) {
        this.compareHgvsProt = compareHgvsProt;
    }

    public void setOnlyProtein(boolean onlyProtein) {
        this.onlyProtein = onlyProtein;
    }

    public void setShiftHgvs(boolean shiftHgvs) {
        this.shiftHgvs = shiftHgvs;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String toString() {
        if (this.compareHgvsDna || this.compareHgvsProt) {
            return "HGVS DNA OK: " + this.countHgvsDna + "\tHGVS protein OK: " + this.countHgvsProt;
        }
        return "Effects OK: " + this.countEff;
    }
}

