/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.fileIterator.VariantTxtFileIterator;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class CompareEffects {
    boolean debug;
    boolean verbose;
    boolean createOutputFile;
    boolean useAaNoNum;
    boolean shiftHgvs;
    Config config;
    Genome genome;
    Random rand;
    long randSeed;
    String genomeName;
    SnpEffectPredictor snpEffectPredictor;

    public CompareEffects(SnpEffectPredictor snpEffectPredictor, long randSeed, boolean verbose) {
        this.verbose = this.debug = false;
        this.createOutputFile = false;
        this.useAaNoNum = false;
        this.shiftHgvs = false;
        this.genomeName = "test";
        this.randSeed = randSeed;
        this.verbose = verbose;
        this.snpEffectPredictor = snpEffectPredictor;
        this.initRand();
        this.config = new Config("testCase", "snpEff.config");
    }

    public CompareEffects(String genomeName, long randSeed, boolean verbose) {
        this.verbose = this.debug = false;
        this.createOutputFile = false;
        this.useAaNoNum = false;
        this.shiftHgvs = false;
        this.genomeName = genomeName;
        this.randSeed = randSeed;
        this.verbose = verbose;
        this.initRand();
        this.config = new Config("testCase", "snpEff.config");
    }

    boolean anyResultMatches(String transcriptId, Variant variant, VariantEffects variantEffects, boolean useShort) {
        for (VariantEffect varEff : variantEffects) {
            String expectedEff = variant.getId();
            Transcript tr = varEff.getTranscript();
            if (!(tr != null ? (transcriptId == null || transcriptId.equals(tr.getId())) && this.compareOK(varEff, expectedEff) : this.compareOK(varEff, expectedEff))) continue;
            return true;
        }
        return false;
    }

    boolean compareAa(VariantEffect varEff, String expEffs) {
        String aa;
        String expAa = this.findAa(expEffs);
        if (expAa.isEmpty()) {
            return true;
        }
        String string2 = aa = this.useAaNoNum ? varEff.getAaChangeOld() : varEff.getAaChange();
        if (this.debug) {
            Gpr.debug("AA compare: '" + aa + "'\tExpected AA: '" + expAa + "'");
        }
        return aa.equals(expAa);
    }

    boolean compareEff(VariantEffect varEff, String expEffs) {
        for (EffectType effType : varEff.getEffectTypes()) {
            for (String realEff : this.findEffTypes(expEffs)) {
                if (this.debug) {
                    Gpr.debug("Compare effect\texp:" + (Object)((Object)effType) + "\treal:" + realEff);
                }
                if (!effType.toString().equals(realEff)) continue;
                return true;
            }
        }
        return false;
    }

    boolean compareOK(VariantEffect varEff, String expEffs) {
        String varEffStr = varEff.effect(false, true, false, false, false);
        if (varEffStr.equals(expEffs)) {
            return true;
        }
        return this.compareEff(varEff, expEffs) && this.compareAa(varEff, expEffs);
    }

    String findAa(String eff) {
        int aaStartIdx = eff.indexOf(40);
        int aaStopIdx = eff.indexOf(41);
        if (aaStartIdx < 0 || aaStopIdx < 0) {
            return "";
        }
        return eff.substring(aaStartIdx + 1, aaStopIdx);
    }

    String[] findEffTypes(String eff) {
        int aaidx = eff.indexOf(40);
        if (aaidx < 0) {
            return eff.split("\\+");
        }
        return eff.substring(0, aaidx).split("\\+");
    }

    void initRand() {
        this.rand = new Random(this.randSeed);
    }

    public void initSnpEffPredictor() {
        this.config = new Config(this.genomeName, "snpEff.config");
        if (this.snpEffectPredictor == null) {
            this.config.loadSnpEffectPredictor();
            this.genome = this.config.getGenome();
        } else {
            this.config.setSnpEffectPredictor(this.snpEffectPredictor);
            this.genome = this.snpEffectPredictor.getGenome();
        }
        this.config.setTreatAllAsProteinCoding(true);
        this.config.setShiftHgvs(this.shiftHgvs);
        this.config.getSnpEffectPredictor().buildForest();
    }

    public List<Variant> parseSnpEffectFile(String variantFile) {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        VariantTxtFileIterator variantFileIterator = new VariantTxtFileIterator(variantFile, this.genome);
        for (Variant sc : variantFileIterator) {
            variants.add(sc);
        }
        Collections.sort(variants);
        return variants;
    }

    public void setUseAaNoNum(boolean useAaNoNum) {
        this.useAaNoNum = useAaNoNum;
    }

    public void snpEffect(List<Variant> variantList, String transcriptId, boolean useShort, boolean negate) {
        int num = 1;
        for (Variant variant : variantList) {
            VariantEffects results = this.config.getSnpEffectPredictor().variantEffect(variant);
            String msg = "";
            msg = msg + "Number : " + num + "\n";
            msg = msg + "\tVariant     : " + variant + "\n";
            msg = msg + "\tExpecting   : " + (negate ? "NOT " : "") + "'" + variant.getId() + "'\n";
            msg = msg + "\tResultsList :\n";
            for (VariantEffect res : results) {
                msg = msg + "\t\t'" + res.toStringSimple(useShort) + "'\n";
            }
            if (this.verbose) {
                System.out.println(msg);
            }
            boolean ok = this.anyResultMatches(transcriptId, variant, results, useShort);
            if (!(ok = negate ^ ok)) {
                if (this.createOutputFile) {
                    for (VariantEffect res : results) {
                        Variant sc = res.getVariant();
                        System.out.println(sc.getChromosomeName() + "\t" + (sc.getStart() + 1) + "\t" + sc.getReference() + "\t" + sc.getAlt() + "\t+\t0\t0" + "\t" + res.effect(true, true, true, false, false));
                    }
                } else {
                    Gpr.debug(msg);
                    throw new RuntimeException(msg);
                }
            }
            ++num;
        }
    }

    public void snpEffect(String snpEffFile, String transcriptId, boolean useShort) {
        this.initSnpEffPredictor();
        List<Variant> snplist = this.parseSnpEffectFile(snpEffFile);
        this.snpEffect(snplist, transcriptId, useShort, false);
    }

    public void snpEffectNegate(String snpEffFile, String transcriptId, boolean useShort) {
        this.initSnpEffPredictor();
        List<Variant> snplist = this.parseSnpEffectFile(snpEffFile);
        this.snpEffect(snplist, transcriptId, useShort, true);
    }
}

