/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class SnpEffPredictorFactoryGff3
extends SnpEffPredictorFactoryGff {
    public SnpEffPredictorFactoryGff3(Config config) {
        super(config);
        this.version = "GFF3";
    }

    void addInterval(String id, String type, String chromo, int start, int end, boolean strandMinus, String name, boolean proteinCoding, String parent, int frame) {
        block21: {
            String[] parents;
            block23: {
                String[] parents2;
                Chromosome chromosome;
                block22: {
                    Gene gene;
                    block20: {
                        chromosome = this.getOrCreateChromosome(chromo);
                        if (!this.is(type, GENE)) break block20;
                        if (id != null && this.findGene(id) != null) {
                            this.warning(type + " '" + id + "' already added");
                            return;
                        }
                        Gene gene2 = new Gene(chromosome, start, end, strandMinus, id, name, "");
                        this.add(gene2);
                        break block21;
                    }
                    if (!this.is(type, TRANSCRIPT)) break block22;
                    if (id != null && this.findTranscript(id) != null) {
                        this.warning(type + " '" + id + "' already added");
                        return;
                    }
                    String geneId = parent;
                    if (geneId.isEmpty()) {
                        geneId = "Gene_" + id;
                    }
                    if ((gene = this.findGene(geneId, id)) == null) {
                        gene = new Gene(chromosome, start, end, strandMinus, geneId, geneId, "mRNA");
                        this.add(gene);
                        this.warning("Cannot find gene '" + geneId + "'. Created gene '" + gene.getId() + "' for transcript '" + id + "'");
                    }
                    if (gene.getBioType() == null || !gene.getBioType().equals(type)) {
                        gene.setBioType(type);
                    }
                    if (!gene.getChromosomeName().equals(chromosome.getId())) {
                        this.error("Trying to assign Transcript to a gene in a different chromosome!\n\tPosition    : " + chromo + ":" + start + "-" + end + "\n\t" + gene);
                    }
                    Transcript tr = new Transcript(gene, start, end, strandMinus, id);
                    if (proteinCoding) {
                        tr.setProteinCoding(proteinCoding);
                    }
                    this.add(tr);
                    break block21;
                }
                if (!this.is(type, EXON)) break block23;
                for (String par2 : parents2 = parent.split(",")) {
                    Exon ex;
                    String trId;
                    par2 = par2.trim();
                    Transcript tr = this.findTranscript(par2, id);
                    Gene gene = this.findGene(par2, id);
                    if (tr == null && gene != null) {
                        trId = "Transcript_" + gene.getId();
                        tr = new Transcript(gene, start, end, strandMinus, trId);
                        if (proteinCoding) {
                            tr.setProteinCoding(proteinCoding);
                        }
                        this.add(tr);
                        this.warning("Cannot find transcript '" + par2 + "'. Created transcript '" + tr.getId() + "' for this exon");
                    }
                    if (tr == null) {
                        if (gene == null) {
                            String gId = "Gene_" + (par2.isEmpty() ? id : par2);
                            gene = new Gene(chromosome, start, end, strandMinus, gId, name, "");
                        }
                        trId = par2.isEmpty() ? "Transcript_" + id : par2;
                        tr = new Transcript(gene, start, end, strandMinus, trId);
                        if (proteinCoding) {
                            tr.setProteinCoding(proteinCoding);
                        }
                        this.add(gene);
                        this.add(tr);
                        this.warning("Cannot find transcript '" + par2 + "'. Created transcript '" + tr.getId() + "' and gene '" + gene.getId() + "' for this exon");
                    }
                    if (!tr.getChromosomeName().equals(chromosome.getId())) {
                        this.warning("Trying to assign Exon or CDS to a transcript in a different chromosome!\n\tPosition    : " + chromo + ":" + start + "-" + end + "\n\t" + tr);
                        return;
                    }
                    if (type.equalsIgnoreCase("exon")) {
                        int rank = 0;
                        ex = new Exon(tr, start, end, strandMinus, id, rank);
                        ex.setFrame(frame);
                        this.add(ex);
                        continue;
                    }
                    if (type.equalsIgnoreCase("CDS")) {
                        Cds cds = new Cds(tr, start, end, strandMinus, id);
                        cds.setFrame(frame);
                        this.add(cds);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("stop_codon") && !type.equalsIgnoreCase("start_codon")) continue;
                    int rank = 0;
                    ex = new Exon(tr, start, end, strandMinus, id, rank);
                    ex.setFrame(frame);
                    this.add(ex);
                    Cds cds = new Cds(tr, start, end, strandMinus, type + "_" + id);
                    cds.setFrame(frame);
                    this.add(cds);
                }
                break block21;
            }
            if (!this.is(type, UTR5) && !this.is(type, UTR3)) break block21;
            for (String par3 : parents = parent.split(",")) {
                Transcript tr = this.findTranscript(par3);
                if (tr == null) {
                    this.warning("Cannot find transcript '" + par3 + "'");
                    return;
                }
                Marker utr = new Marker(tr, start, end, strandMinus, id);
                Exon exon = tr.queryExon(utr);
                if (exon == null) {
                    exon = new Exon(tr, start, end, strandMinus, id, 0);
                    exon.setFrame(frame);
                    this.add(exon);
                    this.warning("Cannot find exon for UTR: '" + utr.getId() + "'. Creating exon '" + id + "'");
                }
                if (this.is(type, UTR5)) {
                    Utr5prime u5 = new Utr5prime(exon, start, end, strandMinus, id);
                    tr.add(u5);
                    this.add(u5);
                    continue;
                }
                if (!this.is(type, UTR3)) continue;
                Utr3prime u3 = new Utr3prime(exon, start, end, strandMinus, id);
                tr.add(u3);
                this.add(u3);
            }
        }
    }

    @Override
    protected boolean parse(String line, String typeToRead) {
        String attrStr;
        String[] fields = line.split("\t");
        if (fields.length <= 6) {
            return false;
        }
        String type = fields[2];
        if (!this.is(type, typeToRead)) {
            return false;
        }
        String chromo = fields[0];
        String source = fields[1];
        int start = this.parsePosition(fields[3]);
        int end = this.parsePosition(fields[4]);
        boolean strandMinus = fields[6].equals("-");
        int frame = fields[7].equals(".") ? -1 : Gpr.parseIntSafe(fields[7]);
        frame = this.frameType.convertFrame(frame);
        String name = null;
        String parent = "";
        String id = null;
        boolean proteinCoding = this.isProteingCoding(source);
        if (fields.length >= 8 && (attrStr = fields[8]).length() > 0) {
            String[] attrs = attrStr.split(";");
            for (int i = 0; i < attrs.length; ++i) {
                String[] kv = attrs[i].split("=");
                if (kv.length <= 1) continue;
                String key = kv[0];
                String value2 = kv[1];
                if (key.equalsIgnoreCase("ID")) {
                    id = value2;
                    continue;
                }
                if (key.equalsIgnoreCase("Parent")) {
                    parent = value2;
                    continue;
                }
                if (key.equalsIgnoreCase("Name") || key.equalsIgnoreCase("gene_name")) {
                    name = value2;
                    continue;
                }
                if (key.equalsIgnoreCase("db_xref") && id == null) {
                    id = value2;
                    continue;
                }
                if (!key.equalsIgnoreCase("biotype")) continue;
                proteinCoding |= this.isProteingCoding(value2);
            }
        }
        if (id == null) {
            id = typeToRead + "_" + chromo + "_" + (start + 1) + "_" + (end + 1);
        }
        if (name == null) {
            name = id;
        }
        id = id.trim();
        name = name.trim();
        this.addInterval(id, type, chromo, start, end, strandMinus, name, proteinCoding, parent, frame);
        return true;
    }
}

