/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.File;

public class SnpEffPredictorFactoryGenesFile
extends SnpEffPredictorFactory {
    public SnpEffPredictorFactoryGenesFile(Config config) {
        super(config, 1);
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            if (this.genome.getChromoFastaFiles().length > 0 && this.genome.getChromosomeNames().length != this.genome.getChromoFastaFiles().length) {
                throw new RuntimeException("Number of chromosomes does not match number of fasta files (there must be one fasta files per chromosome)\n" + this.genome);
            }
            this.fileName = this.config.getBaseFileNameGenes() + ".biomart";
            System.out.println("Reading gene intervals file : '" + this.fileName + "'");
            this.readGenesFile();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            this.finishUp();
            if (this.verbose) {
                System.out.println(this.config.getGenome());
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    void parseGenesFile(String line) {
        Utr utrInterval;
        String exonId;
        Exon exon;
        String transcriptId;
        Transcript tr;
        String[] fields = line.split("\t");
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
        }
        String geneId = fields[1];
        String chromoName = fields[2];
        Chromosome chromo = this.getOrCreateChromosome(chromoName);
        Gene gint = this.snpEffectPredictor.getGene(geneId);
        if (gint == null) {
            gint = new Gene(chromo, this.parsePosition(fields[3]), this.parsePosition(fields[4]), Gpr.parseIntSafe(fields[5]) < 0, geneId, fields[0], fields[6]);
            this.snpEffectPredictor.add(gint);
        }
        if ((tr = (Transcript)gint.get(transcriptId = fields[7])) == null) {
            tr = new Transcript(gint, this.parsePosition(fields[8]), this.parsePosition(fields[9]), gint.isStrandMinus(), transcriptId);
            gint.add(tr);
        }
        if ((exon = (Exon)tr.get(exonId = fields[10])) == null) {
            exon = new Exon(tr, this.parsePosition(fields[11]), this.parsePosition(fields[12]), gint.isStrandMinus(), exonId, Gpr.parseIntSafe(fields[13]));
            tr.add(exon);
        }
        if (fields.length >= 16 && fields[14].length() > 0 && fields[15].length() > 0) {
            utrInterval = new Utr5prime(exon, this.parsePosition(fields[14]), this.parsePosition(fields[15]), gint.isStrandMinus(), exonId);
            tr.add(utrInterval);
        }
        if (fields.length >= 18 && fields[16].length() > 0 && fields[17].length() > 0) {
            utrInterval = new Utr3prime(exon, this.parsePosition(fields[16]), this.parsePosition(fields[17]), gint.isStrandMinus(), exonId);
            tr.add(utrInterval);
        }
    }

    void readGenesFile() {
        String file = "";
        File f2 = new File(this.fileName);
        if (f2.exists()) {
            file = Gpr.readFile(this.fileName);
        } else {
            String fileNameGz = this.fileName + ".gz";
            f2 = new File(fileNameGz);
            if (f2.exists()) {
                file = Gpr.readFile(fileNameGz);
            } else {
                throw new RuntimeException("Cannot find file '" + this.fileName + "' or '" + fileNameGz + "'");
            }
        }
        String[] lines2 = file.split("\n");
        for (int i = 0; i < lines2.length; ++i) {
            this.lineNum = i + 1;
            this.line = lines2[i];
            this.parseGenesFile(this.line);
        }
    }
}

