/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.genBank.FeatureCoordinates;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.genBank.FeaturesFile;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public abstract class SnpEffPredictorFactoryFeatures
extends SnpEffPredictorFactory {
    public static final int OFFSET = 1;
    Chromosome chromosome;
    FeaturesFile featuresFile;

    public SnpEffPredictorFactoryFeatures(Config config) {
        super(config, 1);
    }

    protected void addFeatures(Features features) {
        for (Feature f2 : features.getFeatures()) {
            int start = f2.getStart() - this.inOffset;
            int end = f2.getEnd() - this.inOffset;
            if (f2.getType() != Feature.Type.SOURCE) continue;
            if (this.chromosome == null) {
                String chrName = this.chromoName(features, f2);
                this.chromosome = new Chromosome(this.genome, start, end, chrName);
                this.add(this.chromosome);
                continue;
            }
            if (!this.debug) continue;
            System.err.println("Warnign: 'SOURCE' already assigned to chromosome. Ignoring feature:\n" + f2);
        }
        if (this.chromosome == null) {
            String chrName = this.chromoName(features, null);
            int chrSize = this.sequence(features).length();
            this.chromosome = new Chromosome(this.genome, 0, chrSize, chrName);
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            throw new RuntimeException("Could not find SOURCE feature");
        }
        if (this.verbose) {
            System.err.println("Chromosome: '" + this.chromosome.getId() + "'\tlength: " + this.chromosome.size());
        }
        Gene geneLatest = null;
        Interval trLatest = null;
        for (Feature f3 : features.getFeatures()) {
            String trId;
            int end;
            int start;
            if (f3.getType() == Feature.Type.GENE) {
                geneLatest = this.findOrCreateGene(f3, this.chromosome, false);
                trLatest = null;
                continue;
            }
            if (f3.getType() == Feature.Type.MRNA) {
                start = f3.getStart() - this.inOffset;
                end = f3.getEnd() - this.inOffset;
                Gene gene = null;
                gene = geneLatest != null && geneLatest.intersects(start, end) ? geneLatest : this.findOrCreateGene(f3, this.chromosome, false);
                trId = f3.getTranscriptId();
                Transcript tr = new Transcript(gene, start, end, f3.isComplement(), trId);
                if (f3.hasMultipleCoordinates()) {
                    int exNum = 1;
                    for (FeatureCoordinates fc : f3) {
                        Exon e = new Exon(tr, fc.start - this.inOffset, fc.end - this.inOffset, fc.complement, tr.getId() + "_" + exNum, exNum);
                        tr.add(e);
                        ++exNum;
                    }
                }
                this.add(tr);
                trLatest = tr;
                continue;
            }
            if (f3.getType() != Feature.Type.CDS) continue;
            start = f3.getStart() - this.inOffset;
            end = f3.getEnd() - this.inOffset;
            Interval tr = null;
            trId = null;
            if (trLatest != null && trLatest.intersects(start, end)) {
                tr = trLatest;
                trId = tr.getId();
            } else {
                trId = f3.getTranscriptId();
                tr = this.findTranscript(trId);
            }
            if (tr == null) {
                Object gene = null;
                gene = geneLatest != null && geneLatest.intersects(start, end) ? geneLatest : this.findOrCreateGene(f3, this.chromosome, false);
                if (this.debug) {
                    System.err.println("Transcript '" + trId + "' not found. Creating new transcript for gene '" + ((Interval)gene).getId() + "'.\n" + f3);
                }
                if (trId == null) {
                    trId = "Tr_" + start + "_" + end;
                }
                if ((tr = this.findTranscript(trId)) == null) {
                    tr = new Transcript((Gene)gene, start, end, f3.isComplement(), trId);
                    this.add((Transcript)tr);
                }
            }
            if (f3.getAasequence() != null) {
                ((Transcript)tr).setProteinCoding(true);
            }
            if (f3.get("ribosomal_slippage") != null) {
                ((Transcript)tr).setRibosomalSlippage(true);
            }
            if (f3.hasMultipleCoordinates()) {
                for (FeatureCoordinates fc : f3) {
                    Cds cds = new Cds((Transcript)tr, fc.start - this.inOffset, fc.end - this.inOffset, f3.isComplement(), "CDS_" + trId);
                    ((Transcript)tr).add(cds);
                    this.add(cds);
                }
                continue;
            }
            Cds cds = new Cds((Transcript)tr, f3.getStart() - this.inOffset, f3.getEnd() - this.inOffset, f3.isComplement(), "CDS_" + trId);
            this.add(cds);
        }
    }

    String chromoName(Features features, Feature sourceFeature) {
        String chrName;
        if (sourceFeature != null) {
            if (sourceFeature.getType() != Feature.Type.SOURCE) {
                throw new RuntimeException("Cannot find chromosome name in a non-SOURCE feature");
            }
            chrName = sourceFeature.get("chromosome");
            if (chrName != null) {
                return chrName;
            }
        }
        if ((chrName = features.getLocusName()) != null) {
            return chrName;
        }
        return this.genome.getId();
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            for (Features features : this.featuresFile) {
                this.chromosome = null;
                this.addFeatures(features);
                this.beforeExonSequences();
                String sequence2 = this.sequence(features);
                this.addSequences(this.chromosome.getId(), sequence2);
            }
            this.finishUp();
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(Feature f2, Chromosome chr, boolean warn) {
        int start = f2.getStart() - this.inOffset;
        int end = f2.getEnd() - this.inOffset;
        String geneId = this.geneId(f2, start, end);
        String geneName = this.geneName(f2, start, end);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            gene = new Gene(chr, start, end, f2.isComplement(), geneId, geneName, "");
            this.add(gene);
            if (this.debug) {
                System.err.println("WARNING: Gene '" + geneId + "' not found: created.");
            }
        }
        return gene;
    }

    protected String geneId(Feature f2, int start, int end) {
        String geneId = f2.getGeneId();
        if (geneId != null) {
            return geneId;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String geneName(Feature f2, int start, int end) {
        String geneName = f2.getGeneName();
        if (geneName != null) {
            return geneName;
        }
        return "Gene_" + start + "_" + end;
    }

    String sequence(Features features) {
        String seq2 = features.getSequence();
        if (seq2 != null && !seq2.isEmpty()) {
            return seq2;
        }
        if (this.verbose) {
            System.out.println("No sequence found in feature file.");
        }
        for (String fastaFile : this.config.getFileListGenomeFasta()) {
            if (this.verbose) {
                System.out.println("\tTrying fasta file '" + fastaFile + "'");
            }
            if (!Gpr.canRead(fastaFile) || (seq2 = GprSeq.fastaSimpleRead(fastaFile)) == null || seq2.isEmpty()) continue;
            return seq2;
        }
        throw new RuntimeException("Cannot find sequence for '" + this.config.getGenome().getVersion() + "'");
    }
}

