/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine.eff;

import ca.mcgill.mcb.pcingola.akka.vcfStr.WorkerVcfStr;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class WorkerEff
extends WorkerVcfStr {
    SnpEffCmdEff snpEffCmdEff;
    SnpEffectPredictor snpEffectPredictor;
    OutputFormatter outputFormatter;
    IntervalForest filterIntervals;

    public WorkerEff(SnpEffCmdEff snpEffCmdEff, SnpEffectPredictor snpEffectPredictor, OutputFormatter outputFormatter, IntervalForest filterIntervals) {
        this.snpEffCmdEff = snpEffCmdEff;
        this.snpEffectPredictor = snpEffectPredictor;
        this.outputFormatter = outputFormatter;
        this.filterIntervals = filterIntervals;
    }

    @Override
    public String calculate(VcfEntry vcfEntry) {
        if (vcfEntry == null) {
            return null;
        }
        try {
            vcfEntry.parse();
            if (this.filterIntervals != null && this.filterIntervals.query(vcfEntry).isEmpty()) {
                return null;
            }
            this.outputFormatter.startSection(vcfEntry);
            for (Variant variant : vcfEntry.variants()) {
                if (!variant.isVariant()) continue;
                VariantEffects variantEffects = this.snpEffectPredictor.variantEffect(variant);
                this.outputFormatter.startSection(variant);
                for (VariantEffect changeEffect : variantEffects) {
                    this.outputFormatter.add(changeEffect);
                }
                this.outputFormatter.endSection(variant);
            }
            this.outputFormatter.endSection(vcfEntry);
        }
        catch (Throwable t) {
            this.snpEffCmdEff.error(t, "Error while processing VCF entry (line " + vcfEntry.getLineNum() + ") :\n\t" + vcfEntry);
            t.printStackTrace();
        }
        return vcfEntry.toString();
    }
}

