/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.HashMap;

public class SnpEffCmdShow
extends SnpEff {
    ArrayList<String> transcriptIds = new ArrayList();

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.transcriptIds.add(arg);
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.transcriptIds.isEmpty()) {
            this.usage("Missing transcript IDs");
        }
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        System.out.println("Showing genes and transcripts using zero-based coordinates");
        HashMap<String, Transcript> trById = new HashMap<String, Transcript>();
        HashMap<String, Gene> geneById = new HashMap<String, Gene>();
        for (Gene g : this.config.getGenome().getGenes()) {
            geneById.put(g.getId(), g);
            for (Transcript tr : g) {
                trById.put(tr.getId(), tr);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String id : this.transcriptIds) {
            Gene gene = (Gene)geneById.get(id);
            Transcript tr = (Transcript)trById.get(id);
            if (gene != null) {
                this.showGene(gene, sb);
            } else if (tr != null) {
                this.showTranscript(tr, sb);
            } else {
                System.err.println("ID '" + id + "' not found.");
            }
            if (!this.debug) continue;
            String fileName = "showTr." + this.genomeVer + "." + trById + ".txt";
            System.err.println("Saving output to file '" + fileName + "'");
            Gpr.toFile("showtr.txt", sb.toString());
        }
        return true;
    }

    void showGene(Gene g, StringBuilder sb) {
        System.out.println("Gene:\t" + g.toString(false));
        for (Transcript tr : g) {
            this.showTranscript(tr, sb);
        }
    }

    void showTranscript(Transcript tr, StringBuilder sb) {
        String trStr = tr.toString(true);
        String art = tr.toStringAsciiArt(true);
        System.out.println("Transcript:\t" + trStr);
        System.out.println(Gpr.prependEachLine("\t\t", art) + "\n");
        sb.append(trStr + "\n");
        sb.append(art + "\n\n");
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff showTr genome_version gene_1 ... gene_N ... trId_1 ... trId_N");
        System.exit(-1);
    }
}

