/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.align.SmithWaterman;
import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.genBank.GenBankFile;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCds;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SnpEffCmdProtein
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double MAX_ERROR_RATE = 0.05;
    boolean codonTables;
    boolean storeAlignments;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String configFile = "snpEff.config";
    String proteinFile = "";
    HashMap<String, String> proteinByTrId;
    AutoHashMap<String, List<Transcript>> trByChromo;
    HashMap<String, SmithWaterman> alignmentByTrId = new HashMap();

    public static int diffCount(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        int count2 = 0;
        for (int j = 0; j < minLen; ++j) {
            if (s1.charAt(j) == s2.charAt(j)) continue;
            ++count2;
        }
        return count2;
    }

    public static String diffStr(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        char[] diff2 = new char[minLen];
        for (int j = 0; j < minLen; ++j) {
            diff2[j] = s1.charAt(j) != s2.charAt(j) ? 124 : 32;
        }
        return new String(diff2);
    }

    public SnpEffCmdProtein() {
    }

    public SnpEffCmdProtein(Config config) {
        this.config = config;
        this.proteinFile = config.getFileNameProteins();
    }

    public SnpEffCmdProtein(Config config, String proteinFile) {
        this.config = config;
        this.proteinFile = proteinFile;
    }

    public SnpEffCmdProtein(String genomeVer, String configFile, String proteinFile) {
        this.configFile = configFile;
        this.genomeVer = genomeVer;
        this.proteinFile = proteinFile;
    }

    void add(String trId, String seq2, int lineNum) {
        if (this.proteinByTrId.get(trId) != null && !this.proteinByTrId.get(trId).equals(seq2)) {
            System.err.println("ERROR: Different protein for the same transcript ID. This should never happen!!!\n\tLine number   : " + lineNum + "\n\tTranscript ID : '" + trId + "'" + "\n\tProtein       : " + this.proteinByTrId.get(trId) + "\n\tProtein (new) : " + seq2);
        }
        if (trId.indexOf(32) > 0) {
            trId = trId.split("\\s")[0];
        }
        this.proteinByTrId.put(trId, seq2);
        if (this.debug) {
            Gpr.debug("Adding proteinByTrId{'" + trId + "'} :\t" + seq2);
        }
    }

    void checkCodonTables() {
        if (this.verbose) {
            Timer.showStdErr("Comparing Proteins...");
        }
        this.createTrByChromo();
        for (Chromosome chromo : this.genome) {
            String chr = chromo.getId();
            for (CodonTable codonTable : CodonTables.getInstance()) {
                this.setCodonTable(chromo, codonTable);
                this.proteinCompare(chr, false);
            }
        }
        if (this.verbose) {
            Timer.showStdErr("done");
        }
    }

    void checkProteins() {
        if (this.verbose) {
            Timer.showStdErr("Comparing Proteins...");
        }
        if (this.codonTables) {
            this.checkCodonTables();
        } else {
            this.proteinCompare(null, true);
        }
    }

    void createTrByChromo() {
        this.trByChromo = new AutoHashMap(new ArrayList());
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                String chr = tr.getChromosomeName();
                this.trByChromo.getOrCreate(chr).add(tr);
            }
        }
    }

    boolean equals(String protein, String proteinRef) {
        if (protein.isEmpty() && proteinRef.isEmpty()) {
            return true;
        }
        if ((protein = this.proteinFormat(protein)).equals(proteinRef = this.proteinFormat(proteinRef))) {
            return true;
        }
        String refUnk = "";
        if (proteinRef.length() > 0 && protein.equals(refUnk = proteinRef.substring(0, proteinRef.length() - 1))) {
            return true;
        }
        String proteinNoStart = "";
        String refNoStart = "";
        if (protein.length() > 0 && proteinRef.length() > 0 && (proteinNoStart = protein.substring(1)).equals(refNoStart = proteinRef.substring(1))) {
            return true;
        }
        String proteinU = protein.replace('*', 'U');
        if (proteinU.equals(proteinRef) || proteinU.equals(refUnk)) {
            return true;
        }
        String proteinNoStartU = proteinNoStart.replace('*', 'U');
        return proteinNoStartU.equals(refNoStart);
    }

    public HashMap<String, SmithWaterman> getAlignmentByTrId() {
        return this.alignmentByTrId;
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalOk() {
        return this.totalOk;
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                if (arg.equalsIgnoreCase("-codonTables")) {
                    this.codonTables = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.proteinFile.isEmpty()) {
                this.proteinFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.proteinFile.isEmpty()) {
            this.usage("Missing protein_file parameter");
        }
    }

    double proteinCompare(String chr, boolean addTotals) {
        List<Transcript> trList = null;
        if (chr == null) {
            trList = new ArrayList();
            for (Gene g : this.genome.getGenes()) {
                for (Transcript tr : g) {
                    trList.add(tr);
                }
            }
        } else {
            trList = (List)this.trByChromo.get(chr);
        }
        if (trList.isEmpty()) {
            return 0.0;
        }
        int i = 1;
        if (this.verbose) {
            System.out.print((chr != null ? chr : "") + "\t");
        }
        int countNotFound = 0;
        int countOk = 0;
        int countErrors = 0;
        int countWarnings = 0;
        for (Transcript tr : trList) {
            String protein = tr.protein();
            String proteinReference = this.proteinByTrId.get(tr.getId());
            if (proteinReference == null) {
                if (tr.isProteinCoding()) {
                    ++countNotFound;
                    if (this.debug) {
                        System.err.println("\nWARNING:Cannot find Protein for transcript " + tr.getId());
                    } else if (this.verbose) {
                        System.out.print('-');
                    }
                }
            } else if (this.equals(protein, proteinReference)) {
                ++countOk;
                if (addTotals) {
                    tr.setAaCheck(true);
                }
                if (this.verbose) {
                    System.out.print('+');
                }
            } else {
                if (this.debug || this.storeAlignments || onlyOneError) {
                    protein = this.proteinFormat(protein);
                    proteinReference = this.proteinFormat(proteinReference);
                    SmithWaterman sw = new SmithWaterman(protein, proteinReference);
                    if (Math.max(protein.length(), proteinReference.length()) < SnpEffCmdCds.MAX_ALIGN_LENGTH) {
                        sw.align();
                    }
                    if (this.storeAlignments) {
                        this.alignmentByTrId.put(tr.getId(), sw);
                    }
                    int maxScore = Math.min(protein.length(), proteinReference.length());
                    int score = sw.getAlignmentScore();
                    if (this.debug || onlyOneError) {
                        System.err.println("\nERROR: Proteins do not match for transcript " + tr.getId() + "\tStrand:" + (tr.isStrandPlus() ? 1 : -1) + "\tExons: " + tr.numChilds() + "\n" + String.format("\tSnpEff protein     (%6d) : '%s'\n", protein.length(), protein) + String.format("\tReference protein  (%6d) : '%s'\n", proteinReference.length(), proteinReference) + "\tAlignment (Snpeff protein vs Reference protein)." + "\tScore: " + score + "\tMax. possible score: " + maxScore + "\tDiff: " + (maxScore - score) + "\n" + sw);
                        System.err.println("Transcript details:\n" + tr);
                    }
                } else if (this.verbose) {
                    System.out.print('*');
                }
                ++countErrors;
                if (onlyOneError) {
                    System.err.println("Transcript details:\n" + tr);
                    throw new RuntimeException("DIE");
                }
            }
            if (this.verbose && i % 100 == 0) {
                System.out.print("\n\t");
            }
            ++i;
        }
        double errorRate = (double)countErrors / (double)(countErrors + countOk);
        if (this.verbose) {
            System.out.println("\n");
        }
        System.out.println("\tProtein check:\t" + this.genome.getVersion() + (chr != null ? "\tChromosome: " + chr : "") + (chr != null ? "\tCodon table: " + CodonTables.getInstance().getTable(this.genome, chr).getName() : "") + "\tOK: " + countOk + "\tWarnings: " + countWarnings + "\tNot found: " + countNotFound + "\tErrors: " + countErrors + "\tError percentage: " + 100.0 * errorRate + "%");
        if (addTotals) {
            this.totalNotFound += countNotFound;
            this.totalOk += countOk;
            this.totalErrors += countErrors;
            this.totalWarnings += countWarnings;
        }
        return errorRate;
    }

    String proteinFormat(String protein) {
        int idxLast;
        if (protein.isEmpty()) {
            return "";
        }
        char lastChar = (protein = protein.toUpperCase()).charAt(idxLast = protein.length() - 1);
        if (lastChar == '*' || lastChar == '?') {
            protein = protein.substring(0, idxLast);
        }
        if ((protein = protein.replace('X', '?')).startsWith("?")) {
            protein = protein.substring(1);
        }
        return protein;
    }

    void readProteinFile() {
        if (this.verbose) {
            Timer.showStdErr("Reading proteins from file '" + this.proteinFile + "'...");
        }
        this.proteinByTrId = new HashMap();
        if (this.proteinFile.endsWith("txt") || this.proteinFile.endsWith("txt.gz")) {
            this.readProteinFileTxt();
        } else if (this.proteinFile.endsWith(".gbk")) {
            this.readProteinFileGenBank();
        } else {
            this.readProteinFileFasta();
        }
        if (this.verbose) {
            Timer.showStdErr("done (" + this.proteinByTrId.size() + " Proteins).");
        }
    }

    void readProteinFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.proteinFile);
        for (String seq2 : ffi) {
            String trId = ffi.getName();
            this.add(trId, seq2, ffi.getLineNum());
        }
    }

    void readProteinFileGenBank() {
        GenBankFile featuresFile = new GenBankFile(this.proteinFile);
        for (Features features : featuresFile) {
            String trIdPrev = null;
            for (Feature f2 : features.getFeatures()) {
                if (f2.getType() == Feature.Type.GENE) {
                    trIdPrev = null;
                    continue;
                }
                if (f2.getType() == Feature.Type.MRNA) {
                    trIdPrev = f2.getTranscriptId();
                    continue;
                }
                if (f2.getType() != Feature.Type.CDS) continue;
                String trId = trIdPrev;
                if (trId == null) {
                    trId = f2.getTranscriptId();
                }
                String seq2 = f2.getAasequence();
                if (this.debug) {
                    Gpr.debug(trId + "\t" + seq2);
                }
                if (trId == null || seq2 == null) continue;
                this.add(trId, seq2, -1);
            }
        }
    }

    void readProteinFileTxt() {
        String proteinData = Gpr.readFile(this.proteinFile);
        String[] proteinLines = proteinData.split("\n");
        int lineNum = 1;
        for (String proteinLine : proteinLines) {
            String[] field2 = proteinLine.split("\\s+");
            if (field2.length >= 2) {
                String seq2 = field2[1].trim();
                String trId = field2[0].trim();
                this.add(trId, seq2, lineNum);
            }
            ++lineNum;
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Checking database using protein sequences");
        }
        this.loadConfig();
        this.readProteinFile();
        this.loadDb();
        this.checkProteins();
        return true;
    }

    void setCodonTable(Chromosome chromo, CodonTable codonTable) {
        CodonTables.getInstance().set(this.genome, chromo, codonTable);
        for (Transcript tr : (List)this.trByChromo.get(chromo.getId())) {
            tr.resetCdsCache();
        }
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff protein [options] genome_version proteing_file");
        System.err.println("\nOptions:");
        System.err.println("\t-codonTables    : Try all codon tables on each chromosome and calculate error rates.");
        System.exit(-1);
    }
}

