/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.stats.ReadsOnMarkersModel;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;

public class SnpEffCmdLen
extends SnpEff {
    int readLength;
    int numIterations;
    int numReads;
    SnpEffectPredictor snpEffectPredictor;
    ReadsOnMarkersModel readsOnMarkersModel;

    void effectiveCodingLength() {
        if (this.verbose) {
            Timer.showStdErr("Calclating gene effective coding lengths");
        }
        System.out.println("gene.name\tgene.id\tchr\tstart\tend\teffective.length\tmax.cds.length");
        for (Chromosome chr : this.snpEffectPredictor.getGenome()) {
            if (this.verbose) {
                Timer.showStdErr("Effective coding lengths for chromosome " + chr.getId());
            }
            for (Gene gene : this.snpEffectPredictor.getGenome().getGenes()) {
                if (!gene.getChromosomeName().equals(chr.getId()) || !gene.isProteinCoding()) continue;
                int efflen = this.effectiveCodingLength(gene);
                int maxcds = this.maxcds(gene);
                System.out.println(gene.getGeneName() + "\t" + gene.getId() + "\t" + gene.getChromosomeName() + "\t" + (gene.getStart() + 1) + "\t" + (gene.getEnd() + 1) + "\t" + efflen + "\t" + maxcds);
                if (maxcds <= efflen) continue;
                throw new RuntimeException("CDS length is greter then effective length. This should never happen!");
            }
        }
    }

    int effectiveCodingLength(Gene gene) {
        byte[] coding = new byte[gene.size()];
        for (int i = 0; i < coding.length; ++i) {
            coding[i] = 0;
        }
        for (Transcript tr : gene) {
            int i;
            if (!tr.isProteinCoding()) continue;
            for (Exon ex : tr) {
                for (int i2 = ex.getStart(); i2 <= ex.getEnd(); ++i2) {
                    coding[i2 - gene.getStart()] = 1;
                }
                for (SpliceSite ss : ex.getSpliceSites()) {
                    if (!(ss instanceof SpliceSiteAcceptor) && !(ss instanceof SpliceSiteDonor)) continue;
                    for (i = ss.getStart(); i <= ss.getEnd(); ++i) {
                        coding[i - gene.getStart()] = 1;
                    }
                }
            }
            for (Intron intr : tr.introns()) {
                for (SpliceSite ss : intr.getSpliceSites()) {
                    if (!(ss instanceof SpliceSiteAcceptor) && !(ss instanceof SpliceSiteDonor)) continue;
                    for (i = ss.getStart(); i <= ss.getEnd(); ++i) {
                        coding[i - gene.getStart()] = 1;
                    }
                }
            }
        }
        int efflen = 0;
        for (int i = 0; i < coding.length; ++i) {
            if (coding[i] <= 0) continue;
            ++efflen;
        }
        return efflen;
    }

    int maxcds(Gene gene) {
        int max2 = 0;
        for (Transcript tr : gene) {
            if (!tr.isProteinCoding()) continue;
            max2 = Math.max(max2, tr.cds().length());
        }
        return max2;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-r")) {
                if (i + 1 < args.length) {
                    this.readLength = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                this.usage("Missing value for parameter '-r'");
                continue;
            }
            if (args[i].equals("-iter")) {
                if (i + 1 < args.length) {
                    this.numIterations = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                this.usage("Missing value for parameter '-iter'");
                continue;
            }
            if (args[i].equals("-reads")) {
                if (i + 1 < args.length) {
                    this.numReads = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                this.usage("Missing value for parameter '-reads'");
                continue;
            }
            if (args[i].equals("-r")) {
                if (i + 1 < args.length) {
                    this.readLength = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                this.usage("Missing value for parameter '-r'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            this.usage("Unknown parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.readLength < 0) {
            this.usage("Read length should be a non-negative number");
        }
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.snpEffectPredictor.buildForest();
        this.effectiveCodingLength();
        this.readsOnMarkersModel = new ReadsOnMarkersModel(this.snpEffectPredictor);
        this.readsOnMarkersModel.setVerbose(this.verbose);
        if (this.verbose) {
            Timer.showStdErr("Counting bases");
        }
        this.readsOnMarkersModel.run();
        if (!this.quiet) {
            System.out.println(this.readsOnMarkersModel);
        }
        if (this.numIterations > 0 && this.readLength > 0) {
            this.readsOnMarkersModel.randomSampling(this.numIterations, this.readLength, this.numReads);
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff len [options] genome_version");
        System.err.println("Options:");
        System.err.println("\t-r     <num> : Assume a read size of 'num' bases.");
        System.err.println("\t-iter  <num> : Perform 'num' iterations of random sampling.");
        System.err.println("\t-reads <num> : Each random sampling iteration has 'num' reads.");
        System.exit(-1);
    }
}

