/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalTree;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Timer;
import scala.collection.mutable.StringBuilder;

public class SnpEffCmdDump
extends SnpEff {
    DumpFormat dumpFormat = DumpFormat.DUMP;
    String chrStr = "";

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-chr")) {
                    this.chrStr = args[++i];
                    continue;
                }
                if (args[i].equals("-bed")) {
                    this.dumpFormat = DumpFormat.BED;
                    continue;
                }
                if (args[i].equals("-txt")) {
                    this.dumpFormat = DumpFormat.TXT;
                    continue;
                }
                this.usage("Unknown option '" + args[i] + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
                continue;
            }
            this.usage("Unknown parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void print() {
        if (this.dumpFormat == DumpFormat.TXT) {
            System.out.println("chr\tstart\tend\tstrand\ttype\tid\tgeneName\tgeneId\tnumberOfTranscripts\tcanonicalTranscriptLength\ttranscriptId\tcdsLength\tnumerOfExons\texonRank\texonSpliceType");
        }
        for (IntervalTree tree : this.config.getSnpEffectPredictor().getIntervalForest()) {
            for (Marker i : tree) {
                try {
                    this.print(i);
                    if (!(i instanceof Gene)) continue;
                    Gene g = (Gene)i;
                    for (Transcript t : g) {
                        this.print(t);
                        for (Cds c : t.getCds()) {
                            this.print(c);
                        }
                        for (Utr u : t.getUtrs()) {
                            this.print(u);
                        }
                        for (Exon e : t) {
                            this.print(e);
                        }
                        for (Intron intron : t.introns()) {
                            this.print(intron);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    void print(Marker marker) {
        if (this.dumpFormat == DumpFormat.BED) {
            this.printBed(marker);
        } else if (this.dumpFormat == DumpFormat.TXT) {
            this.printTxt(marker);
        }
    }

    void printBed(Marker marker) {
        String chr = this.chrStr + marker.getChromosome().getId();
        int start = marker.getStart();
        int end = marker.getEnd() + 1;
        String name = marker.getClass().getSimpleName() + "_" + marker.getId();
        System.out.println(chr + "\t" + start + "\t" + end + "\t" + name);
    }

    void printTxt(Marker marker) {
        String chr = this.chrStr + marker.getChromosome().getId();
        int start = marker.getStart();
        int end = marker.getEnd() + 1;
        StringBuilder info = new StringBuilder();
        info.append(chr);
        info.append("\t" + start);
        info.append("\t" + end);
        info.append("\t" + (marker.isStrandPlus() ? "+1" : "-1"));
        info.append("\t" + marker.getClass().getSimpleName());
        info.append("\t" + marker.getId());
        Gene gene = null;
        if (marker instanceof Gene) {
            gene = (Gene)marker;
        } else if (marker != null) {
            gene = (Gene)marker.findParent(Gene.class);
        }
        if (gene != null) {
            Transcript canonical = gene.canonical();
            info.append("\t" + gene.getGeneName() + "\t" + gene.getId() + "\t" + gene.numChilds() + "\t" + (canonical == null ? 0 : canonical.cds().length()));
        } else {
            info.append("\t\t\t\t");
        }
        Transcript tr = null;
        if (marker instanceof Transcript) {
            tr = (Transcript)marker;
        } else if (marker != null) {
            tr = (Transcript)marker.findParent(Transcript.class);
        }
        if (tr != null) {
            info.append("\t" + tr.getId() + "\t" + tr.cds().length() + "\t" + tr.numChilds());
        } else {
            info.append("\t\t\t");
        }
        Exon exon = null;
        if (marker instanceof Exon) {
            exon = (Exon)marker;
        } else if (marker != null) {
            exon = (Exon)marker.findParent(Exon.class);
        }
        if (exon != null) {
            info.append("\t" + exon.getRank() + "\t" + (Object)((Object)exon.getSpliceType()));
        } else {
            info.append("\t\t");
        }
        System.out.println(info);
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.config.getSnpEffectPredictor().buildForest();
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
        if (this.dumpFormat == DumpFormat.DUMP) {
            this.config.getSnpEffectPredictor().print();
        } else if (this.dumpFormat == DumpFormat.BED || this.dumpFormat == DumpFormat.TXT) {
            this.print();
        } else {
            throw new RuntimeException("Unimplemented format '" + (Object)((Object)this.dumpFormat) + "'");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff dump [options] genome_version");
        System.err.println("\t-bed                    : Dump in BED format (implies -0)");
        System.err.println("\t-chr <string>           : Prepend 'string' to chromosome name (e.g. 'chr1' instead of '1')");
        System.err.println("\t-txt                    : Dump as a TXT table (implies -1)");
        System.err.println("\nGeneric options:");
        System.err.println("\t-0                      : Output zero-based coordinates. ");
        System.err.println("\t-1                      : Output one-based coordinates");
        System.exit(-1);
    }

    public static enum DumpFormat {
        DUMP,
        BED,
        TXT;

    }
}

