/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.RegulationConsensusMultipleBed;
import ca.mcgill.mcb.pcingola.RegulationFileConsensus;
import ca.mcgill.mcb.pcingola.codons.FindRareAaIntervals;
import ca.mcgill.mcb.pcingola.fileIterator.MotifFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.RegulationGffFileIterator;
import ca.mcgill.mcb.pcingola.interval.ExonSpliceCharacterizer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Motif;
import ca.mcgill.mcb.pcingola.interval.RareAminoAcid;
import ca.mcgill.mcb.pcingola.motif.Jaspar;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCds;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdProtein;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGenBank;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGenesFile;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff2;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff3;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryKnownGene;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.File;
import java.util.Collection;

public class SnpEffCmdBuild
extends SnpEff {
    SnpEff.GeneDatabaseFormat geneDatabaseFormat = null;
    boolean storeAlignments;
    boolean storeSequences = false;
    String cellType = null;
    SnpEffCmdProtein snpEffCmdProtein;
    SnpEffCmdCds snpEffCmdCds;

    void checkDb() {
        String cdsFile = this.config.getFileNameCds();
        if (Gpr.canRead(cdsFile)) {
            if (this.verbose) {
                Timer.showStdErr("CDS check (FASTA file): '" + cdsFile + "'\n");
            }
            this.snpEffCmdCds = new SnpEffCmdCds(this.config);
            this.snpEffCmdCds.setVerbose(this.verbose);
            this.snpEffCmdCds.setDebug(this.debug);
            this.snpEffCmdCds.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdCds.run();
        } else if (this.debug) {
            Timer.showStdErr("\tOptional file '" + cdsFile + "' not found, nothing done.");
        }
        String protFile = this.config.getFileNameProteins();
        if (Gpr.canRead(protFile)) {
            if (this.verbose) {
                Timer.showStdErr("Protein check (FASTA file): '" + protFile + "'\n");
            }
            this.snpEffCmdProtein = new SnpEffCmdProtein(this.config);
            this.snpEffCmdProtein.setVerbose(this.verbose);
            this.snpEffCmdProtein.setDebug(this.debug);
            this.snpEffCmdProtein.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdProtein.run();
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            String gbFile = this.config.getBaseFileNameGenes() + ".gbk";
            if (this.verbose) {
                Timer.showStdErr("Protein check (GenBank file): '" + gbFile + "'\n");
            }
            this.snpEffCmdProtein = new SnpEffCmdProtein(this.config, gbFile);
            this.snpEffCmdProtein.setVerbose(this.verbose);
            this.snpEffCmdProtein.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdProtein.run();
        } else if (this.debug) {
            Timer.showStdErr("\tOptional file '" + protFile + "' not found, nothing done.");
        }
    }

    SnpEffectPredictor createSnpEffPredictor() {
        if (this.geneDatabaseFormat == null) {
            this.geneDatabaseFormat = this.guessGenesFormat();
        }
        SnpEffPredictorFactory factory = null;
        if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GTF22) {
            factory = new SnpEffPredictorFactoryGtf22(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF3) {
            factory = new SnpEffPredictorFactoryGff3(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF2) {
            factory = new SnpEffPredictorFactoryGff2(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.REFSEQ) {
            factory = new SnpEffPredictorFactoryRefSeq(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.KNOWN_GENES) {
            factory = new SnpEffPredictorFactoryKnownGene(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            factory = new SnpEffPredictorFactoryGenBank(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL) {
            factory = new SnpEffPredictorFactoryEmbl(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.BIOMART) {
            factory = new SnpEffPredictorFactoryGenesFile(this.config);
        } else {
            throw new RuntimeException("Unimplemented format " + (Object)((Object)this.geneDatabaseFormat));
        }
        factory.setVerbose(this.verbose);
        factory.setDebug(this.debug);
        factory.setStoreSequences(this.storeSequences);
        return factory.create();
    }

    protected boolean fileExists(String path) {
        return Gpr.exists(path) || Gpr.exists(path + ".gz");
    }

    public SnpEffCmdCds getSnpEffCmdCds() {
        return this.snpEffCmdCds;
    }

    public SnpEffCmdProtein getSnpEffCmdProtein() {
        return this.snpEffCmdProtein;
    }

    protected SnpEff.GeneDatabaseFormat guessGenesFormat() {
        String genesBase = this.config.getBaseFileNameGenes();
        if (this.fileExists(genesBase + ".gtf")) {
            return SnpEff.GeneDatabaseFormat.GTF22;
        }
        if (this.fileExists(genesBase + ".gff")) {
            return SnpEff.GeneDatabaseFormat.GFF3;
        }
        if (this.fileExists(genesBase + ".gff2")) {
            return SnpEff.GeneDatabaseFormat.GFF2;
        }
        if (this.fileExists(genesBase + ".gbk")) {
            return SnpEff.GeneDatabaseFormat.GENBANK;
        }
        if (this.fileExists(genesBase + ".embl")) {
            return SnpEff.GeneDatabaseFormat.EMBL;
        }
        if (this.fileExists(genesBase + ".refseq")) {
            return SnpEff.GeneDatabaseFormat.REFSEQ;
        }
        if (this.fileExists(genesBase + ".kg")) {
            return SnpEff.GeneDatabaseFormat.KNOWN_GENES;
        }
        if (this.fileExists(genesBase + ".biomart")) {
            return SnpEff.GeneDatabaseFormat.BIOMART;
        }
        if (this.geneDatabaseFormat == null) {
            this.fatalError("Cannot guess input database format for genome '" + this.genomeVer + "'. No genes file found '" + genesBase + ".*'");
        }
        return null;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equalsIgnoreCase("-gff3")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF3;
                    continue;
                }
                if (arg.equalsIgnoreCase("-gff2")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF2;
                    continue;
                }
                if (arg.equalsIgnoreCase("-gtf22")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GTF22;
                    continue;
                }
                if (arg.equalsIgnoreCase("-refseq")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.REFSEQ;
                    continue;
                }
                if (arg.equalsIgnoreCase("-genbank")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GENBANK;
                    continue;
                }
                if (arg.equalsIgnoreCase("-knowngenes")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.KNOWN_GENES;
                    continue;
                }
                if (arg.equalsIgnoreCase("-embl")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.EMBL;
                    continue;
                }
                if (arg.equalsIgnoreCase("-txt")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.BIOMART;
                    continue;
                }
                if (arg.equalsIgnoreCase("-storeSeqs")) {
                    this.storeSequences = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-onlyReg")) {
                    this.onlyRegulation = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-cellType")) {
                    if (i + 1 < args.length) {
                        this.cellType = args[++i];
                        continue;
                    }
                    this.usage("Missing 'cellType' argument");
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void rareAa(SnpEffectPredictor snpEffectPredictor) {
        block7: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Rare amino acid annotations");
            }
            String proteinsFile = this.config.getFileNameProteins();
            try {
                FindRareAaIntervals findRare = new FindRareAaIntervals(snpEffectPredictor.getGenome());
                findRare.setVerbose(this.verbose);
                Collection<RareAminoAcid> raas = findRare.findRareAa(proteinsFile);
                for (RareAminoAcid raa : raas) {
                    if (this.verbose) {
                        System.err.println("\tAdding: " + raa);
                    }
                    snpEffectPredictor.add(raa);
                }
                if (this.verbose) {
                    Timer.showStdErr("Done.");
                }
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional protein sequence file '" + proteinsFile + "', nothing done.");
                }
                if (!this.debug) break block7;
                t.printStackTrace();
            }
        }
    }

    void readRegulationBed() {
        if (this.verbose) {
            Timer.showStdErr("[Optional] Reading regulation elements: BED ");
        }
        String inDir = this.config.getDirRegulationBed();
        String outDir = this.config.getDirDataVersion();
        File dir = new File(inDir);
        if (!dir.exists() || !dir.isDirectory()) {
            if (this.verbose) {
                Timer.showStdErr("Cannot find optional regulation dir '" + inDir + "', nothing done.");
            }
            return;
        }
        RegulationConsensusMultipleBed regBeds = new RegulationConsensusMultipleBed(inDir, outDir);
        regBeds.setVerbose(this.verbose);
        regBeds.setCellType(this.cellType);
        regBeds.run();
    }

    void readRegulationGff() {
        String regulationFileName;
        if (this.verbose) {
            Timer.showStdErr("[Optional] Reading regulation elements: GFF");
        }
        if (!Gpr.canRead(regulationFileName = this.config.getBaseFileNameRegulation() + ".gff")) {
            if (this.verbose) {
                Timer.showStdErr("Warning: Cannot read optional regulation file '" + regulationFileName + "', nothing done.");
            }
            return;
        }
        RegulationGffFileIterator regulationFileIterator = new RegulationGffFileIterator(regulationFileName);
        RegulationFileConsensus regulationGffConsensus = new RegulationFileConsensus(this.verbose);
        regulationGffConsensus.readFile(regulationFileIterator);
        regulationGffConsensus.save(this.config.getDirDataVersion());
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    void readRegulationMotif() {
        block11: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Reading motifs: GFF");
            }
            String motifFileName = this.config.getBaseFileNameMotif() + ".gff";
            String motifBinFileName = this.config.getBaseFileNameMotif() + ".bin";
            String pwmsFileName = this.config.getDirDataVersion() + "/pwms.bin";
            if (!Gpr.exists(pwmsFileName)) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot open PWMs file " + pwmsFileName + ". Nothing done");
                }
                return;
            }
            try {
                if (this.verbose) {
                    Timer.showStdErr("\tLoading PWMs from : " + pwmsFileName);
                }
                Jaspar jaspar = new Jaspar();
                jaspar.load(pwmsFileName);
                if (this.verbose) {
                    Timer.showStdErr("\tLoading motifs from : " + motifFileName);
                }
                MotifFileIterator motifFileIterator = new MotifFileIterator(motifFileName, this.config.getGenome(), jaspar);
                Markers motifs = new Markers();
                for (Motif motif : motifFileIterator) {
                    motifs.add(motif);
                }
                if (this.verbose) {
                    Timer.showStdErr("\tLoadded motifs: " + motifs.size());
                }
                if (this.verbose) {
                    Timer.showStdErr("\tSaving motifs to: " + motifBinFileName);
                }
                motifs.save(motifBinFileName);
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional motif file '" + motifFileName + "', nothing done.");
                }
                if (!this.debug) break block11;
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Building database for '" + this.genomeVer + "'");
        }
        this.loadConfig();
        if (!this.onlyRegulation) {
            SnpEffectPredictor snpEffectPredictor = this.createSnpEffPredictor();
            this.config.setSnpEffectPredictor(snpEffectPredictor);
            ExonSpliceCharacterizer exonSpliceCharacterizer = new ExonSpliceCharacterizer(snpEffectPredictor.getGenome());
            exonSpliceCharacterizer.setVerbose(this.verbose);
            exonSpliceCharacterizer.characterize();
            this.rareAa(snpEffectPredictor);
            this.checkDb();
            if (this.verbose) {
                Timer.showStdErr("Saving database");
            }
            snpEffectPredictor.save(this.config);
        }
        if (this.cellType == null) {
            this.readRegulationGff();
        }
        this.readRegulationBed();
        this.readRegulationMotif();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return true;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff build [options] genome_version");
        System.err.println("\nBuild DB options:");
        System.err.println("\t-embl                   : Use Embl format. It implies '-1'.");
        System.err.println("\t-genbank                : Use GenBank format. It implies '-1'.");
        System.err.println("\t-gff2                   : Use GFF2 format (obsolete). It implies '-1'.");
        System.err.println("\t-gff3                   : Use GFF3 format. It implies '-1'");
        System.err.println("\t-gtf22                  : Use GTF 2.2 format. It implies '-1'. Default");
        System.err.println("\t-knowngenes             : Use KnownGenes table from UCSC. It implies '-0'.");
        System.err.println("\t-refseq                 : Use RefSeq table from UCSC. It implies '-0'.");
        System.err.println("\t-onlyReg                : Only build regulation tracks.");
        System.err.println("\t-storeSeqs              : Store sequence in binary files. Default: " + this.storeSequences);
        System.err.println("\t-txt                    : Use TXT format (obsolete).");
        System.err.println("\t-cellType <type>        : Only build regulation tracks for cellType <type>.");
        System.err.println("\nGeneric options:");
        System.err.println("\t-0                      : File positions are zero-based (same as '-inOffset 0 -outOffset 0')");
        System.err.println("\t-1                      : File positions are one-based (same as '-inOffset 1 -outOffset 1')");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-if, -inOffset          : Offset input by a number of bases. E.g. '-inOffset 1' for one-based input files");
        System.err.println("\t-of, -outOffset         : Offset output by a number of bases. E.g. '-outOffset 1' for one-based output files");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-q , -quiet             : Quiet mode (do not show any messages or errors)");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }
}

