/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Motif;
import ca.mcgill.mcb.pcingola.interval.NextProt;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.logStatsServer.LogStats;
import ca.mcgill.mcb.pcingola.logStatsServer.VersionCheck;
import ca.mcgill.mcb.pcingola.motif.Jaspar;
import ca.mcgill.mcb.pcingola.motif.Pwm;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.CommandLine;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdAcat;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdBuild;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdBuildNextProt;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCds;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdClosest;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCount;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdDatabases;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdDownload;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdDump;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdGenes2Bed;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdGsa;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdLen;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdProtein;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdShow;
import ca.mcgill.mcb.pcingola.spliceSites.SnpEffCmdSpliceAnalysis;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SnpEff
implements CommandLine {
    public static final String DEFAULT_COMMAND = "ann";
    public static final int COMMAND_LINE_WIDTH = 40;
    public static final String SOFTWARE_NAME = "SnpEff";
    public static final String REVISION = "i";
    public static final String BUILD = "2015-08-14";
    public static final String VERSION_MAJOR = "4.1";
    public static final String VERSION_SHORT = "4.1i";
    public static final String VERSION_NO_NAME = "4.1i (build 2015-08-14), by Pablo Cingolani";
    public static final String VERSION = "SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani";
    protected String command = "";
    protected String[] args;
    protected String[] shiftArgs;
    protected boolean canonical = false;
    protected boolean debug = false;
    protected boolean download = true;
    protected boolean help;
    protected boolean log = true;
    protected boolean motif = true;
    protected boolean multiThreaded = false;
    protected boolean nextProt = true;
    protected boolean nextProtKeepAllTrs = false;
    protected boolean noGenome = false;
    protected boolean onlyProtein = false;
    protected boolean onlyRegulation = false;
    protected boolean quiet = false;
    protected boolean shiftHgvs = true;
    protected boolean strict = false;
    protected boolean saveOutput = false;
    protected boolean suppressOutput = false;
    protected boolean verbose = false;
    protected Boolean treatAllAsProteinCoding = null;
    protected int numWorkers = Gpr.NUM_CORES;
    protected int spliceSiteSize = 2;
    protected int spliceRegionExonSize = 3;
    protected int spliceRegionIntronMin = 3;
    protected int spliceRegionIntronMax = 8;
    protected int upDownStreamLength = 5000;
    protected String configFile = "snpEff.config";
    protected String dataDir;
    protected String genomeVer = "";
    protected String onlyTranscriptsFile = null;
    protected StringBuilder output = new StringBuilder();
    protected Config config;
    protected Genome genome;
    protected SnpEff snpEffCmd;
    protected ArrayList<String> customIntervalFiles;
    protected ArrayList<String> filterIntervalFiles;
    protected HashSet<String> regulationTracks = new HashSet();
    protected Map<String, String> configOverride = new HashMap<String, String>();

    public static void main(String[] args) {
        SnpEff snpEff = new SnpEff(args);
        boolean ok = snpEff.run();
        System.exit(ok ? 0 : -1);
    }

    public static void warning(String warningType, String details) {
        Config.get().warning(warningType, details);
    }

    public SnpEff() {
        this.customIntervalFiles = new ArrayList();
    }

    public SnpEff(String[] args) {
        this.customIntervalFiles = new ArrayList();
        this.args = args;
    }

    public void addRegulationTrack(String cellType) {
        this.regulationTracks.add(cellType);
    }

    void checkNewVersion(Config config) {
        if (config != null && !this.command.equalsIgnoreCase("download")) {
            VersionCheck versionCheck = VersionCheck.version(SOFTWARE_NAME, VERSION_SHORT, config.getVersionsUrl(), this.verbose);
            if (!this.quiet && versionCheck.isNewVersion()) {
                System.err.println("\n\nNEW VERSION!\n\tThere is a new " + this.getClass().getSimpleName() + " version available: " + "\n\t\tVersion      : " + versionCheck.getLatestVersion() + "\n\t\tRelease date : " + versionCheck.getLatestReleaseDate() + "\n\t\tDownload URL : " + versionCheck.getLatestUrl() + "\n");
            }
        }
    }

    String commandLineStr(boolean splitLines) {
        if (this.args == null) {
            return "";
        }
        StringBuilder argsList = new StringBuilder();
        argsList.append("SnpEff " + this.command + " ");
        int size2 = argsList.length();
        for (String arg : this.args) {
            argsList.append(arg.trim());
            if (splitLines && (size2 += arg.length()) > 40) {
                argsList.append(" \n");
                size2 = 0;
                continue;
            }
            argsList.append(" ");
            ++size2;
        }
        return argsList.toString();
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        if (!this.quiet) {
            System.err.println("Error: " + message);
        }
    }

    public void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getOutput() {
        return this.output.toString();
    }

    protected boolean isOpt(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    public void load() {
        this.loadConfig();
        this.loadDb();
    }

    protected void loadConfig() {
        if (this.config != null) {
            return;
        }
        if (this.verbose) {
            Timer.showStdErr("Reading configuration file '" + this.configFile + "'" + (this.genomeVer != null && !this.genomeVer.isEmpty() ? ". Genome: '" + this.genomeVer + "'" : ""));
        }
        this.config = new Config(this.genomeVer, this.configFile, this.dataDir, this.configOverride, this.verbose);
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.config.setDebug(this.debug);
        this.config.setVerbose(this.verbose);
    }

    protected int loadCustomFile(String fileName) {
        Markers markers = this.loadMarkers(fileName);
        for (Marker m : markers) {
            this.config.getSnpEffectPredictor().add(m);
        }
        return markers.size();
    }

    public void loadDb() {
        if (this.config.getSnpEffectPredictor() != null) {
            this.genome = this.config.getSnpEffectPredictor().getGenome();
            return;
        }
        if (this.noGenome) {
            if (this.verbose) {
                Timer.showStdErr("Creating empty database (no genome).");
            }
            SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(new Genome());
            this.config.setSnpEffectPredictor(snpEffectPredictor);
            this.config.setErrorOnMissingChromo(false);
            this.config.setErrorChromoHit(false);
        } else if (this.onlyRegulation) {
            this.config.setSnpEffectPredictor(new SnpEffectPredictor(this.config.getGenome()));
            this.config.setOnlyRegulation(true);
            this.config.setErrorOnMissingChromo(false);
            this.config.setErrorChromoHit(false);
        } else {
            if (this.verbose) {
                Timer.showStdErr("Reading database for genome version '" + this.genomeVer + "' from file '" + this.config.getFileSnpEffectPredictor() + "' (this might take a while)");
            }
            if (this.download && !Gpr.canRead(this.config.getFileSnpEffectPredictor())) {
                String[] downloadArgs;
                SnpEffCmdDownload snpEffCmdDownload;
                boolean ok;
                if (this.verbose) {
                    Timer.showStdErr("Database not installed\n\tAttempting to download and install database '" + this.genomeVer + "'");
                }
                if (!(ok = this.run(snpEffCmdDownload = new SnpEffCmdDownload(), downloadArgs = new String[]{this.genomeVer}, null))) {
                    throw new RuntimeException("Genome download failed!");
                }
                if (this.verbose) {
                    Timer.showStdErr("Database installed.");
                }
            }
            this.config.loadSnpEffectPredictor();
            this.genome = this.config.getSnpEffectPredictor().getGenome();
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.treatAllAsProteinCoding != null) {
            this.config.setTreatAllAsProteinCoding(this.treatAllAsProteinCoding);
        } else {
            boolean tapc;
            boolean bl = tapc = !this.config.getGenome().hasCodingInfo();
            if (this.debug) {
                Timer.showStdErr("Setting '-treatAllAsProteinCoding' to '" + tapc + "'");
            }
            this.config.setTreatAllAsProteinCoding(tapc);
        }
        for (String intFile : this.customIntervalFiles) {
            if (this.verbose) {
                Timer.showStdErr("Reading interval file '" + intFile + "'");
            }
            int count2 = this.loadCustomFile(intFile);
            if (!this.verbose) continue;
            Timer.showStdErr("done (" + count2 + " intervals loaded). ");
        }
        for (String regTrack : this.regulationTracks) {
            this.loadRegulationTrack(regTrack);
        }
        this.config.getSnpEffectPredictor().setUpDownStreamLength(this.upDownStreamLength);
        this.config.getSnpEffectPredictor().setSpliceSiteSize(this.spliceSiteSize);
        this.config.getSnpEffectPredictor().setSpliceRegionExonSize(this.spliceRegionExonSize);
        this.config.getSnpEffectPredictor().setSpliceRegionIntronMin(this.spliceRegionIntronMin);
        this.config.getSnpEffectPredictor().setSpliceRegionIntronMax(this.spliceRegionIntronMax);
        this.config.setShiftHgvs(this.shiftHgvs);
        if (this.canonical) {
            if (this.verbose) {
                Timer.showStdErr("Filtering out non-canonical transcripts.");
            }
            this.config.getSnpEffectPredictor().removeNonCanonical();
            if (this.verbose) {
                Timer.showStdErr("Canonical transcripts:\n\t\tgeneName\tgeneId\ttranscriptId\tcdsLength");
                for (Gene g : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
                    for (Transcript t : g) {
                        String cds = t.cds();
                        int cdsLen = cds != null ? cds.length() : 0;
                        System.err.println("\t\t" + g.getGeneName() + "\t" + g.getId() + "\t" + t.getId() + "\t" + cdsLen);
                    }
                }
            }
            if (this.verbose) {
                Timer.showStdErr("done.");
            }
        }
        if (this.strict) {
            if (this.verbose) {
                Timer.showStdErr("Filtering out non-verified transcripts.");
            }
            if (this.config.getSnpEffectPredictor().removeUnverified()) {
                this.fatalError("All transcripts have been removed form every single gene!\nUsing strickt on this database leaves no information.");
            }
            if (this.verbose) {
                Timer.showStdErr("done.");
            }
        }
        if (this.onlyTranscriptsFile != null) {
            String onlyTr = Gpr.readFile(this.onlyTranscriptsFile);
            HashSet<String> trIds = new HashSet<String>();
            for (String trId : onlyTr.split("\n")) {
                trIds.add(trId.trim());
            }
            if (this.verbose) {
                Timer.showStdErr("Filtering out transcripts in file '" + this.onlyTranscriptsFile + "'. Total " + trIds.size() + " transcript IDs.");
            }
            int removed = this.config.getSnpEffectPredictor().retainAllTranscripts(trIds);
            if (this.verbose) {
                Timer.showStdErr("Done: " + removed + " transcripts removed.");
            }
        }
        if (this.onlyProtein) {
            if (this.verbose) {
                Timer.showStdErr("Filtering out non-protein coding transcripts.");
            }
            int removed = this.config.getSnpEffectPredictor().retainTranscriptsProtein();
            if (this.verbose) {
                Timer.showStdErr("Done: " + removed + " transcripts removed.");
            }
        }
        if (this.nextProt) {
            this.loadNextProt();
        }
        if (this.motif) {
            this.loadMotif();
        }
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.config.getSnpEffectPredictor().buildForest();
        if (this.verbose) {
            Timer.showStdErr("done.");
        }
        if (this.verbose) {
            Timer.showStdErr("Genome stats :");
            System.err.println(this.config.getGenome());
        }
        this.genome = this.config.getSnpEffectPredictor().getGenome();
        this.genome.getGenomicSequences().setVerbose(this.verbose);
    }

    protected Markers loadMarkers(String fileName) {
        Markers markersSeqChange = Markers.readMarkers(fileName);
        String label = Gpr.removeExt(Gpr.baseName(fileName));
        Markers markers = new Markers();
        for (Marker m : markersSeqChange) {
            if (m instanceof Custom) {
                ((Custom)m).setLabel(label);
                markers.add(m);
                continue;
            }
            Custom custom = new Custom(m.getParent(), m.getStart(), m.getEnd(), m.isStrandMinus(), m.getId(), label);
            markers.add(custom);
        }
        return markers;
    }

    void loadMotif() {
        String pwmsFileName = this.config.getDirDataVersion() + "/pwms.bin";
        String motifBinFileName = this.config.getBaseFileNameMotif() + ".bin";
        if (!Gpr.exists(pwmsFileName) || !Gpr.exists(motifBinFileName)) {
            if (this.verbose) {
                Timer.showStdErr("Loading Motifs and PWMs");
            }
            if (this.debug) {
                if (!Gpr.exists(pwmsFileName)) {
                    SnpEff.warning("Warning: Cannot open PWMs file ", pwmsFileName);
                }
                if (!Gpr.exists(motifBinFileName)) {
                    SnpEff.warning("Warning: Cannot open Motifs file ", motifBinFileName);
                }
            }
            return;
        }
        if (this.verbose) {
            Timer.showStdErr("\tLoading PWMs from : " + pwmsFileName);
        }
        Jaspar jaspar = new Jaspar();
        jaspar.load(pwmsFileName);
        if (this.verbose) {
            Timer.showStdErr("\tLoading Motifs from file '" + motifBinFileName + "'");
        }
        MarkerSerializer markerSerializer = new MarkerSerializer(this.genome);
        Markers motifsDb = markerSerializer.load(motifBinFileName);
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        int countAddded = 0;
        for (Marker m : motifsDb) {
            if (!(m instanceof Motif)) continue;
            Motif motif = (Motif)m;
            Pwm pwm = jaspar.getPwm(motif.getPwmId());
            if (pwm != null) {
                motif.setPwm(pwm);
                snpEffectPredictor.add(motif);
                ++countAddded;
                continue;
            }
            if (!this.debug) continue;
            Timer.showStdErr("Cannot find PWM for motif '" + motif.getPwmId() + "'");
        }
        if (this.verbose) {
            Timer.showStdErr("\tMotif database: " + countAddded + " markers loaded.");
        }
    }

    void loadNextProt() {
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        String nextProtBinFile = this.config.getDirDataVersion() + "/nextProt.bin";
        if (!Gpr.canRead(nextProtBinFile)) {
            if (this.debug) {
                Timer.showStdErr("NextProt database '" + nextProtBinFile + "' doesn't exist. Ignoring.");
            }
            return;
        }
        if (this.verbose) {
            Timer.showStdErr("Reading NextProt database from file '" + nextProtBinFile + "'");
        }
        MarkerSerializer markerSerializer = new MarkerSerializer(this.genome);
        Markers nextProtDb = markerSerializer.load(nextProtBinFile);
        ArrayList<NextProt> nextProts = new ArrayList<NextProt>(nextProtDb.size());
        for (Object m : nextProtDb) {
            if (!(m instanceof NextProt)) continue;
            nextProts.add((NextProt)m);
        }
        if (this.verbose) {
            Timer.showStdErr("NextProt database: " + nextProts.size() + " markers loaded.");
        }
        if (this.verbose) {
            Timer.showStdErr("Adding transcript info to NextProt markers.");
        }
        HashMap<String, Transcript> trs = new HashMap<String, Transcript>();
        for (Gene g : snpEffectPredictor.getGenome().getGenes()) {
            for (Transcript tr : g) {
                trs.put(tr.getId(), tr);
            }
        }
        if (this.nextProtKeepAllTrs) {
            for (NextProt np : nextProts) {
                snpEffectPredictor.add(np);
            }
        } else {
            ArrayList<NextProt> nextProtsToAdd = new ArrayList<NextProt>();
            for (NextProt np : nextProts) {
                Transcript tr;
                tr = (Transcript)trs.get(np.getTranscriptId());
                if (tr == null) continue;
                np.setParent(tr);
                nextProtsToAdd.add(np);
            }
            for (NextProt np : nextProtsToAdd) {
                snpEffectPredictor.add(np);
            }
            if (this.verbose) {
                Timer.showStdErr("NextProt database: " + nextProtsToAdd.size() + " markers added.");
            }
        }
    }

    void loadRegulationTrack(String regTrack) {
        if (this.verbose) {
            Timer.showStdErr("Reading regulation track '" + regTrack + "'");
        }
        String regFile = this.config.getDirDataVersion() + "/regulation_" + regTrack + ".bin";
        Markers regulation = new Markers();
        regulation.load(regFile, this.genome);
        Genome genome = this.config.getGenome();
        HashMap<String, Integer> chrs = new HashMap<String, Integer>();
        for (Marker r : regulation) {
            String chr = r.getChromosomeName();
            int max2 = chrs.containsKey(chr) ? (Integer)chrs.get(chr) : 0;
            max2 = Math.max(max2, r.getEnd());
            chrs.put(chr, max2);
        }
        for (String chr : chrs.keySet()) {
            if (genome.getChromosome(chr) != null) continue;
            genome.add(new Chromosome(genome, 0, (Integer)chrs.get(chr), chr));
        }
        this.config.getSnpEffectPredictor().addAll(regulation);
    }

    @Override
    public void parseArgs(String[] args) {
        if (args == null) {
            this.command = DEFAULT_COMMAND;
            return;
        }
        if (args.length <= 0) {
            this.usage(null);
        }
        int argNum = 0;
        if (args[0].equalsIgnoreCase("build") || args[0].equalsIgnoreCase("buildNextProt") || args[0].equalsIgnoreCase("dump") || args[0].equalsIgnoreCase("cds") || args[0].equalsIgnoreCase("eff") || args[0].equalsIgnoreCase(DEFAULT_COMMAND) || args[0].equalsIgnoreCase("download") || args[0].equalsIgnoreCase("protein") || args[0].equalsIgnoreCase("closest") || args[0].equalsIgnoreCase("test") || args[0].equalsIgnoreCase("databases") || args[0].equalsIgnoreCase("spliceAnalysis") || args[0].equalsIgnoreCase("count") || args[0].equalsIgnoreCase("genes2bed") || args[0].equalsIgnoreCase("gsa") || args[0].equalsIgnoreCase("len") || args[0].equalsIgnoreCase("acat") || args[0].equalsIgnoreCase("show")) {
            this.command = args[argNum++].trim().toLowerCase();
        }
        ArrayList<String> argsList = new ArrayList<String>();
        block76: for (int i = argNum; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-c": 
                    case "-config": {
                        if (i + 1 < args.length) {
                            this.configFile = args[++i];
                            break;
                        }
                        this.usage("Option '-c' without config file argument");
                        break;
                    }
                    case "-configoption": {
                        if (i + 1 < args.length) {
                            String nameValue;
                            String[] nv;
                            if ((nv = (nameValue = args[++i]).split("=", 2)).length > 0) {
                                this.configOverride.put(nv[0], nv[1]);
                                break;
                            }
                            this.usage("Cannot parse config option (expected format 'name=value'): " + nameValue);
                            break;
                        }
                        this.usage("Option '-configOption' without argument");
                        break;
                    }
                    case "-canon": {
                        this.canonical = true;
                        break;
                    }
                    case "-d": 
                    case "-debug": {
                        this.verbose = true;
                        this.debug = true;
                        break;
                    }
                    case "-datadir": {
                        if (i + 1 < args.length) {
                            this.dataDir = args[++i];
                            break;
                        }
                        this.usage("Option '-dataDir' without data_dir argument");
                        break;
                    }
                    case "-download": {
                        this.download = true;
                        break;
                    }
                    case "-h": 
                    case "-help": {
                        this.help = true;
                        if (!this.command.isEmpty()) continue block76;
                        this.usage(null);
                        break;
                    }
                    case "-interval": {
                        if (i + 1 < args.length) {
                            this.customIntervalFiles.add(args[++i]);
                            break;
                        }
                        this.usage("Option '-interval' without config interval_file argument");
                        break;
                    }
                    case "-motif": {
                        this.motif = true;
                        break;
                    }
                    case "-nogenome": {
                        this.noGenome = true;
                        break;
                    }
                    case "-nomotif": {
                        this.motif = false;
                        break;
                    }
                    case "-nextprot": {
                        this.nextProt = true;
                        break;
                    }
                    case "-nonextprot": {
                        this.nextProt = false;
                        break;
                    }
                    case "-nodownload": {
                        this.download = false;
                        break;
                    }
                    case "-nolog": {
                        this.log = false;
                        break;
                    }
                    case "-noout": {
                        this.suppressOutput = true;
                        break;
                    }
                    case "-noshifthgvs": 
                    case "-no_shift_hgvs": {
                        this.shiftHgvs = false;
                        break;
                    }
                    case "-onlyreg": {
                        this.onlyRegulation = true;
                        break;
                    }
                    case "-onlyprotein": {
                        this.onlyProtein = true;
                        break;
                    }
                    case "-onlytr": {
                        if (i + 1 < args.length) {
                            this.onlyTranscriptsFile = args[++i];
                            break;
                        }
                        this.usage("Option '-onltTr' without file argument");
                        break;
                    }
                    case "-q": 
                    case "-quiet": {
                        this.quiet = true;
                        this.verbose = false;
                        break;
                    }
                    case "-reg": {
                        if (i + 1 < args.length) {
                            this.addRegulationTrack(args[++i]);
                            break;
                        }
                        this.usage("Option '-reg' without file argument");
                        break;
                    }
                    case "-ss": 
                    case "-splicesitesize": {
                        if (i + 1 < args.length) {
                            this.spliceSiteSize = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-spliceSiteSize' without argument");
                        break;
                    }
                    case "-spliceregionexonsize": {
                        if (i + 1 < args.length) {
                            this.spliceRegionExonSize = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-spliceRegionExonSize' without argument");
                        break;
                    }
                    case "-spliceregionintronmin": {
                        if (i + 1 < args.length) {
                            this.spliceRegionIntronMin = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-spliceRegionIntronMin' without argument");
                        break;
                    }
                    case "-spliceregionintronmax": {
                        if (i + 1 < args.length) {
                            this.spliceRegionIntronMax = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-spliceRegionIntronMax' without argument");
                        break;
                    }
                    case "-strict": {
                        this.strict = true;
                        break;
                    }
                    case "-t": {
                        this.multiThreaded = true;
                        break;
                    }
                    case "-treatallasproteincoding": {
                        if (i + 1 >= args.length) continue block76;
                        if (args[++i].equalsIgnoreCase("auto")) {
                            this.treatAllAsProteinCoding = null;
                            break;
                        }
                        this.treatAllAsProteinCoding = Gpr.parseBoolSafe(args[i]);
                        break;
                    }
                    case "-ud": 
                    case "-updownstreamlen": {
                        if (i + 1 < args.length) {
                            this.upDownStreamLength = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-upDownstreamLen' without argument");
                        break;
                    }
                    case "-v": 
                    case "-verbose": {
                        this.verbose = true;
                        this.quiet = false;
                        break;
                    }
                    case "-version": {
                        System.out.println(VERSION_SHORT);
                        System.exit(0);
                        break;
                    }
                    default: {
                        argsList.add(arg);
                    }
                }
                continue;
            }
            argsList.add(arg);
        }
        this.shiftArgs = argsList.toArray(new String[0]);
        if (this.command.isEmpty()) {
            this.command = DEFAULT_COMMAND;
        }
        if (!this.help && (this.verbose || this.debug)) {
            Timer.showStdErr("SnpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
            Timer.showStdErr("Command: '" + this.command + "'");
        }
    }

    void print(Object o) {
        if (this.saveOutput) {
            this.output.append(o.toString() + "\n");
        } else if (!this.suppressOutput) {
            System.out.println(o.toString());
        }
    }

    public HashMap<String, String> reportValues() {
        HashMap<String, String> reportValues = new HashMap<String, String>();
        return reportValues;
    }

    @Override
    public boolean run() {
        SnpEff snpEffCmd = this.snpEffCmd();
        if (snpEffCmd == null) {
            return true;
        }
        boolean ok = false;
        StringBuilder err2 = new StringBuilder();
        try {
            ok = snpEffCmd.run();
        }
        catch (Throwable t) {
            ok = false;
            if (err2 != null) {
                err2.append(t.getMessage());
            }
            t.printStackTrace();
        }
        if (this.config == null) {
            this.config = snpEffCmd.getConfig();
        }
        if (this.log) {
            LogStats.report(SOFTWARE_NAME, VERSION_SHORT, VERSION, ok, this.verbose, this.args, err2.toString(), snpEffCmd.reportValues());
            this.checkNewVersion(snpEffCmd.config);
        }
        return ok;
    }

    protected boolean run(SnpEff snpEff, String[] args, StringBuilder err2) {
        boolean ok = false;
        try {
            snpEff.verbose = this.verbose;
            snpEff.help = this.help;
            snpEff.debug = this.debug;
            snpEff.quiet = this.quiet;
            snpEff.configFile = this.configFile;
            snpEff.dataDir = this.dataDir;
            if (this.help) {
                snpEff.usage(null);
            } else {
                snpEff.parseArgs(args);
            }
            ok = snpEff.run();
        }
        catch (Throwable t) {
            if (err2 != null) {
                err2.append(t.getMessage());
            }
            t.printStackTrace();
        }
        return ok;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setGenomeVer(String genomeVer) {
        this.genomeVer = genomeVer;
    }

    public void setNextProtKeepAllTrs(boolean nextProtKeepAllTrs) {
        this.nextProtKeepAllTrs = nextProtKeepAllTrs;
    }

    public void setShiftHgvs(boolean shiftHgvs) {
        this.shiftHgvs = shiftHgvs;
    }

    public void setSpliceSiteSize(int spliceSiteSize) {
        this.spliceSiteSize = spliceSiteSize;
    }

    public void setSupressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public void setUpDownStreamLength(int upDownStreamLength) {
        this.upDownStreamLength = upDownStreamLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public SnpEff snpEffCmd() {
        this.parseArgs(this.args);
        SnpEff snpEffCmd = null;
        this.command = this.command.trim().toLowerCase();
        if (this.command.equalsIgnoreCase("build")) {
            snpEffCmd = new SnpEffCmdBuild();
        } else if (this.command.equalsIgnoreCase("buildNextProt")) {
            snpEffCmd = new SnpEffCmdBuildNextProt();
        } else if (this.command.equalsIgnoreCase("dump")) {
            snpEffCmd = new SnpEffCmdDump();
        } else if (this.command.equalsIgnoreCase("download")) {
            snpEffCmd = new SnpEffCmdDownload();
        } else if (this.command.equalsIgnoreCase("cds")) {
            snpEffCmd = new SnpEffCmdCds();
        } else if (this.command.equalsIgnoreCase("eff") || this.command.equalsIgnoreCase(DEFAULT_COMMAND)) {
            snpEffCmd = new SnpEffCmdEff();
        } else if (this.command.equalsIgnoreCase("protein")) {
            snpEffCmd = new SnpEffCmdProtein();
        } else if (this.command.equalsIgnoreCase("closest")) {
            snpEffCmd = new SnpEffCmdClosest();
        } else if (this.command.equalsIgnoreCase("databases")) {
            snpEffCmd = new SnpEffCmdDatabases();
        } else if (this.command.equalsIgnoreCase("genes2bed")) {
            snpEffCmd = new SnpEffCmdGenes2Bed();
        } else if (this.command.equalsIgnoreCase("spliceanalysis")) {
            snpEffCmd = new SnpEffCmdSpliceAnalysis();
        } else if (this.command.equalsIgnoreCase("count")) {
            snpEffCmd = new SnpEffCmdCount();
        } else if (this.command.equalsIgnoreCase("len")) {
            snpEffCmd = new SnpEffCmdLen();
        } else if (this.command.equalsIgnoreCase("gsa")) {
            snpEffCmd = new SnpEffCmdGsa();
        } else if (this.command.equalsIgnoreCase("acat")) {
            snpEffCmd = new SnpEffCmdAcat();
        } else if (this.command.equalsIgnoreCase("show")) {
            snpEffCmd = new SnpEffCmdShow();
        } else {
            throw new RuntimeException("Unknown command '" + this.command + "'");
        }
        snpEffCmd.canonical = this.canonical;
        snpEffCmd.configFile = this.configFile;
        snpEffCmd.customIntervalFiles = this.customIntervalFiles;
        snpEffCmd.dataDir = this.dataDir;
        snpEffCmd.debug = this.debug;
        snpEffCmd.download = this.download;
        snpEffCmd.filterIntervalFiles = this.filterIntervalFiles;
        snpEffCmd.genomeVer = this.genomeVer;
        snpEffCmd.help = this.help;
        snpEffCmd.log = this.log;
        snpEffCmd.motif = this.motif;
        snpEffCmd.multiThreaded = this.multiThreaded;
        snpEffCmd.nextProt = this.nextProt;
        snpEffCmd.noGenome = this.noGenome;
        snpEffCmd.numWorkers = this.numWorkers;
        snpEffCmd.onlyProtein = this.onlyProtein;
        snpEffCmd.onlyRegulation = this.onlyRegulation;
        snpEffCmd.onlyTranscriptsFile = this.onlyTranscriptsFile;
        snpEffCmd.quiet = this.quiet;
        snpEffCmd.regulationTracks = this.regulationTracks;
        snpEffCmd.spliceSiteSize = this.spliceSiteSize;
        snpEffCmd.spliceRegionExonSize = this.spliceRegionExonSize;
        snpEffCmd.spliceRegionIntronMax = this.spliceRegionIntronMax;
        snpEffCmd.spliceRegionIntronMin = this.spliceRegionIntronMin;
        snpEffCmd.strict = this.strict;
        snpEffCmd.suppressOutput = this.suppressOutput;
        snpEffCmd.treatAllAsProteinCoding = this.treatAllAsProteinCoding;
        snpEffCmd.upDownStreamLength = this.upDownStreamLength;
        snpEffCmd.verbose = this.verbose;
        snpEffCmd.shiftHgvs = this.shiftHgvs;
        snpEffCmd.configOverride = this.configOverride;
        if (this.help) {
            snpEffCmd.usage(null);
            return null;
        }
        snpEffCmd.parseArgs(this.shiftArgs);
        return snpEffCmd;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("SnpEff version SnpEff 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.err.println("Usage: snpEff [command] [options] [files]");
        System.err.println("\nRun 'java -jar snpEff.jar command' for help on each specific command");
        System.err.println("\nAvailable commands: ");
        System.err.println("\t[eff|ann]                    : Annotate variants / calculate effects (you can use either 'ann' or 'eff', they mean the same). Default: ann (no command or 'ann').");
        System.err.println("\tbuild                        : Build a SnpEff database.");
        System.err.println("\tbuildNextProt                : Build a SnpEff for NextProt (using NextProt's XML files).");
        System.err.println("\tcds                          : Compare CDS sequences calculated form a SnpEff database to the one in a FASTA file. Used for checking databases correctness.");
        System.err.println("\tclosest                      : Annotate the closest genomic region.");
        System.err.println("\tcount                        : Count how many intervals (from a BAM, BED or VCF file) overlap with each genomic interval.");
        System.err.println("\tdatabases                    : Show currently available databases (from local config file).");
        System.err.println("\tdownload                     : Download a SnpEff database.");
        System.err.println("\tdump                         : Dump to STDOUT a SnpEff database (mostly used for debugging).");
        System.err.println("\tgenes2bed                    : Create a bed file from a genes list.");
        System.err.println("\tlen                          : Calculate total genomic length for each marker type.");
        System.err.println("\tprotein                      : Compare protein sequences calculated form a SnpEff database to the one in a FASTA file. Used for checking databases correctness.");
        System.err.println("\tshow                         : Show a text representation of genes or transcripts coordiantes, DNA sequence and protein sequence.");
        System.err.println("\tspliceAnalysis               : Perform an analysis of splice sites. Experimental feature.");
        this.usageGenericAndDb();
        System.exit(-1);
    }

    protected void usageGenericAndDb() {
        System.err.println("\nGeneric options:");
        System.err.println("\t-c , -config                 : Specify config file");
        System.err.println("\t-configOption name=value     : Override a config file option");
        System.err.println("\t-d , -debug                  : Debug mode (very verbose).");
        System.err.println("\t-dataDir <path>              : Override data_dir parameter from config file.");
        System.err.println("\t-download                    : Download a SnpEff database, if not available locally. Default: " + this.download);
        System.err.println("\t-nodownload                  : Do not download a SnpEff database, if not available locally.");
        System.err.println("\t-noShiftHgvs                 : Do not shift variants towards most 3-prime position (as required by HGVS).");
        System.err.println("\t-h , -help                   : Show this help and exit");
        System.err.println("\t-noLog                       : Do not report usage statistics to server");
        System.err.println("\t-t                           : Use multiple threads (implies '-noStats'). Default 'off'");
        System.err.println("\t-q , -quiet                  : Quiet mode (do not show any messages or errors)");
        System.err.println("\t-v , -verbose                : Verbose mode");
        System.err.println("\t-version                     : Show version number and exit");
        System.err.println("\nDatabase options:");
        System.err.println("\t-canon                       : Only use canonical transcripts.");
        System.err.println("\t-interval <file>             : Use a custom intervals in TXT/BED/BigBed/VCF/GFF file (you may use this option many times)");
        System.err.println("\t-motif                       : Annotate using motifs (requires Motif database).");
        System.err.println("\t-nextProt                    : Annotate using NextProt (requires NextProt database).");
        System.err.println("\t-noGenome                    : Do not load any genomic database (e.g. annotate using custom files).");
        System.err.println("\t-noMotif                     : Disable motif annotations.");
        System.err.println("\t-noNextProt                  : Disable NextProt annotations.");
        System.err.println("\t-onlyReg                     : Only use regulation tracks.");
        System.err.println("\t-onlyProtein                 : Only use protein coding transcripts. Default: " + this.onlyProtein);
        System.err.println("\t-onlyTr <file.txt>           : Only use the transcripts in this file. Format: One transcript ID per line.");
        System.err.println("\t-reg <name>                  : Regulation track to use (this option can be used add several times).");
        System.err.println("\t-ss , -spliceSiteSize <int>  : Set size for splice sites (donor and acceptor) in bases. Default: " + this.spliceSiteSize);
        System.err.println("\t-spliceRegionExonSize <int>  : Set size for splice site region within exons. Default: " + this.spliceRegionExonSize + " bases");
        System.err.println("\t-spliceRegionIntronMin <int> : Set minimum number of bases for splice site region within intron. Default: " + this.spliceRegionIntronMin + " bases");
        System.err.println("\t-spliceRegionIntronMax <int> : Set maximum number of bases for splice site region within intron. Default: " + this.spliceRegionIntronMax + " bases");
        System.err.println("\t-strict                      : Only use 'validated' transcripts (i.e. sequence has been checked). Default: " + this.strict);
        System.err.println("\t-ud , -upDownStreamLen <int> : Set upstream downstream interval length (in bases)");
    }

    public static enum OutputFormat {
        VCF,
        BED,
        BEDANN,
        GATK;

    }

    public static enum InputFormat {
        VCF,
        BED;

    }

    public static enum GeneDatabaseFormat {
        BIOMART,
        GFF3,
        GFF2,
        GTF22,
        REFSEQ,
        KNOWN_GENES,
        GENBANK,
        EMBL;

    }
}

