/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Motif;
import ca.mcgill.mcb.pcingola.interval.NextProt;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.HgvsDna;
import ca.mcgill.mcb.pcingola.snpEffect.HgvsProtein;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class VariantEffect
implements Cloneable,
Comparable<VariantEffect> {
    public static final int MAX_CODON_SEQUENCE_LEN = 100;
    Variant variant = null;
    List<EffectType> effectTypes;
    EffectType effectType;
    List<EffectImpact> effectImpacts;
    EffectImpact effectImpact = null;
    Marker marker = null;
    String error = "";
    String warning = "";
    String message = "";
    String codonsRef = "";
    String codonsAlt = "";
    String codonsAroundOld = "";
    String codonsAroundNew = "";
    int distance = -1;
    int cDnaPos = -1;
    int codonNum = -1;
    int codonIndex = -1;
    int codonDegeneracy = -1;
    String aaRef = "";
    String aaAlt = "";
    String aasAroundOld = "";
    String aasAroundNew = "";

    public VariantEffect(Variant variant) {
        this.variant = variant;
        this.effectTypes = new ArrayList<EffectType>();
        this.effectImpacts = new ArrayList<EffectImpact>();
    }

    public VariantEffect(Variant variant, Marker marker, EffectType effectType, EffectImpact effectImpact, String message, String codonsOld, String codonsNew, int codonNum, int codonIndex, int cDnaPos) {
        this.variant = variant;
        this.effectTypes = new ArrayList<EffectType>();
        this.effectImpacts = new ArrayList<EffectImpact>();
        this.set(marker, effectType, effectImpact, message);
        this.setCodons(codonsOld, codonsNew, codonNum, codonIndex);
        this.cDnaPos = cDnaPos;
    }

    public void addEffect(EffectType effectType) {
        this.addEffectType(effectType);
        this.addEffectImpact(effectType.effectImpact());
    }

    public void addEffectImpact(EffectImpact effectImpact) {
        this.effectImpacts.add(effectImpact);
        this.effectImpact = null;
    }

    public void addEffectType(EffectType effectType) {
        this.effectTypes.add(effectType);
        this.effectType = null;
    }

    public void addErrorMessage(ErrorWarningType errmsg) {
        this.addErrorWarningInfo(errmsg);
    }

    public void addErrorWarningInfo(ErrorWarningType errwarn) {
        if (errwarn == null) {
            return;
        }
        if (errwarn.isError()) {
            if (this.error.indexOf(errwarn.toString()) < 0) {
                this.error = this.error + (this.error.isEmpty() ? "" : "&") + (Object)((Object)errwarn);
            }
        } else if (this.warning.indexOf(errwarn.toString()) < 0) {
            this.warning = this.warning + (this.warning.isEmpty() ? "" : "&") + (Object)((Object)errwarn);
        }
    }

    public void addInfoMessage(ErrorWarningType infomsg) {
        this.addErrorWarningInfo(infomsg);
    }

    public void addWarningMessge(ErrorWarningType warnmsg) {
        this.addErrorWarningInfo(warnmsg);
    }

    public VariantEffect clone() {
        try {
            return (VariantEffect)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    String codonEffect(boolean showAaChange, boolean showBioType, boolean useSeqOntology, boolean useFirstEffect) {
        if (this.marker == null || this.codonNum < 0) {
            return "";
        }
        if (!showAaChange) {
            return this.getEffectTypeString(useSeqOntology, useFirstEffect);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEffectTypeString(useSeqOntology, useFirstEffect));
        sb.append("(");
        sb.append(this.getAaChange());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(VariantEffect varEffOther) {
        int comp = this.getEffectImpact().compareTo(varEffOther.getEffectImpact());
        if (comp != 0) {
            return comp;
        }
        comp = this.getEffectType().compareTo(varEffOther.getEffectType());
        if (comp != 0) {
            return comp;
        }
        Transcript trThis = this.getTranscript();
        Transcript trOther = varEffOther.getTranscript();
        if (trThis != null && trOther != null) {
            comp = (trOther.isCanonical() ? 1 : 0) - (trThis.isCanonical() ? 1 : 0);
        }
        if (comp != 0) {
            return comp;
        }
        if (trThis != null && trOther != null) {
            comp = trThis.compareToPos(trOther);
        }
        if (comp != 0) {
            return comp;
        }
        if (trThis != null && trOther != null) {
            comp = trThis.getId().compareTo(trOther.getId());
        }
        if (comp != 0) {
            return comp;
        }
        if (this.getMarker() != null && varEffOther.getMarker() != null) {
            comp = this.getMarker().compareToPos(varEffOther.getMarker());
        }
        if (comp != 0) {
            return comp;
        }
        return this.variant.compareTo(varEffOther.getVariant());
    }

    public String effect(boolean shortFormat, boolean showAaChange, boolean showBioType, boolean useSeqOntology, boolean useFirstEffect) {
        String e = "";
        String codonEffect = this.codonEffect(showAaChange, showBioType, useSeqOntology, useFirstEffect);
        if (!codonEffect.isEmpty()) {
            e = codonEffect;
        } else {
            if (this.isRegulation()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + ((Regulation)this.marker).getName() + "]";
            }
            if (this.isNextProt()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + VcfEffect.vcfEffSafe(((NextProt)this.marker).getId()) + "]";
            }
            if (this.isMotif()) {
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + "[" + ((Motif)this.marker).getPwmId() + ":" + ((Motif)this.marker).getPwmName() + "]";
            }
            if (this.isCustom()) {
                String label = ((Custom)this.marker).getLabel();
                double score = ((Custom)this.marker).getScore();
                if (!Double.isNaN(score)) {
                    label = label + ":" + score;
                }
                if (!label.isEmpty()) {
                    label = "[" + label + "]";
                }
                return this.getEffectTypeString(useSeqOntology, useFirstEffect) + label;
            }
            e = this.isIntergenic() || this.isIntron() || this.isSpliceSite() ? this.getEffectTypeString(useSeqOntology, useFirstEffect) : (!this.message.isEmpty() ? this.getEffectTypeString(useSeqOntology, useFirstEffect) + ": " + this.message : (this.marker == null ? this.getEffectTypeString(useSeqOntology, useFirstEffect) : this.getEffectTypeString(useSeqOntology, useFirstEffect) + ": " + this.marker.getId()));
        }
        if (shortFormat) {
            e = e.split(":")[0];
        }
        return e;
    }

    public String getAaAlt() {
        return this.aaAlt;
    }

    public String getAaChange() {
        if (this.aaRef.isEmpty() && this.aaAlt.isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return "";
        }
        if (this.aaRef.equals(this.aaAlt)) {
            return this.aaAlt + (this.codonNum + 1);
        }
        return this.aaRef + (this.codonNum + 1) + this.aaAlt;
    }

    public String getAaChangeOld() {
        if (this.aaRef.isEmpty() && this.aaAlt.isEmpty()) {
            return "";
        }
        if (this.aaRef.equals(this.aaAlt)) {
            return this.aaAlt;
        }
        return (this.aaRef.isEmpty() ? "-" : this.aaRef) + "/" + (this.aaAlt.isEmpty() ? "-" : this.aaAlt);
    }

    public int getAaLength() {
        int cdsLen = this.getCdsLength();
        if (cdsLen < 0) {
            return -1;
        }
        int lenNoStop = Math.max(0, cdsLen - 3);
        return lenNoStop / 3;
    }

    public String getAaNetChange() {
        String aaLong = "";
        String aaShort = "";
        if (this.variant.isIns()) {
            aaShort = this.getAaRef().toUpperCase();
            aaLong = this.getAaAlt().toUpperCase();
        } else if (this.variant.isDel()) {
            aaLong = this.getAaRef().toUpperCase();
            aaShort = this.getAaAlt().toUpperCase();
        }
        if (aaLong.startsWith(aaShort)) {
            return aaLong.substring(aaShort.length());
        }
        if (aaLong.endsWith(aaLong)) {
            return aaLong.substring(0, aaLong.length() - aaShort.length());
        }
        return aaLong;
    }

    public String getAaRef() {
        return this.aaRef;
    }

    public String getBiotype() {
        Gene gene = this.getGene();
        if (gene == null) {
            return "";
        }
        Transcript tr = this.getTranscript();
        if (tr != null) {
            return tr.getBioType();
        }
        if (gene.getGenome().hasCodingInfo()) {
            return gene.isProteinCoding() ? "coding" : "non-coding";
        }
        return "";
    }

    public int getcDnaPos() {
        return this.cDnaPos;
    }

    public int getCdsLength() {
        Transcript tr = this.getTranscript();
        if (tr != null && tr.isProteinCoding()) {
            return tr.cds().length();
        }
        return -1;
    }

    public String getCodonChange() {
        if (this.codonsRef.isEmpty() && this.codonsAlt.isEmpty()) {
            return "";
        }
        return this.codonsRef + "/" + this.codonsAlt;
    }

    public String getCodonChangeMax() {
        if (this.variant.size() > 100) {
            return "";
        }
        if (this.codonsRef.isEmpty() && this.codonsAlt.isEmpty()) {
            return "";
        }
        return this.codonsRef + "/" + this.codonsAlt;
    }

    public int getCodonIndex() {
        return this.codonIndex;
    }

    public int getCodonNum() {
        return this.codonNum;
    }

    public String getCodonsAlt() {
        return this.codonsAlt;
    }

    public String getCodonsRef() {
        return this.codonsRef;
    }

    public int getDistance() {
        return this.distance;
    }

    public EffectImpact getEffectImpact() {
        if (this.effectImpact == null) {
            if (this.variant != null && !this.variant.isVariant()) {
                this.effectImpact = EffectImpact.MODIFIER;
            } else {
                this.effectImpact = EffectImpact.MODIFIER;
                for (EffectImpact eimp : this.effectImpacts) {
                    if (eimp.compareTo(this.effectImpact) >= 0) continue;
                    this.effectImpact = eimp;
                }
            }
        }
        return this.effectImpact;
    }

    public EffectType getEffectType() {
        if (this.effectType != null) {
            return this.effectType;
        }
        if (this.effectTypes == null || this.effectTypes.isEmpty()) {
            return EffectType.NONE;
        }
        this.effectType = EffectType.NONE;
        for (EffectType et : this.effectTypes) {
            if (et.compareTo(this.effectType) >= 0) continue;
            this.effectType = et;
        }
        return this.effectType;
    }

    public List<EffectType> getEffectTypes() {
        return this.effectTypes;
    }

    public String getEffectTypeString(boolean useSeqOntology) {
        return this.getEffectTypeString(useSeqOntology, false, EffFormatVersion.FORMAT_EFF_4);
    }

    public String getEffectTypeString(boolean useSeqOntology, boolean useFirstEffect) {
        return this.getEffectTypeString(useSeqOntology, useFirstEffect, EffFormatVersion.FORMAT_EFF_4);
    }

    public String getEffectTypeString(boolean useSeqOntology, boolean useFirstEffect, EffFormatVersion formatVersion) {
        if (this.effectTypes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.effectTypes);
        HashSet<String> added = this.effectTypes.size() > 1 && !useFirstEffect ? new HashSet<String>() : null;
        for (EffectType et : this.effectTypes) {
            String eff;
            String string2 = eff = useSeqOntology ? et.toSequenceOntology(formatVersion, this.variant) : et.toString();
            if (added == null || added.add(eff)) {
                if (sb.length() > 0) {
                    sb.append(formatVersion.separator());
                }
                sb.append(eff);
            }
            if (!useFirstEffect) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public String getError() {
        return this.error;
    }

    public Exon getExon() {
        if (this.marker != null) {
            if (this.marker instanceof Exon) {
                return (Exon)this.marker;
            }
            return (Exon)this.marker.findParent(Exon.class);
        }
        return null;
    }

    public FunctionalClass getFunctionalClass() {
        if (this.variant.isSnp()) {
            if (!this.aaAlt.equals(this.aaRef)) {
                CodonTable codonTable = this.marker.codonTable();
                if (codonTable.isStop(this.codonsAlt)) {
                    return FunctionalClass.NONSENSE;
                }
                return FunctionalClass.MISSENSE;
            }
            if (!this.codonsAlt.equals(this.codonsRef)) {
                return FunctionalClass.SILENT;
            }
        }
        return FunctionalClass.NONE;
    }

    public Gene getGene() {
        if (this.marker != null) {
            if (this.marker instanceof Gene) {
                return (Gene)this.marker;
            }
            return (Gene)this.marker.findParent(Gene.class);
        }
        return null;
    }

    public String getGeneRegion() {
        EffectType eff = this.getEffectType().getGeneRegion();
        if (eff == EffectType.TRANSCRIPT) {
            eff = this.isExon() ? EffectType.TRANSCRIPT : EffectType.NONE;
        }
        return eff.toString();
    }

    public String getGenotype() {
        if (this.variant == null) {
            return "";
        }
        return this.variant.getGenotype();
    }

    public String getHgvs() {
        String hgvsProt = this.getHgvsProt();
        String hgvsDna = this.getHgvsDna();
        StringBuilder hgvs = new StringBuilder();
        if (hgvsProt != null) {
            hgvs.append(hgvsProt);
        }
        if (hgvsDna != null) {
            if (hgvs.length() > 0) {
                hgvs.append('/');
            }
            hgvs.append(hgvsDna);
        }
        return hgvs.toString();
    }

    public String getHgvsDna() {
        HgvsDna hgvsDna = new HgvsDna(this);
        String hgvs = hgvsDna.toString();
        return hgvs != null ? hgvs : "";
    }

    public String getHgvsProt() {
        HgvsProtein hgvsProtein = new HgvsProtein(this);
        String hgvs = hgvsProtein.toString();
        return hgvs != null ? hgvs : "";
    }

    public Intron getIntron() {
        if (this.marker != null) {
            if (this.marker instanceof Intron) {
                return (Intron)this.marker;
            }
            return (Intron)this.marker.findParent(Intron.class);
        }
        return null;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Transcript getTranscript() {
        if (this.marker != null) {
            if (this.marker instanceof Transcript) {
                return (Transcript)this.marker;
            }
            return (Transcript)this.marker.findParent(Transcript.class);
        }
        return null;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean hasAdditionalAnnotations() {
        return this.getMarker() != null && this.getMarker() instanceof Custom && ((Custom)this.getMarker()).hasAnnotations();
    }

    public boolean hasEffectType(EffectType effectType) {
        for (EffectType effType : this.effectTypes) {
            if (effType != effectType) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        return this.error != null && !this.error.isEmpty();
    }

    public boolean hasWarning() {
        return this.warning != null && !this.warning.isEmpty();
    }

    public boolean isCustom() {
        return this.getEffectType() == EffectType.CUSTOM;
    }

    public boolean isExon() {
        return this.marker instanceof Exon || this.hasEffectType(EffectType.EXON_DELETED);
    }

    public boolean isIntergenic() {
        return this.hasEffectType(EffectType.INTERGENIC) || this.hasEffectType(EffectType.INTERGENIC_CONSERVED);
    }

    public boolean isIntron() {
        return this.hasEffectType(EffectType.INTRON) || this.hasEffectType(EffectType.INTRON_CONSERVED);
    }

    public boolean isMotif() {
        return this.hasEffectType(EffectType.MOTIF);
    }

    public boolean isNextProt() {
        return this.hasEffectType(EffectType.NEXT_PROT);
    }

    public boolean isRegulation() {
        return this.hasEffectType(EffectType.REGULATION);
    }

    public boolean isSpliceSite() {
        return this.hasEffectType(EffectType.SPLICE_SITE_DONOR) || this.hasEffectType(EffectType.SPLICE_SITE_ACCEPTOR) || this.hasEffectType(EffectType.SPLICE_SITE_REGION) || this.hasEffectType(EffectType.SPLICE_SITE_BRANCH) || this.hasEffectType(EffectType.SPLICE_SITE_BRANCH_U12);
    }

    public boolean isSpliceSiteCore() {
        return this.hasEffectType(EffectType.SPLICE_SITE_DONOR) || this.hasEffectType(EffectType.SPLICE_SITE_ACCEPTOR);
    }

    public boolean isSpliceSiteRegion() {
        return this.hasEffectType(EffectType.SPLICE_SITE_REGION);
    }

    public boolean isUtr3() {
        return this.hasEffectType(EffectType.UTR_3_PRIME) || this.hasEffectType(EffectType.UTR_3_DELETED);
    }

    public boolean isUtr5() {
        return this.hasEffectType(EffectType.UTR_5_PRIME) || this.hasEffectType(EffectType.UTR_5_DELETED);
    }

    public void set(Marker marker, EffectType effectType, EffectImpact effectImpact, String message) {
        this.setMarker(marker);
        this.setEffectType(effectType);
        this.setEffectImpact(effectImpact);
        this.message = message;
    }

    public void setCodons(String codonsOld, String codonsNew, int codonNum, int codonIndex) {
        this.codonsRef = codonsOld;
        this.codonsAlt = codonsNew;
        this.codonNum = codonNum;
        this.codonIndex = codonIndex;
        CodonTable codonTable = this.marker.codonTable();
        if (codonsOld.isEmpty()) {
            this.aaRef = "";
        } else {
            this.aaRef = codonTable.aa(codonsOld);
            this.codonDegeneracy = codonTable.degenerate(codonsOld, codonIndex);
        }
        this.aaAlt = codonsNew.isEmpty() ? "" : codonTable.aa(codonsNew);
    }

    public void setCodonsAround(String codonsLeft, String codonsRight) {
        this.codonsAroundOld = codonsLeft.toLowerCase() + this.codonsRef.toUpperCase() + codonsRight.toLowerCase();
        this.codonsAroundNew = codonsLeft.toLowerCase() + this.codonsAlt.toUpperCase() + codonsRight.toLowerCase();
        CodonTable codonTable = this.marker.codonTable();
        String aasLeft = codonTable.aa(codonsLeft);
        String aasRigt = codonTable.aa(codonsRight);
        this.aasAroundOld = aasLeft.toLowerCase() + this.aaRef.toUpperCase() + aasRigt.toLowerCase();
        this.aasAroundNew = aasLeft.toLowerCase() + this.aaAlt.toUpperCase() + aasRigt.toLowerCase();
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public void setEffect(EffectType effectType) {
        this.setEffectType(effectType);
        this.setEffectImpact(effectType.effectImpact());
    }

    public void setEffectImpact(EffectImpact effectImpact) {
        this.effectImpacts.clear();
        this.effectImpacts.add(effectImpact);
        this.effectImpact = null;
    }

    public void setEffectType(EffectType effectType) {
        this.effectTypes.clear();
        this.effectTypes.add(effectType);
        this.effectType = null;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
        Transcript transcript = this.getTranscript();
        if (transcript != null) {
            this.addErrorWarningInfo(transcript.sanityCheck(this.variant));
            Exon exon = this.getExon();
            if (exon != null) {
                this.addErrorWarningInfo(exon.sanityCheck(this.variant));
            }
        }
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean useSeqOntology, boolean useHgvs) {
        String geneId = "";
        String geneName = "";
        String bioType = "";
        String transcriptId = "";
        String exonId = "";
        String customId = "";
        int exonRank = -1;
        if (this.marker != null) {
            Exon exon;
            Gene gene = this.getGene();
            Transcript tr = this.getTranscript();
            if (gene != null) {
                geneId = gene.getId();
                geneName = gene.getGeneName();
                bioType = this.getBiotype();
            }
            if (tr != null) {
                transcriptId = tr.getId();
            }
            if ((exon = this.getExon()) != null) {
                exonId = exon.getId();
                exonRank = exon.getRank();
            }
            if (this.isRegulation()) {
                bioType = ((Regulation)this.marker).getCellType();
            }
        }
        if (!this.variant.getId().isEmpty()) {
            customId = customId + this.variant.getId();
        }
        if (this.marker != null && this.marker instanceof Custom) {
            customId = customId + (customId.isEmpty() ? "" : ";") + this.marker.getId();
        }
        int cdsSize = this.getCdsLength();
        String errWarn = this.error + (this.error.isEmpty() ? "" : "|") + this.warning;
        String aaChange = "";
        aaChange = useHgvs ? this.getHgvs() : (this.aaRef.length() + this.aaAlt.length() > 0 ? this.aaRef + "/" + this.aaAlt : "");
        return errWarn + "\t" + geneId + "\t" + geneName + "\t" + bioType + "\t" + transcriptId + "\t" + exonId + "\t" + (exonRank >= 0 ? Integer.valueOf(exonRank) : "") + "\t" + this.effect(false, false, false, useSeqOntology, false) + "\t" + aaChange + "\t" + (this.codonsRef.length() + this.codonsAlt.length() > 0 ? this.codonsRef + "/" + this.codonsAlt : "") + "\t" + (this.codonNum >= 0 ? Integer.valueOf(this.codonNum + 1) : "") + "\t" + (this.codonDegeneracy >= 0 ? this.codonDegeneracy + "" : "") + "\t" + (cdsSize >= 0 ? Integer.valueOf(cdsSize) : "") + "\t" + (this.codonsAroundOld.length() > 0 ? this.codonsAroundOld + " / " + this.codonsAroundNew : "") + "\t" + (this.aasAroundOld.length() > 0 ? this.aasAroundOld + " / " + this.aasAroundNew : "") + "\t" + customId;
    }

    public String toStringSimple(boolean shortFormat) {
        String eff;
        String transcriptId = "";
        Transcript tr = this.getTranscript();
        if (tr != null) {
            transcriptId = tr.getId();
        }
        String exonId = "";
        Exon exon = this.getExon();
        if (exon != null) {
            exonId = exon.getId();
        }
        if (!(eff = this.effect(shortFormat, true, true, false, false)).isEmpty()) {
            return eff;
        }
        if (!exonId.isEmpty()) {
            return exonId;
        }
        if (!transcriptId.isEmpty()) {
            return transcriptId;
        }
        return "NO EFFECT";
    }

    public static enum FunctionalClass {
        NONE,
        SILENT,
        MISSENSE,
        NONSENSE;

    }

    public static enum ErrorWarningType {
        INFO_REALIGN_3_PRIME,
        WARNING_SEQUENCE_NOT_AVAILABLE,
        WARNING_REF_DOES_NOT_MATCH_GENOME,
        WARNING_TRANSCRIPT_INCOMPLETE,
        WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS,
        WARNING_TRANSCRIPT_NO_START_CODON,
        WARNING_TRANSCRIPT_NO_STOP_CODON,
        ERROR_CHROMOSOME_NOT_FOUND,
        ERROR_OUT_OF_CHROMOSOME_RANGE,
        ERROR_OUT_OF_EXON,
        ERROR_MISSING_CDS_SEQUENCE;


        public boolean isError() {
            return this.toString().startsWith("ERROR");
        }

        public boolean isWarning() {
            return this.toString().startsWith("WARNING");
        }
    }

    public static enum EffectImpact {
        HIGH,
        MODERATE,
        LOW,
        MODIFIER;

    }

    public static enum Coding {
        CODING,
        NON_CODING;

    }
}

