/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.sam;

import ca.mcgill.mcb.pcingola.sam.SamHeaderRecord;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class SamHeaderRecordSq
extends SamHeaderRecord {
    String sequenceName;
    String assembly;
    String md5;
    String species;
    String uri;
    int length;

    public SamHeaderRecordSq(String line) {
        super(line, "SQ");
    }

    public String getAssembly() {
        return this.assembly;
    }

    public int getLength() {
        return this.length;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    protected void init() {
        this.uri = "";
        this.species = "";
        this.md5 = "";
        this.assembly = "";
        this.sequenceName = "";
        this.length = 0;
    }

    @Override
    protected void parseField(String tag, String value2) {
        if (tag.equals("SN")) {
            this.sequenceName = value2;
        } else if (tag.equals("LN")) {
            this.length = Gpr.parseIntSafe(value2);
        } else if (tag.equals("AS")) {
            this.assembly = value2;
        } else if (tag.equals("M5")) {
            this.md5 = value2;
        } else if (tag.equals("SP")) {
            this.species = value2;
        } else if (tag.equals("UR")) {
            this.uri = value2;
        } else {
            Gpr.debug("Unknown tag '" + tag + "' for header record type '" + this.recordTypeCode + "'.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@' + this.recordTypeCode);
        if (!this.sequenceName.isEmpty()) {
            sb.append("\tSN:" + this.sequenceName);
        }
        if (this.length > 0) {
            sb.append("\tLN:" + this.length);
        }
        if (!this.assembly.isEmpty()) {
            sb.append("\tAS:" + this.sequenceName);
        }
        if (!this.md5.isEmpty()) {
            sb.append("\tM5:" + this.sequenceName);
        }
        if (!this.species.isEmpty()) {
            sb.append("\tSP:" + this.sequenceName);
        }
        if (!this.uri.isEmpty()) {
            sb.append("\tUR:" + this.sequenceName);
        }
        return sb.toString();
    }
}

