/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.reactome;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.gtex.IdMap;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class GeneIds {
    IdMap id2tr = new IdMap();
    IdMap id2geneName = new IdMap();
    IdMap id2refseqId = new IdMap();
    IdMap id2refseqProtId = new IdMap();

    public GeneIds(String fileName) {
        this.load(fileName);
    }

    public IdMap getId2geneName() {
        return this.id2geneName;
    }

    public IdMap getId2refseqId() {
        return this.id2refseqId;
    }

    public IdMap getId2refseqProtId() {
        return this.id2refseqProtId;
    }

    public IdMap getId2tr() {
        return this.id2tr;
    }

    protected void load(String fileName) {
        if (!Gpr.canRead(fileName)) {
            throw new RuntimeException("Cannot read file '" + fileName + "'");
        }
        LineFileIterator lfi = new LineFileIterator(fileName);
        for (String line : lfi) {
            if (lfi.getLineNum() <= 1) continue;
            String[] fields = line.split("\t", -1);
            String geneId = fields[0];
            String trId = fields[1];
            String geneName = fields[2];
            String refseqId = fields[3];
            String refseqProId = fields[4];
            this.id2tr.add(geneId, trId);
            this.id2geneName.add(geneId, geneName);
            this.id2refseqId.add(geneId, refseqId);
            this.id2refseqProtId.add(geneId, refseqProId);
        }
    }
}

