/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

import ca.mcgill.mcb.pcingola.probablility.NormalDistribution;
import ca.mcgill.mcb.pcingola.probablility.RankSumPdf;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;

public class RankSumNoReplacementPdf {
    public static int CACHE_MAX_N = 30;
    public static String DEFAULT_CACHE_FILE = "/pdf_rank_sum_no_replacement.txt";
    public static int warnCDF = 0;
    private static RankSumNoReplacementPdf rankSumNoReplacementPdf = null;
    String cacheFile;
    int cacheHit;
    int cacheMiss;
    HashMap<String, Apfloat> cachePdf;
    HashMap<String, Apfloat> cacheCdf;

    public static RankSumNoReplacementPdf get() {
        if (rankSumNoReplacementPdf == null) {
            rankSumNoReplacementPdf = new RankSumNoReplacementPdf();
        }
        return rankSumNoReplacementPdf;
    }

    private RankSumNoReplacementPdf() {
        this.cacheInit();
        this.cacheMiss = 0;
        this.cacheHit = 0;
        this.cacheFile = DEFAULT_CACHE_FILE;
        this.readCacheFile();
    }

    private RankSumNoReplacementPdf(String cacheFile) {
        this.cacheInit();
        this.cacheMiss = 0;
        this.cacheHit = 0;
        this.cacheFile = cacheFile;
        this.readCacheFile();
    }

    private Apfloat cacheGetCdf(int n, int nt, long r) {
        String key = this.cacheKey(n, nt, r, 1L, 0);
        Apfloat prob = this.cacheCdf.get(key);
        if (prob != null) {
            ++this.cacheHit;
            return prob;
        }
        ++this.cacheMiss;
        return RankSumPdf.BAD;
    }

    private Apfloat cacheGetPdf(int n, int nt, long r, long rmin, int out) {
        String key = this.cacheKey(n, nt, r, rmin, out);
        Apfloat prob = this.cachePdf.get(key);
        if (prob != null) {
            ++this.cacheHit;
            return prob;
        }
        ++this.cacheMiss;
        return RankSumPdf.BAD;
    }

    private void cacheInit() {
        this.cachePdf = new HashMap();
        this.cacheCdf = new HashMap();
    }

    private String cacheKey(int n, int nt, long r, long rmin, int out) {
        return n + "_" + nt + "_" + r + "_" + rmin + "_" + out;
    }

    private void cachePrune(int n) {
        int deleted = 0;
        HashMap<String, Apfloat> newCachePdf = new HashMap<String, Apfloat>();
        for (String key : this.cachePdf.keySet()) {
            String[] field2 = key.split("_");
            int keyN = Integer.parseInt(field2[0]);
            long keyRmin = Long.parseLong(field2[3]);
            int keyOut = Integer.parseInt(field2[4]);
            if (keyN == n && (keyRmin > 1L || keyOut > 0)) {
                ++deleted;
                continue;
            }
            newCachePdf.put(key, this.cachePdf.get(key));
        }
        this.cachePdf = newCachePdf;
    }

    private void cacheSetCdf(int n, int nt, long r, Apfloat cdf) {
        if (this.canBeCached(n, nt)) {
            String key = this.cacheKey(n, nt, r, 1L, 0);
            this.cacheCdf.put(key, cdf);
        }
    }

    public void cacheSetPdf(int n, int nt, long r, double pdf) {
        this.cacheSetPdf(n, nt, r, 1L, 0, new Apfloat(pdf));
    }

    private void cacheSetPdf(int n, int nt, long r, long rmin, int out, Apfloat pdf) {
        if (this.canBeCached(n, nt)) {
            String key = this.cacheKey(n, nt, r, rmin, out);
            this.cachePdf.put(key, pdf);
        }
    }

    public boolean canBeCached(int n, int nt) {
        return 1 <= n && n <= CACHE_MAX_N && 1 <= nt && nt <= CACHE_MAX_N;
    }

    public Apfloat cdf(int n, int nt, long r) {
        Algorithm algorithm;
        Apfloat cdf;
        long minR = this.minRankSum(n, nt);
        long maxR = this.maxRankSum(n, nt);
        if (nt <= 0 || nt > n) {
            return Apcomplex.ZERO;
        }
        if (n <= 0) {
            return Apcomplex.ZERO;
        }
        if (r < minR) {
            return Apcomplex.ZERO;
        }
        if (r >= maxR) {
            return Apcomplex.ONE;
        }
        if (n == nt) {
            if (minR <= r) {
                return Apcomplex.ONE;
            }
            return Apcomplex.ZERO;
        }
        if (nt == 0) {
            if (0L <= r) {
                return Apcomplex.ONE;
            }
            return Apcomplex.ZERO;
        }
        if (n <= CACHE_MAX_N) {
            cdf = this.cdfExact(n, nt, r);
            algorithm = Algorithm.EXACT;
        } else if (nt == 1 || nt == n - 1) {
            cdf = this.cdfUniform(n, nt, r);
            algorithm = Algorithm.UNIFORM;
        } else if (nt == 2 || nt == n - 2) {
            cdf = this.cdfTriangle(n, nt, r);
            algorithm = Algorithm.TRIANGULAR;
        } else {
            cdf = this.cdfNormal(n, nt, r);
            algorithm = Algorithm.NORMAL;
        }
        if (cdf.compareTo((Apfloat)Apcomplex.ZERO) <= 0 || (double)cdf.compareTo((Apfloat)Apcomplex.ONE) > 1.0) {
            if (++warnCDF < 100) {
                Gpr.debug("Warning! CDF should be greater then zero for (algorith: " + (Object)((Object)algorithm) + "):\tN = " + n + "\tNT = " + nt + "\tR = " + r + "\tminRankSum = " + minR + "\tmean = " + this.mean(n, nt) + "\tsigma = " + this.sigma(n, nt));
            }
            throw new RuntimeException("Warning! CDF should be greater then zero for (algorith: " + (Object)((Object)algorithm) + "):\tN = " + n + "\tNT = " + nt + "\tR = " + r + "\tminRankSum = " + minR + "\tmean = " + this.mean(n, nt) + "\tsigma = " + this.sigma(n, nt));
        }
        return cdf;
    }

    public Apfloat cdfExact(int n, int nt, long r) {
        Apfloat cdf = this.cacheGetCdf(n, nt, r);
        if (RankSumPdf.isOk(cdf)) {
            ++this.cacheHit;
            return cdf;
        }
        cdf = new Apfloat(0L);
        int i = 1;
        while ((long)i <= r) {
            cdf = cdf.add(this.pdfExact(n, nt, i));
            ++i;
        }
        this.cacheSetCdf(n, nt, r, cdf);
        return cdf;
    }

    public Apfloat cdfNormal(int n, int nt, long r) {
        double mu = this.mean(n, nt);
        double sigma = Math.sqrt(this.variance(n, nt));
        return NormalDistribution.cdf(r, mu, sigma);
    }

    public Apfloat cdfTriangle(int n, int nt, long r) {
        if (nt != 2 && nt != n - 2) {
            throw new RuntimeException("Triangle approximation is only valid fot 'nt = {2, N-2}'!");
        }
        double dr = r;
        double rMin = this.minRankSum(n, nt) - 1L;
        if (dr <= rMin) {
            return Apcomplex.ZERO;
        }
        double rMax = this.maxRankSum(n, nt) + 1L;
        if (dr >= rMax) {
            return Apcomplex.ONE;
        }
        double mean = this.mean(n, nt);
        double cdf = dr <= mean ? (dr - rMin) * (dr - rMin) / ((rMax - rMin) * (mean - rMin)) : 1.0 - (rMax - dr) * (rMax - dr) / ((rMax - rMin) * (rMax - mean));
        return new Apfloat(cdf);
    }

    public Apfloat cdfUniform(int n, int nt, long r) {
        if (nt != 1 && nt != n - 1) {
            throw new RuntimeException("Uniform approximation is only valid fot 'nt = {1, N-1}'!");
        }
        double rMin = this.minRankSum(n, nt);
        if ((double)r < rMin) {
            return Apcomplex.ZERO;
        }
        double rMax = this.maxRankSum(n, nt);
        if ((double)r > rMax) {
            return Apcomplex.ONE;
        }
        double cdf = ((double)r - rMin + 1.0) / (double)n;
        return new Apfloat(cdf);
    }

    public void createCacheFile() {
        Date start = new Date();
        try {
            BufferedWriter outFile = new BufferedWriter(new FileWriter(this.cacheFile));
            for (int n = 1; n <= CACHE_MAX_N; ++n) {
                System.out.print("N: " + n + "\t");
                for (int nt = 1; nt <= n; ++nt) {
                    System.out.print('.');
                    for (long r = 1L; r <= (long)(n * nt); ++r) {
                        Apfloat pdf = this.pdfExact(n, nt, r);
                        outFile.write(n + "\t" + nt + "\t" + r + "\t" + pdf + "\n");
                    }
                }
                this.cachePrune(n);
                Date now = new Date();
                long elapsed = (now.getTime() - start.getTime()) / 1000L;
                System.out.println("Elapsed: " + elapsed + "s\t" + this.toStringCache());
            }
            outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCacheFile() {
        return this.cacheFile;
    }

    public long maxRankSum(int n, int nt) {
        double dn = n;
        double dnt = nt;
        return (long)(dnt * (dn - dnt)) + this.minRankSum(n, nt);
    }

    public double mean(int n, int nt) {
        double dn = n;
        double dnt = nt;
        double mean = dnt * (dn + 1.0) / 2.0;
        return mean;
    }

    public long minRankSum(int n, int nt) {
        double dnt = nt;
        return (long)((dnt + 1.0) * (dnt / 2.0));
    }

    public Apfloat pdf(int n, int nt, long r) {
        Algorithm algorithm;
        Apfloat pdf;
        long minR = this.minRankSum(n, nt);
        long maxR = this.maxRankSum(n, nt);
        if (nt <= 0 || nt > n) {
            return Apcomplex.ZERO;
        }
        if (n <= 0) {
            return Apcomplex.ZERO;
        }
        if (r < minR) {
            return Apcomplex.ZERO;
        }
        if (r >= maxR) {
            return Apcomplex.ONE;
        }
        if (n == nt) {
            if (minR <= r) {
                return Apcomplex.ONE;
            }
            return Apcomplex.ZERO;
        }
        if (nt == 0) {
            if (0L <= r) {
                return Apcomplex.ONE;
            }
            return Apcomplex.ZERO;
        }
        if (n <= CACHE_MAX_N) {
            pdf = this.pdfExact(n, nt, r);
            algorithm = Algorithm.EXACT;
        } else if (nt == 1 || nt == n - 1) {
            pdf = this.pdfUniform(n, nt, r);
            algorithm = Algorithm.UNIFORM;
        } else if (nt == 2 || nt == n - 2) {
            pdf = this.pdfTriangle(n, nt, r);
            algorithm = Algorithm.TRIANGULAR;
        } else {
            pdf = this.pdfNormal(n, nt, r);
            algorithm = Algorithm.NORMAL;
        }
        if (pdf.compareTo((Apfloat)Apcomplex.ZERO) <= 0 || (double)pdf.compareTo((Apfloat)Apcomplex.ONE) > 1.0) {
            throw new RuntimeException("Warning! PDF should be greater then zero for (algorith: " + (Object)((Object)algorithm) + "):\tN = " + n + "\tNT = " + nt + "\tR = " + r + "\tminRankSum = " + minR + "\tmean = " + this.mean(n, nt) + "\tsigma = " + this.sigma(n, nt));
        }
        return pdf;
    }

    public Apfloat pdfExact(int n, int nt, long r) {
        return this.pdfExact(n, nt, r, 1L, 0);
    }

    public Apfloat pdfExact(int n, int nt, long r, long rmin, int out) {
        long minR = (int)((double)(nt + 1) * (double)nt / 2.0);
        long minR2 = (long)nt * (rmin - 1L) + minR;
        long maxR = (long)(nt * (n - nt)) + minR;
        if (r < minR2 || r > maxR || r < rmin) {
            return Apcomplex.ZERO;
        }
        if (nt <= 0 || nt > n) {
            return Apcomplex.ZERO;
        }
        if (n <= 0) {
            return Apcomplex.ZERO;
        }
        if ((long)n < rmin) {
            return Apcomplex.ZERO;
        }
        if (nt == 1) {
            double p = 1.0 / (double)(n - out);
            return new Apfloat(p);
        }
        Apfloat p = this.cacheGetPdf(n, nt, r, rmin, out);
        if (RankSumPdf.isOk(p)) {
            return p;
        }
        Apfloat sum2 = new Apfloat(0L);
        long rmax = n;
        if (rmax > r - 1L) {
            rmax = r - 1L;
        }
        for (long i = rmin; i < rmax; ++i) {
            Apfloat p1 = this.pdfExact(n, 1, i, i, out);
            Apfloat p2 = this.pdfExact(n, nt - 1, r - i, i + 1L, out + 1);
            sum2 = sum2.add(p1.multiply(p2).multiply(new Apfloat((long)nt)));
        }
        p = sum2;
        this.cacheSetPdf(n, nt, r, rmin, out, p);
        return p;
    }

    public Apfloat pdfNormal(int n, int nt, long r) {
        double mu = this.mean(n, nt);
        double sigma = Math.sqrt(this.variance(n, nt));
        return NormalDistribution.pdf(r, mu, sigma);
    }

    public Apfloat pdfTriangle(int n, int nt, long r) {
        if (nt != 2 && nt != n - 2) {
            throw new RuntimeException("Triangle approximation is only valid fot 'nt = {2, N-2}'!");
        }
        double dr = r;
        double rMin = this.minRankSum(n, nt) - 1L;
        if (dr <= rMin) {
            return Apcomplex.ZERO;
        }
        double rMax = this.maxRankSum(n, nt) + 1L;
        if (dr >= rMax) {
            return Apcomplex.ZERO;
        }
        double mean = this.mean(n, nt);
        double pdf = dr <= mean ? 2.0 * (dr - rMin) / ((rMax - rMin) * (mean - rMin)) : 2.0 * (rMax - dr) / ((rMax - rMin) * (rMax - mean));
        return new Apfloat(pdf);
    }

    public Apfloat pdfUniform(int n, int nt, long r) {
        if (nt != 1 && nt != n - 1) {
            throw new RuntimeException("Uniform approximation is only valid fot 'nt = {1, N-1}'!");
        }
        double rMin = this.minRankSum(n, nt);
        if ((double)r < rMin) {
            return Apcomplex.ZERO;
        }
        double rMax = this.maxRankSum(n, nt);
        if ((double)r > rMax) {
            return Apcomplex.ZERO;
        }
        double pdf = 1.0 / (double)n;
        return new Apfloat(pdf);
    }

    public void readCacheFile() {
        try {
            String line;
            BufferedReader inFile = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("rank_sum_no_replacement.prob")));
            int lineNum = 1;
            while ((line = inFile.readLine()) != null) {
                String[] fields = line.split("\t");
                if (fields.length != 4) {
                    throw new RuntimeException("\nError: Unexpected number of fields (" + fields.length + " fields, line " + lineNum + "): '" + line + "'");
                }
                int n = Integer.parseInt(fields[0]);
                int nt = Integer.parseInt(fields[1]);
                long r = Long.parseLong(fields[2]);
                double pdf = Double.parseDouble(fields[3]);
                Apfloat pdfAp = new Apfloat(pdf);
                this.cacheSetPdf(n, nt, r, 1L, 0, pdfAp);
                ++lineNum;
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCacheFile(String cacheFile) {
        this.cacheFile = cacheFile;
    }

    public double sigma(int n, int nt) {
        return Math.sqrt(this.variance(n, nt));
    }

    public String toStringCache() {
        double perc = 0.0;
        if (this.cacheHit > 0) {
            perc = (int)(10000.0 * ((double)this.cacheMiss / (double)this.cacheHit)) / 100;
        }
        return "Cache size: " + this.cachePdf.size() + "\tMiss/Hit: " + this.cacheMiss + " / " + this.cacheHit + " ( " + perc + "% )";
    }

    public double variance(int n, int nt) {
        double dn = n;
        double dnt = nt;
        double var = 0.0;
        double mu = this.mean(n, nt);
        double kr = (dn + 1.0) * (2.0 * dn + 1.0) * dn / 6.0;
        double krrp = dn / 2.0 * (dn + 1.0);
        krrp = krrp * krrp - kr;
        var = dnt * (dnt - 1.0) / (dn * (dn - 1.0)) * krrp + dnt / dn * kr - mu * mu;
        return var;
    }

    public double varianceSlow(int n, int nt) {
        double var = 0.0;
        double dnt = nt;
        double dn = n;
        double mu = this.mean(n, nt);
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n; ++j) {
                double di = i;
                double dj = j;
                if (i == j) {
                    var += di * dj * dnt / dn;
                    continue;
                }
                var += di * dj * dnt * (dnt - 1.0) / (dn * (dn - 1.0));
            }
        }
        return var -= mu * mu;
    }

    static enum Algorithm {
        EXACT,
        UNIFORM,
        TRIANGULAR,
        NORMAL;

    }
}

