/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import java.util.Random;

public class RandMarker {
    Random rand;
    Genome genome;
    long genomeSize;

    public RandMarker(Genome genome) {
        this.rand = new Random();
        this.genome = genome;
        this.init();
    }

    public RandMarker(Genome genome, int seed) {
        this.rand = new Random(seed);
        this.genome = genome;
        this.init();
    }

    void init() {
        this.genomeSize = 0L;
        for (Chromosome chr : this.genome) {
            this.genomeSize += (long)chr.size();
        }
    }

    public Marker rand(int readLen) {
        Marker m;
        while ((m = this.random(readLen)) == null) {
        }
        return m;
    }

    Marker random(int readLen) {
        long chrPos;
        long pos = chrPos = Math.abs(this.rand.nextLong()) % this.genomeSize;
        Chromosome chromo = null;
        for (Chromosome chr : this.genome) {
            if (pos <= (long)chr.size()) {
                chromo = chr;
                break;
            }
            pos -= (long)chr.size();
        }
        if (chromo == null) {
            throw new RuntimeException("Selected null chromosome. This should never happen!");
        }
        if (pos < 0L) {
            throw new RuntimeException("Negative position. This should never happen!");
        }
        if (pos + (long)readLen > (long)chromo.size()) {
            return null;
        }
        return new Marker(chromo, (int)pos, (int)(pos + (long)readLen - 1L), false, "");
    }
}

