/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

import org.apache.commons.math3.distribution.NormalDistribution;

public class CochranArmitageTest {
    public static final double[] WEIGHT_DOMINANT = new double[]{1.0, 1.0, 0.0};
    public static final double[] WEIGHT_RECESSIVE = new double[]{0.0, 1.0, 1.0};
    public static final double[] WEIGHT_TREND = new double[]{0.0, 1.0, 2.0};
    private static CochranArmitageTest cochranArmitageTest = new CochranArmitageTest();
    public static double EPSILON = 1.0E-20;

    public static CochranArmitageTest get() {
        return cochranArmitageTest;
    }

    private CochranArmitageTest() {
    }

    public double p(int[] N1, int[] N2, double[] weight) {
        double t = this.test(N1, N2, weight);
        if (t > 0.0) {
            t = -t;
        }
        double p = new NormalDistribution(0.0, 1.0).cumulativeProbability(t);
        return p;
    }

    double t(int[] N1, int[] N2, double[] weight) {
        int R1 = 0;
        int R2 = 0;
        int k = N1.length;
        for (int i = 0; i < k; ++i) {
            R1 += N1[i];
            R2 += N2[i];
        }
        double t = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            t += weight[i] * (double)(N1[i] * R2 - N2[i] * R1);
        }
        return t;
    }

    public double test(int[] N1, int[] N2, double[] weight) {
        if (N1.length != N2.length) {
            throw new RuntimeException("Row length do not match: " + N1.length + " != " + N2.length);
        }
        if (N1.length != weight.length) {
            throw new RuntimeException("Weight length does not match data rows length: " + N1.length + " != " + weight.length);
        }
        double t = this.t(N1, N2, weight);
        double var = this.var(N1, N2, weight);
        return t / Math.sqrt(var);
    }

    double var(int[] N1, int[] N2, double[] weight) {
        int k = N1.length;
        int R1 = 0;
        int R2 = 0;
        for (int i = 0; i < k; ++i) {
            R1 += N1[i];
            R2 += N2[i];
        }
        int N = R1 + R2;
        double sum1 = 0.0;
        for (int i = 0; i < k; ++i) {
            int Ci = N1[i] + N2[i];
            sum1 += weight[i] * weight[i] * (double)Ci * (double)(N - Ci);
        }
        double sum2 = 0.0;
        for (int i = 0; i < k - 1; ++i) {
            int Ci = N1[i] + N2[i];
            for (int j = i + 1; j < k; ++j) {
                int Cj = N1[j] + N2[j];
                sum2 += weight[i] * weight[j] * (double)Ci * (double)Cj;
            }
        }
        double var = (double)R1 * (double)R2 / (double)N * (sum1 - 2.0 * sum2);
        return var;
    }
}

