/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

public class Binomial {
    public static double EPSILON = 1.0E-20;
    private static Binomial binomial = null;
    double[] sumLog = new double[]{0.0};

    public static Binomial get() {
        if (binomial == null) {
            binomial = new Binomial();
        }
        return binomial;
    }

    public double cdf(double p, int k, int n) {
        if (k < 0) {
            return 0.0;
        }
        if (k >= n) {
            return 1.0;
        }
        double cdf = 0.0;
        for (int i = 0; i <= k; ++i) {
            cdf += this.pdf(p, i, n);
        }
        cdf = Math.min(1.0, cdf);
        return cdf;
    }

    public double cdfUp(double p, int k, int n) {
        if (k < 0) {
            return 1.0;
        }
        if (k >= n) {
            return 0.0;
        }
        double cdf = 0.0;
        for (int i = n; i > k; --i) {
            cdf += this.pdf(p, i, n);
        }
        cdf = Math.min(1.0, cdf);
        return cdf;
    }

    public double cdfUpEq(double p, int k, int n) {
        if (k < 0) {
            return 1.0;
        }
        if (k > n) {
            return 0.0;
        }
        double cdf = this.cdfUp(p, k, n) + this.pdf(p, k, n);
        cdf = Math.min(1.0, cdf);
        return cdf;
    }

    synchronized void newSumLog(int n) {
        if (n >= this.sumLog.length) {
            int i;
            double[] sumLogOld = this.sumLog;
            double[] sumLogNew = new double[n + 1];
            for (i = 0; i < sumLogOld.length; ++i) {
                sumLogNew[i] = sumLogOld[i];
            }
            for (i = sumLogOld.length; i < sumLogNew.length; ++i) {
                sumLogNew[i] = sumLogNew[i - 1] + Math.log(i);
            }
            this.sumLog = sumLogNew;
        }
    }

    public double pdf(double p, int k, int n) {
        if (k < 0 || k > n) {
            return 0.0;
        }
        return Math.exp(this.pdfLog(p, k, n));
    }

    public double pdfLog(double p, int k, int n) {
        if (k < 0 || k > n) {
            return 0.0;
        }
        if (k == n) {
            return (double)k * Math.log(p);
        }
        return this.sumLog(n) - (this.sumLog(k) + this.sumLog(n - k)) + (double)k * Math.log(p) + (double)(n - k) * Math.log(1.0 - p);
    }

    double sumLog(int n) {
        if (n >= this.sumLog.length) {
            this.newSumLog(n);
        }
        return this.sumLog[n];
    }

    public String toR(double p, int k, int n) {
        return "dbinom( " + k + ", " + n + ", " + p + " )";
    }
}

