/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.ped.PedGenotype;
import ca.mcgill.mcb.pcingola.ped.PlinkMap;
import ca.mcgill.mcb.pcingola.ped.Sex;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import java.util.Collection;
import java.util.Iterator;

public class PedEntry
extends TfamEntry
implements Iterable<PedGenotype> {
    PlinkMap plinkMap;
    String[] genotypes;

    public PedEntry(PlinkMap plinkMap, String line) {
        super(line);
        this.plinkMap = plinkMap;
    }

    public PedEntry(PlinkMap plinkMap, String familyId, String id, String fatherId, String motherId, Sex sex, double phenotype, String[] genotypes) {
        super(familyId, id, fatherId, motherId, sex, phenotype);
        this.plinkMap = plinkMap;
        this.genotypes = genotypes;
    }

    public int countGenotypes() {
        int count2 = 0;
        for (PedGenotype gen : this) {
            if (!gen.isValid()) continue;
            ++count2;
        }
        return count2;
    }

    String genoStr(String geno) {
        if (geno.equals("x") || geno.equals("0")) {
            return "";
        }
        return geno;
    }

    public PedGenotype getGenotype(int idx) {
        String[] geno = new String[]{this.genoStr(this.genotypes[idx * 2]), this.genoStr(this.genotypes[idx * 2 + 1])};
        return new PedGenotype(geno, this.plinkMap.getChrName(idx), this.plinkMap.getPosition(idx));
    }

    public PedGenotype getGenotype(String idStr) {
        Integer idxInt = this.plinkMap.getGenotypeNames(idStr);
        if (idxInt == null) {
            return null;
        }
        return this.getGenotype(idxInt);
    }

    public Collection<String> getGenotypeNames() {
        return this.plinkMap.getGenotypeNames();
    }

    public String[] getGenotypes() {
        return this.genotypes;
    }

    @Override
    public Iterator<PedGenotype> iterator() {
        return new Iterator<PedGenotype>(){
            int i = 0;
            int max = PedEntry.this.size();

            @Override
            public boolean hasNext() {
                return this.i < this.max;
            }

            @Override
            public PedGenotype next() {
                return PedEntry.this.getGenotype(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unsupported! Go away and die!");
            }
        };
    }

    @Override
    protected void parse(String line) {
        String[] fields = line.split("\\s", -1);
        this.parse(fields);
    }

    @Override
    protected int parse(String[] fields) {
        int fieldNum = super.parse(fields);
        String[] genotypes = new String[fields.length - fieldNum];
        int j = 0;
        while (fieldNum < fields.length) {
            genotypes[j] = fields[fieldNum];
            ++fieldNum;
            ++j;
        }
        return fieldNum;
    }

    public int size() {
        return this.genotypes.length / 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + "\t");
        int len = this.genotypes.length / 2;
        for (int i = 0; i < len; i += 2) {
            sb.append(this.genotypes[i] + "/" + this.genotypes[i + 1] + "\t");
        }
        return sb.toString();
    }
}

