/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.overlap;

import ca.mcgill.mcb.pcingola.binseq.coder.Coder;

public class BasesChangeCounter {
    private static int CACHED_BASES = 8;
    private static int CACHED_BITS = 2 * CACHED_BASES;
    private static int MASK = (1 << CACHED_BITS) - 1;
    Coder coder;
    int[] changed;

    public BasesChangeCounter(Coder coder) {
        this.coder = coder;
        this.changed = new int[1 << CACHED_BITS];
        for (int i = 0; i < this.changed.length; ++i) {
            int count2 = 0;
            for (int ii = 0; ii < CACHED_BASES; ++ii) {
                int j = i >> coder.bitsPerBase() * ii & (int)coder.mask(0);
                if (j == 0) continue;
                ++count2;
            }
            this.changed[i] = count2;
        }
    }

    int changed(long xor) {
        if (xor == 0L) {
            return 0;
        }
        int changedBases = 0;
        for (int i = 0; i < 4; ++i) {
            long j = xor >>> i * CACHED_BITS & (long)MASK;
            changedBases += this.changed[(int)j];
        }
        return changedBases;
    }
}

