/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.KeyValue;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class VcfOutputFormatter
extends OutputFormatter {
    public static boolean debug = false;
    public static final String VCF_INFO_OICR_NAME = "OICR";
    boolean needAddInfo = false;
    boolean needAddHeader = true;
    boolean lossOfFunction;
    boolean gatk;
    EffFormatVersion formatVersion = EffFormatVersion.DEFAULT_FORMAT_VERSION;
    List<VcfEntry> vcfEntries;

    public VcfOutputFormatter() {
    }

    public VcfOutputFormatter(List<VcfEntry> vcfEntries) {
        this.vcfEntries = vcfEntries;
    }

    protected void addHeader() {
        VcfEntry vcfEntry = (VcfEntry)this.section;
        if (vcfEntry == null) {
            return;
        }
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        for (String newHeaderLine : this.getNewHeaderLines()) {
            vcfFile.getVcfHeader().addLine(newHeaderLine);
        }
        this.needAddHeader = false;
    }

    protected void addInfo(VcfEntry vcfEntry) {
        String oicrInfo;
        if (this.variantEffects.isEmpty()) {
            return;
        }
        Collections.sort(this.variantEffects);
        if (this.gatk) {
            this.variantEffects = this.variantEffectsGatk();
        }
        HashSet<String> effs = new HashSet<String>();
        ArrayList<String> effsSorted = new ArrayList<String>();
        HashSet<String> oicr = this.useOicr ? new HashSet<String>() : null;
        boolean addCustomFields = false;
        for (VariantEffect variantEffect : this.variantEffects) {
            Transcript tr;
            if (this.variantEffectResutFilter != null && this.variantEffectResutFilter.filter(variantEffect)) continue;
            VcfEffect vcfEffect = new VcfEffect(variantEffect, this.formatVersion, this.useSequenceOntology, this.gatk);
            vcfEffect.setUseGeneId(this.useGeneId);
            vcfEffect.setUseHgvs(this.useHgvs);
            String effStr = vcfEffect.toString();
            if (!effs.add(effStr)) {
                if (debug) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("--------------------------------------------------------------------------------\n");
                    sb.append("VCF Entry   :\t" + vcfEntry + "\n");
                    sb.append("REPEAT (VCF):\t" + effStr + "\n");
                    sb.append("REPEAT (TXT):\t" + variantEffect + "\n");
                    sb.append("All    (VCF):\n");
                    for (String string2 : effsSorted) {
                        sb.append("\t" + string2 + "\n");
                    }
                    sb.append("All    (TXT):\n");
                    for (VariantEffect variantEffect2 : this.variantEffects) {
                        sb.append("\t" + variantEffect2 + "\n");
                    }
                    sb.append("--------------------------------------------------------------------------------\n");
                    Gpr.debug("WARNING: Repeated effect!\n" + sb);
                }
            } else {
                effsSorted.add(effStr);
            }
            if (this.useOicr && (tr = variantEffect.getTranscript()) != null) {
                StringBuilder sb = new StringBuilder();
                Variant variant = variantEffect.getVariant();
                int pos = tr.isStrandMinus() ? variant.getStart() : variant.getEnd();
                int cdnaIdx = tr.baseNumber2MRnaPos(pos) + 1;
                if (cdnaIdx > 0) {
                    sb.append("(" + VcfEntry.vcfInfoSafe(tr.getId()) + "|" + cdnaIdx + ")");
                }
                oicr.add(sb.toString());
            }
            addCustomFields |= variantEffect.hasAdditionalAnnotations();
        }
        String effStr = this.toStringVcfInfo(effsSorted);
        if (!effStr.isEmpty()) {
            vcfEntry.addInfo(VcfEffect.infoFieldName(this.formatVersion), effStr);
        }
        if (this.useOicr && oicr.size() > 0 && !(oicrInfo = this.toStringVcfInfo(oicr)).isEmpty()) {
            vcfEntry.addInfo(VCF_INFO_OICR_NAME, oicrInfo);
        }
        if (this.lossOfFunction) {
            LossOfFunction lof = new LossOfFunction(this.config, this.variantEffects);
            if (lof.isLof()) {
                vcfEntry.addInfo("LOF", lof.toStringVcfLof());
            }
            if (lof.isNmd()) {
                vcfEntry.addInfo("NMD", lof.toStringVcfNmd());
            }
        }
        if (addCustomFields) {
            for (VariantEffect changeEffect : this.variantEffects) {
                if (!changeEffect.hasAdditionalAnnotations()) continue;
                Custom custom = (Custom)changeEffect.getMarker();
                for (KeyValue<String, String> kv : custom) {
                    String string3 = VcfEntry.vcfInfoSafe(custom.getLabel() + "_" + (String)kv.key);
                    String value2 = VcfEntry.vcfInfoSafe((String)kv.value);
                    vcfEntry.addInfo(string3, value2);
                }
            }
        }
        this.needAddInfo = false;
    }

    boolean allWarnings() {
        if (this.variantEffects.size() <= 0) {
            return false;
        }
        for (VariantEffect varEff : this.variantEffects) {
            if (varEff.hasError() || varEff.hasWarning()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputFormatter clone() {
        try {
            VcfOutputFormatter newOutputFormatter = (VcfOutputFormatter)super.clone();
            newOutputFormatter.formatVersion = this.formatVersion;
            newOutputFormatter.needAddInfo = this.needAddInfo;
            newOutputFormatter.needAddHeader = this.needAddHeader;
            newOutputFormatter.lossOfFunction = this.lossOfFunction;
            newOutputFormatter.gatk = this.gatk;
            return newOutputFormatter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String endSection(Marker marker) {
        if (marker == null) {
            return super.endSection(marker);
        }
        if (marker instanceof VcfEntry) {
            if (this.vcfEntries != null) {
                this.vcfEntries.add((VcfEntry)marker);
            }
            return super.endSection(marker);
        }
        return null;
    }

    public List<String> getNewHeaderLines() {
        ArrayList<String> newLines = new ArrayList<String>();
        newLines.add("##SnpEffVersion=\"" + this.version + "\"");
        newLines.add("##SnpEffCmd=\"" + this.commandLineStr + "\"");
        newLines.add(this.formatVersion.vcfHeader());
        if (this.lossOfFunction) {
            newLines.add("##INFO=<ID=LOF,Number=.,Type=String,Description=\"Predicted loss of function effects for this variant. Format: 'Gene_Name | Gene_ID | Number_of_transcripts_in_gene | Percent_of_transcripts_affected' \">");
            newLines.add("##INFO=<ID=NMD,Number=.,Type=String,Description=\"Predicted nonsense mediated decay effects for this variant. Format: 'Gene_Name | Gene_ID | Number_of_transcripts_in_gene | Percent_of_transcripts_affected' \">");
        }
        if (this.useOicr) {
            newLines.add("##INFO=<ID=OICR,Number=.,Type=String,Description=\"Format: ( Transcript | Distance from begining cDNA )\">");
        }
        return newLines;
    }

    public void setFormatVersion(EffFormatVersion formatVersion) {
        this.formatVersion = formatVersion;
    }

    public void setGatk(boolean gatk) {
        this.gatk = gatk;
        if (gatk) {
            this.formatVersion = EffFormatVersion.FORMAT_EFF_2;
        }
    }

    public void setLossOfFunction(boolean lossOfFunction) {
        this.lossOfFunction = lossOfFunction;
    }

    @Override
    public void setOutOffset(int outOffset) {
        throw new RuntimeException("Cannot set output offset on '" + this.getClass().getSimpleName() + "' formatter!");
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof VcfEntry) {
            super.startSection(marker);
        }
        this.needAddInfo = true;
    }

    @Override
    public String toString() {
        if (this.section == null) {
            return "";
        }
        VcfEntry vcfEntry = (VcfEntry)this.section;
        if (this.needAddInfo) {
            this.addInfo(vcfEntry);
        }
        return vcfEntry.toString();
    }

    @Override
    protected String toStringHeader() {
        VcfEntry vcfEntry;
        if (this.needAddHeader) {
            this.addHeader();
        }
        if ((vcfEntry = (VcfEntry)this.section) == null) {
            return "";
        }
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        return vcfFile.getVcfHeader().toString();
    }

    String toStringVcfInfo(Collection<String> strs) {
        StringBuffer sb = new StringBuffer();
        for (String str : strs) {
            if (str.isEmpty()) continue;
            sb.append(str + ",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    List<VariantEffect> variantEffectsGatk() {
        if (this.variantEffects.size() <= 1) {
            return this.variantEffects;
        }
        ArrayList<VariantEffect> varEffsGatk = new ArrayList<VariantEffect>();
        if (this.allWarnings()) {
            varEffsGatk.add((VariantEffect)this.variantEffects.get(0));
        } else {
            for (VariantEffect variantEffect : this.variantEffects) {
                if (variantEffect.hasError() || variantEffect.hasWarning()) continue;
                varEffsGatk.add(variantEffect);
                return varEffsGatk;
            }
        }
        return varEffsGatk;
    }
}

