/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import java.util.HashSet;

public class BedOutputFormatter
extends OutputFormatter {
    public BedOutputFormatter() {
        this.outOffset = 0;
    }

    @Override
    public String endSection(Marker marker) {
        if (marker instanceof Variant) {
            return super.endSection(marker);
        }
        return null;
    }

    @Override
    public void setOutOffset(int outOffset) {
        throw new RuntimeException("Cannot set output offset on '" + this.getClass().getSimpleName() + "' formatter!");
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof Variant) {
            super.startSection(marker);
        }
    }

    @Override
    public String toString() {
        Variant seqChange = (Variant)this.section;
        HashSet<String> chEffs = new HashSet<String>();
        for (VariantEffect changeEffect : this.variantEffects) {
            if (this.variantEffectResutFilter != null && this.variantEffectResutFilter.filter(changeEffect)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(changeEffect.effect(true, false, false, this.useSequenceOntology, false));
            Marker m = changeEffect.getMarker();
            if (m == null) continue;
            chEffs.add(m.idChain("|", this.useGeneId, changeEffect));
        }
        StringBuilder changeEffSb = new StringBuilder();
        changeEffSb.append(seqChange.getId());
        for (String chEff : chEffs) {
            changeEffSb.append(";");
            changeEffSb.append(chEff);
        }
        return this.chrStr + seqChange.getChromosomeName() + "\t" + (seqChange.getStart() + this.outOffset) + "\t" + (seqChange.getEnd() + 1) + "\t" + changeEffSb.toString();
    }

    @Override
    public String toStringHeader() {
        return "# SnpEff version " + this.version + "\n" + "# Command line: " + this.commandLineStr + "\n" + "# Chromo\tStart\tEnd\tName;Effect|Gene|BioType\tScore";
    }
}

