/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.logStatsServer;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class VersionCheck
extends Thread {
    public static final int LOG_THREAD_WAIT_TIME = 1000;
    public static final int LOG_THREAD_WAIT_TIME_REPEAT = 3;
    public static boolean debug = false;
    String url;
    boolean newVersion = false;
    String software;
    String latestVersion;
    String latestUrl;
    String latestReleaseDate;

    public static VersionCheck version(String software, String latestVersion, String url, boolean verbose) {
        VersionCheck versionCheck = new VersionCheck(software, latestVersion, url);
        versionCheck.start();
        if (verbose) {
            Timer.showStdErr("Checking for updates...");
        }
        for (int i = 0; i < 3 && versionCheck.isAlive(); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (versionCheck.isAlive() && !versionCheck.isInterrupted()) {
            versionCheck.interrupt();
        }
        return versionCheck;
    }

    public VersionCheck(String software, String latestVersion, String url) {
        this.software = software.toUpperCase();
        this.latestVersion = latestVersion.toUpperCase();
        this.url = url;
    }

    String getData() throws Exception {
        if (this.url == null || this.url.isEmpty()) {
            return "";
        }
        StringBuffer text2 = new StringBuffer();
        URL page = new URL(this.url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.connect();
        InputStreamReader in = new InputStreamReader((InputStream)conn.getContent());
        BufferedReader buff = new BufferedReader(in);
        String line = buff.readLine();
        while (line != null) {
            text2.append(line + "\n");
            line = buff.readLine();
        }
        if (debug) {
            Gpr.debug("Downloaded data:\n" + text2.toString());
        }
        return text2.toString();
    }

    public String getLatestReleaseDate() {
        return this.latestReleaseDate;
    }

    public String getLatestUrl() {
        return this.latestUrl;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public boolean isNewVersion() {
        return this.newVersion;
    }

    void parse(String text2) {
        String[] lines2;
        for (String line : lines2 = text2.split("\n")) {
            if (debug) {
                Gpr.debug("Parse line: " + line);
            }
            if (line.startsWith("#") || line.length() < 1) continue;
            String[] recs = line.split("\t");
            if (debug) {
                for (int i = 0; i < recs.length; ++i) {
                    Gpr.debug("RECS[" + i + "]:" + recs[i]);
                }
            }
            if (recs.length <= 3) continue;
            String softwareName = recs[0].toUpperCase();
            String version = recs[1].toUpperCase();
            String date = recs[2];
            String url = recs[3];
            if (debug) {
                Gpr.debug("VERSION CHECK: " + softwareName.equals(this.software) + "\t" + version + " cmp " + this.latestVersion + " : " + (version.compareTo(this.latestVersion) > 0));
            }
            if (!softwareName.toUpperCase().equals(this.software.toUpperCase()) || version.compareTo(this.latestVersion) <= 0) continue;
            this.latestVersion = version;
            this.latestReleaseDate = date;
            this.latestUrl = url;
            this.newVersion = true;
            if (!debug) continue;
            Gpr.debug("Found new release:\t" + this.latestVersion + "\t" + this.latestReleaseDate + "\t" + this.latestUrl);
        }
    }

    @Override
    public void run() {
        block4: {
            try {
                if (debug) {
                    Gpr.debug("Running thread");
                }
                String page = this.getData();
                this.parse(page);
                if (debug) {
                    Gpr.debug("Thread finished");
                }
            }
            catch (Throwable t) {
                if (!debug) break block4;
                t.printStackTrace();
            }
        }
    }
}

