/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.tree;

import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalNode;
import java.io.Serializable;
import java.util.Iterator;

public class IntervalTree
implements Serializable,
Iterable<Marker> {
    private static final long serialVersionUID = 1808077263026999072L;
    private IntervalNode head;
    private final Markers intervals;
    private boolean inSync;
    private int size;

    public IntervalTree() {
        this.head = new IntervalNode();
        this.intervals = new Markers();
        this.inSync = true;
        this.size = 0;
    }

    public IntervalTree(Markers intervals) {
        this.head = new IntervalNode(intervals);
        this.intervals = new Markers();
        this.intervals.add(intervals);
        this.inSync = true;
        this.size = intervals.size();
    }

    public void add(Marker interval) {
        this.intervals.add(interval);
        this.inSync = false;
    }

    public void add(Markers markers) {
        this.intervals.add(markers);
        this.inSync = false;
    }

    public void build() {
        if (!this.inSync) {
            this.head = new IntervalNode(this.intervals);
            this.inSync = true;
            this.size = this.intervals.size();
        }
    }

    public int currentSize() {
        return this.size;
    }

    public Markers getIntervals() {
        return this.intervals;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public boolean isInSync() {
        return this.inSync;
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.head.iterator();
    }

    public void load(String fileName, Genome genome) {
        this.intervals.load(fileName, genome);
        this.inSync = false;
    }

    private String nodeString(IntervalNode node, int level) {
        if (node == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        sb.append(node + "\n");
        sb.append(this.nodeString(node.getLeft(), level + 1));
        sb.append(this.nodeString(node.getRight(), level + 1));
        return sb.toString();
    }

    public Markers query(Interval interval) {
        this.build();
        return this.head.query(interval);
    }

    public int size() {
        return this.intervals.size();
    }

    public Markers stab(int point) {
        this.build();
        return this.head.stab(point);
    }

    public String toString() {
        return this.nodeString(this.head, 0);
    }
}

