/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.tree;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalTree;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class IntervalForest
implements Serializable,
Iterable<IntervalTree> {
    private static final long serialVersionUID = 1L;
    HashMap<String, IntervalTree> forest = new HashMap();

    public IntervalForest() {
    }

    public IntervalForest(Markers intervals) {
        this.add(intervals);
    }

    public void add(Collection<? extends Marker> intervals) {
        for (Marker marker : intervals) {
            this.add(marker);
        }
    }

    public void add(Marker interval) {
        if (interval == null) {
            return;
        }
        String chName = Chromosome.simpleName(interval.getChromosomeName());
        this.getOrCreateTree(chName).add(interval);
    }

    public void add(Markers intervals) {
        for (Marker i : intervals) {
            this.add(i);
        }
    }

    public void build() {
        for (IntervalTree tree : this.forest.values()) {
            tree.build();
        }
    }

    public IntervalTree getOrCreateTree(String chromo) {
        IntervalTree intervalTree = this.forest.get(chromo = Chromosome.simpleName(chromo));
        if (intervalTree == null) {
            intervalTree = new IntervalTree();
            this.forest.put(chromo, intervalTree);
        }
        return intervalTree;
    }

    public IntervalTree getTree(String chromo) {
        return this.forest.get(Chromosome.simpleName(chromo));
    }

    public Collection<String> getTreeNames() {
        return this.forest.keySet();
    }

    public boolean hasTree(String chromo) {
        return this.getTree(chromo) != null;
    }

    public Markers intersect(Markers markers) {
        Markers result2 = new Markers();
        for (Marker mm : markers) {
            Markers query = this.query(mm);
            if (query == null) continue;
            for (Marker mq : query) {
                int start = Math.max(mq.getStart(), mm.getStart());
                int end = Math.max(mq.getEnd(), mm.getEnd());
                Marker mintq = new Marker(mq.getParent(), start, end, mq.isStrandMinus(), "");
                result2.add(mintq);
            }
        }
        return result2;
    }

    @Override
    public Iterator<IntervalTree> iterator() {
        return this.forest.values().iterator();
    }

    public Markers query(Marker marker) {
        return this.getOrCreateTree(marker.getChromosomeName()).query(marker);
    }

    public Markers query(Markers marker) {
        Markers ints = new Markers();
        for (Marker i : marker) {
            ints.add(this.query(i));
        }
        return ints;
    }

    public Markers queryUnique(Markers markers) {
        HashSet<Marker> uniqueMarkers = new HashSet<Marker>();
        for (Marker q : markers) {
            Markers results = this.query(q);
            for (Marker r : results) {
                uniqueMarkers.add(r);
            }
        }
        Markers ints = new Markers();
        for (Marker r : uniqueMarkers) {
            ints.add(r);
        }
        return ints;
    }

    public int size() {
        int size2 = 0;
        for (IntervalTree it : this.forest.values()) {
            size2 += it.size();
        }
        return size2;
    }

    public Markers stab(Marker marker) {
        return this.stab(marker.getChromosomeName(), marker.getStart());
    }

    public Markers stab(String chromo, int point) {
        return this.getOrCreateTree(chromo).stab(point);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String chromo : this.forest.keySet()) {
            IntervalTree tree = this.getOrCreateTree(chromo);
            sb.append("chr" + chromo + ":\n" + tree + "\n");
        }
        return sb.toString();
    }
}

