/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public class CodonChangeMnp
extends CodonChange {
    int cdsStart;
    int cdsEnd;

    public CodonChangeMnp(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = false;
        this.requireNetCdsChange = true;
    }

    int cdsBaseNumber(int pos, boolean usePrevBaseIntron) {
        if (pos < this.cdsStart) {
            return this.transcript.isStrandPlus() ? 0 : this.transcript.cds().length() - 1;
        }
        if (pos > this.cdsEnd) {
            return this.transcript.isStrandPlus() ? this.transcript.cds().length() - 1 : 0;
        }
        return this.transcript.baseNumberCds(pos, usePrevBaseIntron);
    }

    @Override
    public void codonChange() {
        this.codonOldNew();
        this.effect(this.transcript, EffectType.CODON_CHANGE, "", this.codonsRef, this.codonsAlt, this.codonStartNum, this.codonStartIndex, true);
    }

    protected void codonOldNew() {
        int scEnd;
        int scStart;
        if (!this.transcript.intersects(this.variant)) {
            return;
        }
        this.cdsStart = this.transcript.isStrandPlus() ? this.transcript.getCdsStart() : this.transcript.getCdsEnd();
        int n = this.cdsEnd = this.transcript.isStrandPlus() ? this.transcript.getCdsEnd() : this.transcript.getCdsStart();
        if (this.cdsStart > this.variant.getEnd()) {
            return;
        }
        if (this.cdsEnd < this.variant.getStart()) {
            return;
        }
        if (this.transcript.isStrandPlus()) {
            scStart = this.cdsBaseNumber(this.variant.getStart(), false);
            scEnd = this.cdsBaseNumber(this.variant.getEnd(), true);
        } else {
            scEnd = this.cdsBaseNumber(this.variant.getStart(), true);
            scStart = this.cdsBaseNumber(this.variant.getEnd(), false);
        }
        this.codonStartNum = scStart / 3;
        this.codonStartIndex = scStart % 3;
        int scLen = scEnd - scStart;
        if (scLen < 0) {
            return;
        }
        int scStart3 = this.round3(scStart, false);
        int scEnd3 = this.round3(scEnd, true);
        if (scEnd3 == scStart3) {
            scEnd3 += 3;
        }
        String padN = "";
        int diff2 = scEnd3 - (this.transcript.cds().length() - 1);
        if (diff2 > 0) {
            scEnd3 = this.transcript.cds().length() - 1;
            if (diff2 == 1) {
                padN = "N";
            } else if (diff2 == 2) {
                padN = "NN";
            } else {
                throw new RuntimeException("Sanity check failed. Number of 'N' pading is :" + diff2 + ". This should not happen!");
            }
        }
        this.codonsRef = this.transcript.cds().substring(scStart3, scEnd3 + 1);
        String prepend = this.codonsRef.substring(0, scStart - scStart3);
        String append2 = "";
        if (scEnd3 > scEnd) {
            append2 = this.codonsRef.substring(this.codonsRef.length() - (scEnd3 - scEnd));
        }
        this.codonsAlt = prepend + this.netCdsChange() + append2;
        this.codonsRef = this.codonsRef + padN;
        this.codonsAlt = this.codonsAlt + padN;
        if (this.codonsRef != null && this.codonsAlt != null) {
            String cnew;
            String cold;
            while (this.codonsRef.length() >= 3 && this.codonsAlt.length() >= 3 && (cold = this.codonsRef.substring(0, 3)).equalsIgnoreCase(cnew = this.codonsAlt.substring(0, 3))) {
                this.codonsRef = this.codonsRef.substring(3);
                this.codonsAlt = this.codonsAlt.substring(3);
                ++this.codonStartNum;
            }
        }
    }

    @Override
    public String codonsAlt() {
        return this.codonsAlt;
    }

    @Override
    public String codonsRef() {
        return this.codonsRef;
    }

    @Override
    protected String netCdsChange() {
        if (this.variant.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Exon exon : this.transcript.sortedStrand()) {
                String seq2 = this.variant.netChange(exon);
                sb.append(exon.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2));
            }
            return sb.toString();
        }
        return this.variant.netChange(this.transcript.isStrandMinus());
    }

    int round3(int num, boolean end) {
        if (end) {
            if (num % 3 == 2) {
                return num;
            }
            return num / 3 * 3 + 2;
        }
        if (num % 3 == 0) {
            return num;
        }
        return num / 3 * 3;
    }
}

