/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.align.VariantRealign;
import ca.mcgill.mcb.pcingola.binseq.GenomicSequences;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.IubString;
import java.util.LinkedList;

public class Variant
extends Marker {
    public static final Variant NO_VARIANT = new Variant(null, 0, 0, "");
    private static final long serialVersionUID = -2928105165111400441L;
    VariantType variantType;
    String ref;
    String alt;
    String genotype;
    boolean imprecise = false;

    public static LinkedList<Variant> factory(Chromosome chromo, int start, String ref, String altStr, String id, boolean expand) {
        LinkedList<Variant> list2 = new LinkedList<Variant>();
        if (altStr == null) {
            Variant var = new Variant((Marker)chromo, start, ref, null, id);
            list2.add(var);
            return list2;
        }
        String[] alts = altStr.indexOf(44) >= 0 ? altStr.split(",") : altStr.split("/");
        if (alts.length == 2 && alts[0].equals(alts[1])) {
            Variant var = new Variant((Marker)chromo, start, ref, alts[0], id);
            list2.add(var);
            return list2;
        }
        for (String alt : alts) {
            IubString iubsRef;
            Variant var;
            boolean altIub;
            boolean refIub = expand && IubString.hasIUBMax(ref);
            boolean bl = altIub = expand && IubString.hasIUBMax(alt);
            if (!refIub && !altIub) {
                Variant var2 = new Variant((Marker)chromo, start, ref, alt, id);
                list2.add(var2);
                continue;
            }
            if (altIub && !refIub) {
                IubString iubsAlt = new IubString(alt);
                for (String seqAlt : iubsAlt) {
                    var = new Variant((Marker)chromo, start, ref, seqAlt, id);
                    list2.add(var);
                }
                continue;
            }
            if (!altIub && refIub) {
                iubsRef = new IubString(alt);
                for (String seqRef : iubsRef) {
                    var = new Variant((Marker)chromo, start, seqRef, alt, id);
                    list2.add(var);
                }
                continue;
            }
            if (!altIub || !refIub) continue;
            iubsRef = new IubString(alt);
            for (String seqRef : iubsRef) {
                IubString iubsAlt = new IubString(alt);
                for (String seqAlt : iubsAlt) {
                    Variant var3 = new Variant((Marker)chromo, start, seqRef, seqAlt, id);
                    list2.add(var3);
                }
            }
        }
        return list2;
    }

    public Variant() {
        this.alt = "";
        this.ref = "";
        this.variantType = VariantType.INTERVAL;
    }

    public Variant(Marker parent, int start, int end, String id) {
        super(parent, start, end, false, id);
        this.alt = "";
        this.ref = "";
        this.variantType = VariantType.INTERVAL;
    }

    public Variant(Marker parent, int position, String referenceStr, String altStr) {
        this(parent, position, referenceStr, altStr, "");
    }

    public Variant(Marker parent, int position, String referenceStr, String altStr, String id) {
        super(parent, position, position, false, id);
        this.init(parent, position, referenceStr, altStr, null, id);
    }

    public String alternative() {
        return this.isStrandPlus() ? this.alt : GprSeq.reverseWc(this.alt);
    }

    public String change() {
        return this.isStrandPlus() ? this.alt : GprSeq.reverseWc(this.alt);
    }

    @Override
    public Variant clone() {
        return (Variant)super.clone();
    }

    @Override
    public Variant cloneShallow() {
        Variant clone2 = (Variant)super.cloneShallow();
        clone2.variantType = this.variantType;
        clone2.ref = this.ref;
        clone2.alt = this.alt;
        clone2.genotype = this.genotype;
        clone2.imprecise = this.imprecise;
        return clone2;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public String getReference() {
        return this.ref;
    }

    public VariantType getVariantType() {
        return this.variantType;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getChromosomeName().hashCode();
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + (this.strandMinus ? -1 : 1);
        hashCode = hashCode * 31 + this.id.hashCode();
        hashCode = hashCode * 31 + this.ref.hashCode();
        hashCode = hashCode * 31 + this.alt.hashCode();
        return hashCode;
    }

    void init(Marker parent, int position, String referenceStr, String altStr, VariantType variantType, String id) {
        if (altStr == null) {
            altStr = referenceStr;
        }
        this.ref = referenceStr.toUpperCase();
        this.alt = altStr.toUpperCase();
        if (altStr.indexOf(44) >= 0 || altStr.indexOf(47) >= 0) {
            throw new RuntimeException("Variants with multiple ALTs are not allowed (ALT: '" + altStr + "')");
        }
        if (this.ref.equals("*")) {
            this.ref = "";
        }
        if (this.alt.startsWith("+")) {
            this.alt = this.ref + this.alt.substring(1);
        } else if (this.alt.startsWith("-")) {
            this.ref = this.alt.substring(1);
            this.alt = "";
        } else if (this.alt.startsWith("=")) {
            this.alt = altStr.substring(1);
        }
        this.variantType = variantType == null ? (this.ref.equals(this.alt) ? VariantType.INTERVAL : (this.ref.length() == 1 && this.alt.length() == 1 ? VariantType.SNP : (this.ref.length() == this.alt.length() ? VariantType.MNP : (this.ref.length() < this.alt.length() && this.alt.startsWith(this.ref) ? VariantType.INS : (this.ref.length() > this.alt.length() && this.ref.startsWith(this.alt) ? VariantType.DEL : VariantType.MIXED))))) : variantType;
        this.start = position;
        if (this.isIns() || this.isSnp()) {
            this.end = this.start;
        } else if (this.ref.length() > 1) {
            this.end = this.start + this.ref.length() - 1;
        }
        this.type = EffectType.NONE;
        this.id = id;
    }

    public boolean isDel() {
        return this.variantType == VariantType.DEL;
    }

    public boolean isElongation() {
        return this.lengthChange() > 0;
    }

    public boolean isImprecise() {
        return this.imprecise;
    }

    public boolean isInDel() {
        return this.variantType == VariantType.INS || this.variantType == VariantType.DEL;
    }

    public boolean isIns() {
        return this.variantType == VariantType.INS;
    }

    public boolean isInterval() {
        return this.variantType == VariantType.INTERVAL;
    }

    public boolean isMixed() {
        return this.variantType == VariantType.MIXED;
    }

    public boolean isMnp() {
        return this.variantType == VariantType.MNP;
    }

    public boolean isNonRef() {
        return false;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSnp() {
        return this.variantType == VariantType.SNP;
    }

    public boolean isTruncation() {
        return this.lengthChange() < 0;
    }

    public boolean isVariant() {
        return !this.ref.equals(this.alt);
    }

    public int lengthChange() {
        if (this.isSnp() || this.isMnp()) {
            return 0;
        }
        return this.alt.length() - this.ref.length();
    }

    public String netChange(boolean reverseStrand) {
        if (this.isDel()) {
            return reverseStrand ? GprSeq.reverseWc(this.ref) : this.ref;
        }
        return reverseStrand ? GprSeq.reverseWc(this.alt) : this.alt;
    }

    public String netChange(Marker marker) {
        int removeAfter;
        int removeBefore;
        String netChange = this.alt;
        if (this.isDel()) {
            netChange = this.ref;
        }
        if ((removeBefore = marker.getStart() - this.start) > 0) {
            if (removeBefore >= netChange.length()) {
                return "";
            }
        } else {
            removeBefore = 0;
        }
        if ((removeAfter = this.end - marker.getEnd()) > 0) {
            if (removeBefore + removeAfter >= netChange.length()) {
                return "";
            }
        } else {
            removeAfter = 0;
        }
        if (this.isStrandMinus()) {
            netChange = GprSeq.reverseWc(netChange);
        }
        netChange = netChange.substring(removeBefore, netChange.length() - removeAfter);
        return netChange;
    }

    public Variant realignLeft() {
        GenomicSequences gs = this.getGenome().getGenomicSequences();
        if (gs == null) {
            return this;
        }
        VariantRealign vr = new VariantRealign(gs, this);
        if (!vr.realign()) {
            return this;
        }
        return vr.getVariantRealigned();
    }

    public String reference() {
        return this.isStrandPlus() ? this.ref : GprSeq.reverseWc(this.ref);
    }

    public void setGenotype(String genotype) {
        this.genotype = genotype;
    }

    public void setImprecise(boolean imprecise) {
        this.imprecise = imprecise;
    }

    public void setVariantType(VariantType variantType) {
        this.variantType = variantType;
    }

    @Override
    public String toString() {
        if (this.variantType == VariantType.INTERVAL) {
            return "chr" + this.getChromosomeName() + ":" + this.start + "-" + this.end;
        }
        return "chr" + this.getChromosomeName() + ":" + this.start + "_" + this.getReference() + "/" + this.getAlt() + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public String toStringEnsembl() {
        return this.getChromosomeName() + "\t" + this.start + "\t" + this.end + "\t" + this.ref + "/" + this.alt + "\t+";
    }

    public String toStringOld() {
        if (this.isIns()) {
            return this.getChromosomeName() + ":" + this.getStart() + "_*" + "/+" + this.getAlt();
        }
        if (this.isDel()) {
            return this.getChromosomeName() + ":" + this.getStart() + "_*" + "/-" + this.getReference();
        }
        return this.getChromosomeName() + ":" + this.getStart() + "_" + this.getReference() + "/" + this.getAlt();
    }

    public static enum VariantType {
        SNP,
        MNP,
        INS,
        DEL,
        MIXED,
        INTERVAL;

    }
}

