/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;

public class Regulation
extends Marker {
    private static final long serialVersionUID = -5607588295343642199L;
    String cellType = "";
    String name = "";

    public Regulation() {
        this.type = EffectType.REGULATION;
    }

    public Regulation(Marker parent, int start, int end, boolean strandMinus, String id, String name, String cellType) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.REGULATION;
        this.name = name;
        this.cellType = cellType;
    }

    @Override
    public Regulation cloneShallow() {
        Regulation clone2 = (Regulation)super.cloneShallow();
        clone2.cellType = this.cellType;
        clone2.name = this.name;
        return clone2;
    }

    public String getCellType() {
        return this.cellType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.cellType = markerSerializer.getNextField();
        this.name = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.cellType + "\t" + this.name;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + (Object)((Object)this.type) + (this.name != null && !this.name.isEmpty() ? " '" + this.name + "'" : "");
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        EffectType effType = EffectType.REGULATION;
        variantEffects.add(variant, this, effType, "");
        return true;
    }
}

