/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.binseq.DnaNSequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Arrays;

public class MarkerSeq
extends Marker {
    private static final long serialVersionUID = -8794533547221460207L;
    DnaSequence sequence;

    public MarkerSeq() {
        this.type = EffectType.SEQUENCE;
        this.strandMinus = false;
        this.sequence = DnaSequence.empty();
    }

    public MarkerSeq(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.SEQUENCE;
        this.strandMinus = strandMinus;
        this.sequence = DnaSequence.empty();
    }

    public MarkerSeq(Marker parent, int start, int end, String seq2) {
        this(parent, start, end, false, "");
        if (seq2 != null && !seq2.isEmpty()) {
            this.setSequence(seq2);
        }
    }

    @Override
    public MarkerSeq apply(Variant variant) {
        MarkerSeq newMarkerSeq;
        block8: {
            block7: {
                newMarkerSeq = (MarkerSeq)super.apply(variant);
                if (newMarkerSeq == null) {
                    return null;
                }
                if (!variant.intersects(this)) break block7;
                switch (variant.getVariantType()) {
                    case SNP: {
                        this.applySnp(variant, newMarkerSeq);
                        break block8;
                    }
                    case INS: {
                        this.applyIns(variant, newMarkerSeq);
                        break block8;
                    }
                    case DEL: {
                        this.applyDel(variant, newMarkerSeq);
                        break block8;
                    }
                    case MNP: {
                        this.applyMnp(variant, newMarkerSeq);
                        break block8;
                    }
                    default: {
                        throw new RuntimeException("Unimplemented method for variant change type " + (Object)((Object)variant.getVariantType()) + "\n\tVariant: " + variant);
                    }
                }
            }
            newMarkerSeq.setSequence(this.getSequence());
        }
        return newMarkerSeq;
    }

    protected void applyDel(Variant variant, MarkerSeq markerSeq) {
        if (this.sequence != null && !this.sequence.isEmpty()) {
            String seq2 = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
            int idxStart = variant.getStart() - this.start;
            int idxEnd = idxStart + variant.size();
            StringBuilder newSeq = new StringBuilder();
            if (idxStart >= 0) {
                newSeq.append(seq2.substring(0, idxStart));
            }
            if (idxEnd >= 0 && idxEnd < seq2.length()) {
                newSeq.append(seq2.substring(idxEnd));
            }
            seq2 = newSeq.toString();
            markerSeq.setSequence(this.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2));
        }
    }

    protected void applyIns(Variant variant, MarkerSeq markerSeq) {
        if (this.sequence != null && !this.sequence.isEmpty()) {
            String seq2 = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
            String netChange = variant.netChange(this);
            int idx = variant.getStart() - this.start - 1;
            seq2 = idx >= 0 ? seq2.substring(0, idx + 1) + netChange + seq2.substring(idx + 1) : netChange + seq2;
            markerSeq.setSequence(this.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2));
        }
    }

    protected void applyMnp(Variant variant, MarkerSeq markerSeq) {
        if (this.sequence != null && !this.sequence.isEmpty()) {
            int idxStart = variant.getStart() - this.start;
            int idxAlt = 0;
            if (idxStart < 0) {
                idxAlt = -idxStart;
                idxStart = 0;
            }
            int changeSize = variant.intersectSize(this);
            int idxEnd = idxStart + changeSize;
            String seq2 = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
            StringBuilder seqsb = new StringBuilder();
            seqsb.append(seq2.substring(0, idxStart).toLowerCase());
            String seqAlt = variant.getAlt().substring(idxAlt, idxAlt + changeSize).toUpperCase();
            seqsb.append(seqAlt);
            seqsb.append(seq2.substring(idxEnd).toLowerCase());
            seq2 = seqsb.toString();
            markerSeq.setSequence(this.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2));
        }
    }

    protected void applySnp(Variant variant, MarkerSeq markerSeq) {
        if (this.sequence != null && !this.sequence.isEmpty()) {
            String seq2 = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
            int idx = variant.getStart() - this.start;
            seq2 = seq2.substring(0, idx) + variant.getAlt() + seq2.substring(idx + 1);
            markerSeq.setSequence(this.isStrandPlus() ? seq2 : GprSeq.reverseWc(seq2));
        }
    }

    public String basesAt(int index, int len) {
        if (this.isStrandMinus()) {
            int idx = this.sequence.length() - index - len;
            return GprSeq.reverseWc(this.sequence.getBases(idx, len));
        }
        return this.sequence.getBases(index, len);
    }

    public String basesAtPos(int pos, int len) {
        int index = pos - this.start;
        if (index < 0) {
            return "";
        }
        return this.basesAt(index, len);
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public String getSequence(Marker marker) {
        if (!this.includes(marker)) {
            return null;
        }
        if (marker.isStrandMinus()) {
            throw new RuntimeException("marker on negative strand not supported");
        }
        return this.basesAtPos(marker.getStart(), marker.size());
    }

    public boolean hasSequence() {
        if (this.size() <= 0) {
            return true;
        }
        return this.sequence != null && !this.sequence.isEmpty();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.setSequence(markerSerializer.getNextField());
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.sequence.getSequence();
    }

    public void setSequence(String sequence2) {
        if (sequence2 == null || sequence2.length() <= 0) {
            this.sequence = DnaSequence.empty();
        }
        if (sequence2.length() != this.size()) {
            if (sequence2.length() > this.size()) {
                sequence2 = sequence2.substring(0, this.size());
            } else {
                char[] ns = new char[this.size() - sequence2.length()];
                Arrays.fill(ns, 'N');
                sequence2 = sequence2 + new String(ns);
            }
        }
        this.sequence = GprSeq.isAmbiguous(sequence2) ? new DnaNSequence(sequence2) : new DnaSequence(sequence2);
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + ":" + this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + (this.sequence != null ? ", sequence: " + this.sequence : "");
    }

    @Override
    public Marker union(Marker m) {
        if (!this.getChromosomeName().equals(m.getChromosomeName())) {
            return null;
        }
        MarkerSeq ms = (MarkerSeq)m;
        int ustart = Math.min(this.start, m.getStart());
        int uend = Math.max(this.end, m.getEnd());
        String seq2 = null;
        if (this.includes(m)) {
            seq2 = this.getSequence();
        } else if (m.includes(this)) {
            seq2 = ms.getSequence();
        } else if (this.intersects(m)) {
            int overlap;
            if (this.start < m.start) {
                overlap = this.end - m.start + 1;
                seq2 = this.getSequence() + ms.getSequence().substring(overlap);
            } else {
                overlap = m.end - this.start + 1;
                seq2 = ms.getSequence() + this.getSequence().substring(overlap);
            }
        }
        MarkerSeq msNew = (MarkerSeq)this.clone();
        msNew.start = ustart;
        msNew.end = uend;
        if (seq2 != null) {
            msNew.setSequence(seq2);
        }
        return msNew;
    }
}

