/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IntervalAndSubIntervals<T extends Marker>
extends Marker
implements Iterable<T> {
    private static final long serialVersionUID = 1636197649250882952L;
    HashMap<String, T> subIntervals;
    ArrayList<T> sorted;
    ArrayList<T> sortedStrand;

    public IntervalAndSubIntervals() {
        this.reset();
    }

    public IntervalAndSubIntervals(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.reset();
    }

    public void add(T t) {
        if (this.subIntervals.put(((Interval)t).getId(), t) != null) {
            throw new RuntimeException(t.getClass().getSimpleName() + " '" + ((Interval)t).getId() + "' is already in " + this.getClass().getSimpleName() + " '" + this.id + "'");
        }
        this.invalidateSorted();
    }

    public void addAll(Iterable<T> ts) {
        for (Marker t : ts) {
            this.add(t);
        }
        this.invalidateSorted();
    }

    public void addAll(Markers markers) {
        for (Marker m : markers) {
            this.add(m);
        }
        this.invalidateSorted();
    }

    @Override
    public IntervalAndSubIntervals<T> apply(Variant variant) {
        if (!this.shouldApply(variant)) {
            return this;
        }
        IntervalAndSubIntervals newMarker = (IntervalAndSubIntervals)super.apply(variant);
        if (newMarker == null) {
            return null;
        }
        newMarker.reset();
        for (Marker m : this) {
            Marker mcopy = m.apply(variant);
            mcopy.setParent(newMarker);
            newMarker.add(mcopy);
        }
        return newMarker;
    }

    @Override
    public IntervalAndSubIntervals<T> clone() {
        IntervalAndSubIntervals copy = (IntervalAndSubIntervals)super.clone();
        copy.reset();
        for (Marker m : this) {
            Marker mcopy = m.clone();
            mcopy.setParent(copy);
            copy.add(mcopy);
        }
        return copy;
    }

    @Override
    public IntervalAndSubIntervals<T> cloneShallow() {
        IntervalAndSubIntervals clone2 = (IntervalAndSubIntervals)super.cloneShallow();
        clone2.reset();
        return clone2;
    }

    public boolean containsId(String id) {
        return this.subIntervals.containsKey(id);
    }

    public T get(String id) {
        return (T)((Marker)this.subIntervals.get(id));
    }

    protected void invalidateSorted() {
        this.sortedStrand = null;
        this.sorted = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.subIntervals.values().iterator();
    }

    public Markers markers() {
        Markers markers = new Markers();
        markers.addAll((Collection<? extends Marker>)this.subIntervals.values());
        return markers;
    }

    public int numChilds() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    @Override
    public Markers query(Marker marker) {
        Markers markers = new Markers();
        for (Marker m : this) {
            if (!m.intersects(marker)) continue;
            markers.add(m);
            Markers subMarkers = m.query(marker);
            if (subMarkers == null) continue;
            markers.add(subMarkers);
        }
        return markers;
    }

    public void remove(T t) {
        this.subIntervals.remove(((Interval)t).getId());
        this.invalidateSorted();
    }

    public void reset() {
        this.subIntervals = new HashMap();
        this.invalidateSorted();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        Markers markers = markerSerializer.getNextFieldMarkers();
        for (Marker m : markers) {
            this.add(m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + markerSerializer.save(this.subIntervals.values());
    }

    @Override
    public void setStrandMinus(boolean strandMinus) {
        this.strandMinus = strandMinus;
        for (Marker t : this) {
            t.setStrandMinus(strandMinus);
        }
        this.invalidateSorted();
    }

    @Override
    public void shiftCoordinates(int shift) {
        super.shiftCoordinates(shift);
        for (Marker m : this.subIntervals.values()) {
            m.shiftCoordinates(shift);
        }
    }

    public synchronized List<T> sorted() {
        if (this.sorted != null) {
            return this.sorted;
        }
        this.sorted = new ArrayList();
        this.sorted.addAll(this.subIntervals.values());
        Collections.sort(this.sorted);
        return this.sorted;
    }

    public synchronized List<T> sortedStrand() {
        if (this.sortedStrand != null) {
            return this.sortedStrand;
        }
        this.sortedStrand = new ArrayList();
        this.sortedStrand.addAll(this.subIntervals.values());
        if (this.isStrandPlus()) {
            Collections.sort(this.sortedStrand, new IntervalComparatorByStart());
        } else {
            Collections.sort(this.sortedStrand, new IntervalComparatorByEnd(true));
        }
        return this.sortedStrand;
    }

    public Collection<T> subintervals() {
        return this.subIntervals.values();
    }
}

