/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSeq;
import ca.mcgill.mcb.pcingola.interval.MarkerWithFrame;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteRegion;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.VariantNonRef;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;

public class Exon
extends MarkerSeq
implements MarkerWithFrame {
    public static int ToStringVersion = 2;
    private static final long serialVersionUID = 5324352193278472543L;
    byte frame = (byte)-1;
    int rank;
    int aaIdxStart = -1;
    int aaIdxEnd = -1;
    ArrayList<SpliceSite> spliceSites;
    ExonSpliceType spliceType = ExonSpliceType.NONE;

    public Exon() {
        this.rank = 0;
        this.type = EffectType.EXON;
        this.spliceSites = new ArrayList();
    }

    public Exon(Transcript parent, int start, int end, boolean strandMinus, String id, int rank) {
        super(parent, start, end, strandMinus, id);
        this.strandMinus = strandMinus;
        this.rank = rank;
        this.type = EffectType.EXON;
        this.spliceSites = new ArrayList();
    }

    public void add(SpliceSite ss) {
        this.spliceSites.add(ss);
    }

    @Override
    public Exon apply(Variant variant) {
        Exon newEx = (Exon)super.apply(variant);
        if (newEx == null) {
            return null;
        }
        newEx.reset();
        for (SpliceSite ss : this.spliceSites) {
            SpliceSite newSs = (SpliceSite)ss.apply(variant);
            if (newSs == null) continue;
            newSs.setParent(newEx);
            newEx.add(newSs);
        }
        return newEx;
    }

    @Override
    public Exon cloneShallow() {
        Exon clone2 = (Exon)super.cloneShallow();
        clone2.frame = this.frame;
        clone2.rank = this.rank;
        clone2.spliceType = this.spliceType;
        return clone2;
    }

    public SpliceSiteRegion createSpliceSiteRegionEnd(int size2) {
        if (size2 > this.size()) {
            size2 = this.size();
        }
        if (size2 <= 0) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionEnd = null;
        spliceSiteRegionEnd = this.isStrandPlus() ? new SpliceSiteRegion(this, this.end - (size2 - 1), this.end, this.strandMinus, this.id) : new SpliceSiteRegion(this, this.start, this.start + (size2 - 1), this.strandMinus, this.id);
        if (spliceSiteRegionEnd != null) {
            this.add(spliceSiteRegionEnd);
        }
        return spliceSiteRegionEnd;
    }

    public SpliceSiteRegion createSpliceSiteRegionStart(int size2) {
        if (size2 > this.size()) {
            size2 = this.size();
        }
        if (size2 <= 0) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionStart = null;
        spliceSiteRegionStart = this.isStrandPlus() ? new SpliceSiteRegion(this, this.start, this.start + (size2 - 1), this.strandMinus, this.id) : new SpliceSiteRegion(this, this.end - (size2 - 1), this.end, this.strandMinus, this.id);
        if (spliceSiteRegionStart != null) {
            this.add(spliceSiteRegionStart);
        }
        return spliceSiteRegionStart;
    }

    public boolean frameCorrection(int frameCorrection) {
        if (frameCorrection <= 0) {
            return true;
        }
        if (this.size() <= frameCorrection) {
            Gpr.debug("Exon too short (size: " + this.size() + "), cannot correct frame!\n" + this);
            return false;
        }
        if (this.isStrandPlus()) {
            this.start += frameCorrection;
        } else {
            this.end -= frameCorrection;
        }
        this.frame = (byte)((this.frame - frameCorrection) % 3);
        while (this.frame < 0) {
            this.frame = (byte)(this.frame + 3);
        }
        String sequence2 = this.getSequence();
        if (sequence2.length() >= frameCorrection) {
            sequence2 = sequence2.substring(frameCorrection);
        }
        this.setSequence(sequence2);
        return true;
    }

    public int getAaIdxEnd() {
        return this.aaIdxEnd;
    }

    public int getAaIdxStart() {
        return this.aaIdxStart;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList<SpliceSite> getSpliceSites() {
        return this.spliceSites;
    }

    public ExonSpliceType getSpliceType() {
        return this.spliceType;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    @Override
    public Markers query(Marker marker) {
        Markers markers = new Markers();
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(marker)) continue;
            markers.add(ss);
        }
        return markers;
    }

    public void reset() {
        this.spliceSites = new ArrayList();
    }

    public VariantEffect.ErrorWarningType sanityCheck(Variant variant) {
        String refStr;
        if (!this.intersects(variant)) {
            return null;
        }
        if (variant.getVariantType() != Variant.VariantType.SNP && variant.getVariantType() != Variant.VariantType.MNP) {
            return null;
        }
        int mstart = Math.max(variant.getStart(), this.start);
        int idxStart = mstart - this.start;
        if (this.sequence.length() <= 0) {
            return VariantEffect.ErrorWarningType.WARNING_SEQUENCE_NOT_AVAILABLE;
        }
        if (idxStart >= this.sequence.length()) {
            return VariantEffect.ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        int mend = Math.min(variant.getEnd(), this.end);
        int len = mend - mstart + 1;
        String realReference = this.basesAt(idxStart, len).toUpperCase();
        int varRefStart = mstart - variant.getStart();
        if (varRefStart < 0) {
            return VariantEffect.ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        int varRefEnd = mend - variant.getStart();
        if (varRefEnd >= (refStr = variant.isNonRef() ? ((VariantNonRef)variant).getVariantRef().alternative() : variant.reference()).length()) {
            return VariantEffect.ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        String variantReference = refStr.substring(varRefStart, varRefEnd + 1);
        if (!realReference.equals(variantReference)) {
            return VariantEffect.ErrorWarningType.WARNING_REF_DOES_NOT_MATCH_GENOME;
        }
        return null;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.frame = (byte)markerSerializer.getNextFieldInt();
        this.rank = markerSerializer.getNextFieldInt();
        this.setSequence(markerSerializer.getNextField());
        String exType = markerSerializer.getNextField();
        if (exType != null && !exType.isEmpty()) {
            this.spliceType = ExonSpliceType.valueOf(exType);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.frame + "\t" + this.rank + "\t" + this.sequence + "\t" + (this.spliceType != null ? this.spliceType.toString() : "");
    }

    public void setAaIdx(int aaIdxStart, int aaIdxEnd) {
        this.aaIdxStart = aaIdxStart;
        this.aaIdxEnd = aaIdxEnd;
    }

    @Override
    public void setFrame(int frame) {
        if (frame > 2 || frame < -1) {
            throw new RuntimeException("Invalid frame value: " + frame);
        }
        this.frame = (byte)frame;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public String toString() {
        switch (ToStringVersion) {
            case 1: {
                return this.getChromosomeName() + ":" + this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + " rank:" + this.rank + (this.sequence != null ? ", sequence: " + this.sequence : "");
            }
            case 2: {
                return this.getChromosomeName() + ":" + this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + ", rank: " + this.rank + ", frame: " + (this.frame >= 0 ? "" + this.frame : ".") + (this.sequence != null ? ", sequence: " + this.sequence : "");
            }
        }
        throw new RuntimeException("Unknown format version: " + ToStringVersion);
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        Transcript tr = (Transcript)this.parent;
        boolean coding = tr.isProteinCoding() || Config.get().isTreatAllAsProteinCoding();
        boolean exonAnnotated = false;
        if (!coding || variant.isInterval() || !variant.isVariant()) {
            variantEffects.add(variant, this, EffectType.EXON, "");
            exonAnnotated = true;
        } else if (tr.isCds(variant)) {
            CodonChange codonChange = CodonChange.factory(variant, tr, variantEffects);
            codonChange.codonChange();
            exonAnnotated = true;
        }
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(variant)) continue;
            ss.variantEffect(variant, variantEffects);
        }
        return exonAnnotated;
    }

    public static enum ExonSpliceType {
        NONE,
        RETAINED,
        SKIPPED,
        ALTTENATIVE_3SS,
        ALTTENATIVE_5SS,
        MUTUALLY_EXCLUSIVE,
        ALTTENATIVE_PROMOMOTER,
        ALTTENATIVE_POLY_A;

    }
}

