/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;

public class Downstream
extends Marker {
    private static final long serialVersionUID = 1636197649250882952L;

    public Downstream() {
        this.type = EffectType.DOWNSTREAM;
    }

    public Downstream(Transcript parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.DOWNSTREAM;
    }

    public int distanceToTr(Variant variant) {
        int dist = (this.parent.isStrandPlus() ? variant.getStart() - this.start : this.end - variant.getStart()) + 1;
        return Math.max(0, dist);
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        int distance = this.distanceToTr(variant);
        VariantEffect variantEffect = new VariantEffect(variant);
        variantEffect.set(this, this.type, this.type.effectImpact(), distance + " bases");
        variantEffect.setDistance(distance);
        variantEffects.add(variantEffect);
        return true;
    }
}

