/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.interval.ChromosomeSimpleName;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.serializer.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class Chromosome
extends Marker {
    private static final long serialVersionUID = 1636197649250882952L;
    double chromosomeNum;
    DnaSequence sequence = null;

    public static int compare(String chr1, String chr2) {
        int chr1Num = Chromosome.number(chr1);
        int chr2Num = Chromosome.number(chr2);
        if (chr1Num > 0 && chr2Num > 0) {
            return chr1Num - chr2Num;
        }
        if (chr1Num > 0 && chr2Num <= 0) {
            return -1;
        }
        if (chr1Num <= 0 && chr2Num > 0) {
            return 1;
        }
        return Chromosome.simpleName(chr1).compareTo(Chromosome.simpleName(chr2));
    }

    public static int number(String chrName) {
        return Gpr.parseIntSafe(ChromosomeSimpleName.get(chrName));
    }

    public static String simpleName(String chrName) {
        return ChromosomeSimpleName.get(chrName);
    }

    public Chromosome() {
    }

    public Chromosome(Genome parent, int start, int end, String id) {
        super(null, start, end, false, id);
        this.parent = parent;
        this.type = EffectType.CHROMOSOME;
        this.setChromosomeName(id);
    }

    @Override
    public Chromosome cloneShallow() {
        Chromosome clone2 = (Chromosome)super.cloneShallow();
        clone2.chromosomeNum = this.chromosomeNum;
        return clone2;
    }

    public int compareChromoName(Interval interval) {
        Chromosome i2 = (Chromosome)interval;
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum == 0.0) {
            return this.id.compareTo(i2.id);
        }
        if (this.chromosomeNum != 0.0 && i2.chromosomeNum == 0.0) {
            return -1;
        }
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum != 0.0) {
            return 1;
        }
        if (this.chromosomeNum - i2.chromosomeNum < 0.0) {
            return -1;
        }
        if (this.chromosomeNum - i2.chromosomeNum > 0.0) {
            return 1;
        }
        return 0;
    }

    public CodonTable getCodonTable() {
        return CodonTables.getInstance().getTable(this.getGenome(), this.getId());
    }

    public DnaSequence getDnaSequence() {
        return this.sequence;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public boolean isMt() {
        String iduc = this.id.toUpperCase();
        return iduc.equals("M") || iduc.startsWith("MT") || iduc.indexOf("MITO") >= 0;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.setChromosomeName(this.id);
    }

    private void setChromosomeName(String chromo) {
        this.id = Chromosome.simpleName(chromo);
        this.chromosomeNum = Gpr.parseIntSafe(this.id);
    }

    public void setLength(int len) {
        this.end = len - 1;
    }

    public void setSequence(String sequenceStr) {
        this.sequence = new DnaSequence(sequenceStr, true);
        this.setLength(sequenceStr.length());
    }
}

