/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.gtex;

import ca.mcgill.mcb.pcingola.gtex.Gtex;
import gnu.trove.list.array.TDoubleArrayList;

public class GtexExperiment {
    Gtex gtex;
    String id;
    String tissueType;
    String tissueTypeDetail;
    TDoubleArrayList values;

    public GtexExperiment(Gtex gtex, String line) {
        this.gtex = gtex;
        this.parse(line);
        this.values = new TDoubleArrayList();
    }

    public GtexExperiment(Gtex gtex, String id, String tissueType, String tissueTypeDetail) {
        this.gtex = gtex;
        this.id = id;
        this.tissueType = tissueType;
        this.tissueTypeDetail = tissueTypeDetail;
        this.values = new TDoubleArrayList();
    }

    public void add(double value2) {
        this.values.add(value2);
    }

    public Gtex getGtex() {
        return this.gtex;
    }

    public String getId() {
        return this.id;
    }

    public String getTissueType() {
        return this.tissueType;
    }

    public String getTissueTypeDetail() {
        return this.tissueTypeDetail;
    }

    public double getValue(int idx) {
        return this.values.get(idx);
    }

    public double getValue(String geneId) {
        int idx = this.gtex.getIndex(geneId);
        return this.values.get(idx);
    }

    protected void parse(String line) {
        String[] fields = line.split("\t");
        this.id = fields[0];
        this.tissueType = fields[5];
        this.tissueTypeDetail = fields[6];
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        return this.id + "\t" + this.tissueType + "\t" + this.tissueTypeDetail;
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this);
        for (int i = 0; i < this.values.size(); ++i) {
            sb.append(this.values.get(i) + "\t");
        }
        return sb.toString();
    }
}

