/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.gsa;

import gnu.trove.list.array.TDoubleArrayList;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Gamma;

public class ScoreList {
    public static final double SIGNIFICANCE_LEVEL_95 = 0.05;
    String geneId;
    TDoubleArrayList scores = new TDoubleArrayList();
    boolean sorted = false;

    public static double chiSquareCDFComplementary(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Gamma.regularizedGammaQ((double)nu / 2.0, chiSquare / 2.0);
    }

    public void add(double score) {
        this.scores.add(score);
    }

    public double avg() {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        double sum2 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum2 += this.getScore(i);
        }
        return sum2 / (double)this.size();
    }

    public double avgLargestTop(int topN) {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        this.sort();
        double sum2 = 0.0;
        int min2 = Math.max(0, this.size() - topN);
        int count2 = 0;
        int i = min2;
        while (i < this.size()) {
            sum2 += this.getScore(i);
            ++i;
            ++count2;
        }
        return sum2 / (double)count2;
    }

    public double avgSmallestTop(int topN) {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        this.sort();
        double sum2 = 0.0;
        int max2 = Math.min(this.size(), topN);
        for (int i = 0; i < max2; ++i) {
            sum2 += this.getScore(i);
        }
        return sum2 / (double)max2;
    }

    public double cdf(double p) {
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int idx = this.scores.binarySearch(p);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return (double)idx / (double)this.size();
    }

    public double cdfUpper(double p) {
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int idx = this.scores.binarySearch(p);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return (double)(this.size() - idx) / (double)this.size();
    }

    protected double getDefaultValue() {
        return 0.0;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public double getScore(int index) {
        return this.scores.get(index);
    }

    public double max() {
        double max2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            max2 = Math.max(max2, this.getScore(i));
        }
        return max2;
    }

    public double min() {
        double min2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            min2 = Math.min(min2, this.getScore(i));
        }
        return min2;
    }

    public double pValueBonferroni() {
        if (this.scores.size() <= 0) {
            return 1.0;
        }
        return Math.min(1.0, this.min() * (double)this.scores.size());
    }

    public double pValueFdr(double alpha) {
        if (this.size() <= 0) {
            return 1.0;
        }
        int total = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getScore(i) > 0.0)) continue;
            ++total;
        }
        double tot = total;
        if (total <= 0) {
            return 1.0;
        }
        this.sort();
        int count2 = 0;
        double pFdrMax = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double pFdr;
            double pvalue = this.getScore(i);
            if (!(pvalue > 0.0) || !((pFdr = tot * pvalue / (double)(++count2)) <= alpha) && !(pFdr < pFdrMax)) continue;
            pFdrMax = pFdr;
        }
        return pFdrMax;
    }

    public double pValueFisherChi2() {
        if (this.size() <= 0) {
            return 1.0;
        }
        double sum2 = 0.0;
        int count2 = 0;
        for (int i = 0; i < this.size(); ++i) {
            double pvalue = this.getScore(i);
            if (!(pvalue > 0.0)) continue;
            sum2 += Math.log(pvalue);
            ++count2;
        }
        if (count2 <= 0) {
            return 1.0;
        }
        double chi2 = -2.0 * sum2;
        int k = 2 * count2;
        double pValue = ScoreList.chiSquareCDFComplementary(chi2, k);
        return pValue;
    }

    public double pValueSimes() {
        if (this.size() <= 0) {
            return 1.0;
        }
        int total = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getScore(i) > 0.0)) continue;
            ++total;
        }
        double tot = total;
        if (total <= 0) {
            return 1.0;
        }
        this.sort();
        int count2 = 0;
        double pSimesMin = 1.0;
        for (int i = 0; i < this.size(); ++i) {
            double pvalue = this.getScore(i);
            if (!(pvalue > 0.0)) continue;
            double pSimes = pvalue * tot / (double)(++count2);
            pSimesMin = Math.min(pSimesMin, pSimes);
        }
        return pSimesMin;
    }

    public double pValueZScore() {
        if (this.size() <= 0) {
            return 1.0;
        }
        double sum2 = 0.0;
        int count2 = 0;
        for (int i = 0; i < this.size(); ++i) {
            double pvalue = this.getScore(i);
            if (!(pvalue > 0.0)) continue;
            double z = new NormalDistribution().inverseCumulativeProbability(pvalue);
            sum2 += z;
            ++count2;
        }
        if (count2 <= 0) {
            return 1.0;
        }
        double zsum = sum2 / Math.sqrt(count2);
        double pValue = new NormalDistribution(0.0, 1.0).cumulativeProbability(zsum);
        return pValue;
    }

    public double quantile(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new RuntimeException("Quantile out of range: " + quantile + " .Expected range [0.0 , 1.0].");
        }
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int num = (int)(quantile * (double)this.size());
        return this.scores.get(num);
    }

    public double score(ScoreSummary pvalueSummary) {
        switch (pvalueSummary) {
            case MIN: {
                return this.min();
            }
            case MAX: {
                return this.max();
            }
            case AVG: {
                return this.avg();
            }
            case AVG_MIN_10: {
                return this.avgSmallestTop(10);
            }
            case AVG_MAX_10: {
                return this.avgLargestTop(10);
            }
            case FISHER_CHI_SQUARE: {
                return this.pValueFisherChi2();
            }
            case Z_SCORES: {
                return this.pValueZScore();
            }
            case SIMES: {
                return this.pValueSimes();
            }
            case BONFERRONI: {
                return this.pValueBonferroni();
            }
            case FDR: {
                return this.pValueFdr(0.05);
            }
            case SUM: {
                return this.sum();
            }
        }
        throw new RuntimeException("Unimplemented method for summary '" + (Object)((Object)pvalueSummary) + "'");
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public int size() {
        return this.scores.size();
    }

    void sort() {
        if (!this.sorted) {
            this.scores.sort();
            this.sorted = true;
        }
    }

    public double sum() {
        double sum2 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum2 += this.getScore(i);
        }
        return sum2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.geneId + "\t" + this.size() + "\t");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(String.format(" %.2e", this.getScore(i)));
        }
        return sb.toString();
    }

    public static enum ScoreSummary {
        MIN,
        AVG,
        AVG_MIN_10,
        FISHER_CHI_SQUARE,
        Z_SCORES,
        SIMES,
        BONFERRONI,
        FDR,
        MAX,
        AVG_MAX_10,
        SUM;

    }
}

