/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.geneSets.algorithm;

import ca.mcgill.mcb.pcingola.geneSets.GeneSet;
import ca.mcgill.mcb.pcingola.geneSets.GeneSets;
import ca.mcgill.mcb.pcingola.geneSets.Result;
import ca.mcgill.mcb.pcingola.geneSets.algorithm.EnrichmentAlgorithm;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apfloat.Apfloat;
import org.apfloat.Apint;

public abstract class EnrichmentAlgorithmGreedy
extends EnrichmentAlgorithm {
    public static final double DEFAULT_MAX_PVALUE = 0.05;
    protected boolean adjustedPvalue = true;
    protected double maxPvalue = 0.05;
    protected double maxPvalueAjusted = 0.05;
    Date start;
    Date latest;

    public EnrichmentAlgorithmGreedy(GeneSets geneSets, int numberToSelect) {
        super(geneSets, numberToSelect);
    }

    protected Result greedyPvalue(Result prevResult) {
        return this.greedyPvalue(prevResult, this.minGeneSetSize, this.maxGeneSetSize);
    }

    protected Result greedyPvalue(Result prevResult, int minGeneSetSize, int maxGeneSetSize) {
        Apint pValue = Apfloat.ONE;
        int geneSetCount = 0;
        HashSet<GeneSet> genesetSet = new HashSet<GeneSet>();
        if (prevResult.getGeneSets() != null) {
            genesetSet.addAll(prevResult.getGeneSets());
        }
        this.start = new Date();
        this.latest = new Date();
        Result best = new Result(prevResult);
        best.setPvalue(1.0);
        for (GeneSet geneSet : this.geneSets) {
            if (geneSet.getGeneCount() <= 0 || genesetSet != null && genesetSet.contains(geneSet) || geneSet.getGeneCount() < minGeneSetSize || geneSet.getGeneCount() > maxGeneSetSize) continue;
            LinkedList<GeneSet> geneSetListNew = new LinkedList<GeneSet>();
            if (genesetSet != null) {
                geneSetListNew.addAll(genesetSet);
            }
            geneSetListNew.add(geneSet);
            pValue = this.pValue(geneSetListNew);
            if (pValue.compareTo((Apfloat)Apfloat.ZERO) > 0 && pValue.compareTo(best.getPvalue()) < 0) {
                best.set(geneSetListNew, (Apfloat)pValue);
            }
            this.showProgress(geneSetListNew, (Apfloat)pValue, best);
            ++geneSetCount;
        }
        best.addGeneSetCount(geneSetCount);
        if (this.debug) {
            Gpr.debug("Select: Best p-value: " + best.getPvalueDouble());
        }
        return best;
    }

    @Override
    void printTitle() {
        if (this.htmlTable) {
            System.out.println("<table border=0> <tr bgcolor=\"cccccc\"> <th>Iteration</th>\t<th>p-value</th>\t<th>p-value adj</th>\t<th>Latest result</th>\t<th>Size</th>\t<th>Description</th>\t<th>Interesting genes </th>\t<th> Score </th> </tr>");
        } else if (this.verbose) {
            System.out.println("Iteration\tp-value\tp-value adj\tLatest result\tSize\tDescription\tResult\tInteresting genes");
        }
    }

    @Override
    public Result select() {
        int iteration;
        this.printTitle();
        Result result2 = new Result();
        for (iteration = 1; iteration <= this.numberToSelect; ++iteration) {
            result2 = this.greedyPvalue(result2);
            if (this.verbose) {
                this.printResult(iteration, result2);
            }
            if (!this.stopCriteria(result2)) continue;
            if (!this.debug) break;
            System.out.println("\tStop criteria met.");
            break;
        }
        if (this.htmlTable) {
            System.out.println("</table>");
        } else if (!this.verbose) {
            this.printResult(iteration - 1, result2);
        }
        return result2;
    }

    public void setAdjustedPvalue(boolean adjustedPvalue) {
        this.adjustedPvalue = adjustedPvalue;
    }

    @Override
    public void setMaxGeneSetSize(int maxGeneSetSize) {
        this.maxGeneSetSize = maxGeneSetSize;
    }

    public void setMaxPvalue(double maxPvalue) {
        this.maxPvalue = maxPvalue;
    }

    public void setMaxPvalueAjusted(double maxPvalueAjusted) {
        this.maxPvalueAjusted = maxPvalueAjusted;
    }

    @Override
    public void setMinGeneSetSize(int minGeneSetSize) {
        this.minGeneSetSize = minGeneSetSize;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void showProgress(List<GeneSet> geneSetListNew, Apfloat pValue, Result best) {
        Date now = new Date();
        long elapsed = now.getTime() - this.latest.getTime();
        long elapsedStart = now.getTime() - this.start.getTime();
        if (this.verbose && elapsed > PRINT_SOMETHING_TIME) {
            this.latest = now;
            System.err.println("\t\t\tElapsed:" + elapsedStart / 1000L + " secs\tGene sets: " + geneSetListNew + "\tpValue: " + pValue + "\tbestPvalue: " + best.getPvalue() + "\t" + best.getGeneSets());
        }
    }

    protected boolean stopCriteria(Result result2) {
        if (result2 == null) {
            return true;
        }
        GeneSet geneSet = result2.getLatestGeneSet();
        if (geneSet == null) {
            return true;
        }
        if (this.adjustedPvalue) {
            return result2.getPvalueAdjusted() > this.maxPvalueAjusted;
        }
        return result2.getPvalue().doubleValue() > this.maxPvalue;
    }
}

