/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.geneOntology;

import ca.mcgill.mcb.pcingola.geneOntology.GoTerm;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GoTerms
implements Iterable<GoTerm>,
Serializable {
    public static boolean debug = false;
    public static boolean verbose = false;
    static int warnCount = 0;
    String label;
    int maxRank;
    String nameSpace;
    HashMap<String, GoTerm> goTermsByGoTermAcc = new HashMap();
    HashMap<String, Set<GoTerm>> goTermsBySymbolId = new HashMap();
    HashSet<String> interestingSymbolIdsSet = new HashSet();
    HashMap<String, Integer> rankSymbolId;

    public GoTerms() {
        this.rankSymbolId = new HashMap();
        this.maxRank = 0;
    }

    public GoTerms(String oboFile, String nameSpace, String interestingGenesFile, String geneAssocFile, boolean removeObsolete, boolean useGeneId) {
        this.nameSpace = nameSpace;
        this.maxRank = 0;
        if (oboFile != null) {
            this.readOboFile(oboFile, removeObsolete);
        }
        if (geneAssocFile != null) {
            this.readGeneAssocFile(geneAssocFile, useGeneId);
        }
        if (interestingGenesFile != null) {
            this.readInterestingSymbolIdsFile(interestingGenesFile);
        }
    }

    public GoTerm add(GoTerm goTerm) {
        this.goTermsByGoTermAcc.put(goTerm.getAcc(), goTerm);
        for (String symbolId : goTerm.getSymbolIdSet()) {
            this.addSymbolId(goTerm, symbolId);
        }
        return goTerm;
    }

    private void addInterestingSymbol(String symbolId, HashSet<String> noGoTermFound) {
        this.interestingSymbolIdsSet.add(symbolId);
        Set<GoTerm> goTerms = this.getGoTermsBySymbolId(symbolId);
        if (goTerms != null) {
            for (GoTerm gt : goTerms) {
                gt.addInterestingSymbolId(symbolId);
            }
        } else if (noGoTermFound != null) {
            noGoTermFound.add(symbolId);
        } else {
            Gpr.debug("No GOTerms related to SymbolId:" + symbolId + " were found in this DAG (" + this.label + ")");
        }
    }

    public void addInterestingSymbol(String symbolId, int rank, HashSet<String> noGoTermFound) {
        this.rankSymbolId.put(symbolId, rank);
        this.addInterestingSymbol(symbolId, noGoTermFound);
        if (this.maxRank < rank) {
            this.maxRank = rank;
        }
    }

    public boolean addSymbolId(GoTerm goTerm, String symbolId) {
        goTerm.addSymbolId(symbolId);
        Set<GoTerm> termsSet = this.goTermsBySymbolId.get(symbolId);
        if (termsSet == null) {
            termsSet = new HashSet<GoTerm>();
            this.goTermsBySymbolId.put(symbolId, termsSet);
        }
        termsSet.add(goTerm);
        return true;
    }

    public void addSymbolsFromChilds() {
        for (GoTerm gt : this) {
            gt.addSymbolsFromChilds(gt);
        }
    }

    public Set<String> allSymbols() {
        HashSet<String> syms = new HashSet<String>();
        for (GoTerm gt : this) {
            syms.addAll(gt.getSymbolIdSet());
        }
        return syms;
    }

    public void checkInterestingSymbolIds(Set<String> interestingSymbolIds) {
        HashSet<String> issc = new HashSet<String>();
        if (debug) {
            Gpr.debug("Checking symbols (" + interestingSymbolIds.size() + ") : " + interestingSymbolIds);
        }
        for (GoTerm gt : this) {
            issc.addAll(gt.getInterestingSymbolIdSet());
        }
        if (!interestingSymbolIds.containsAll(issc)) {
            throw new RuntimeException("Not every term in symbolIds is marked in DAG:" + this.label + " as an interesting symbol");
        }
        if (!issc.containsAll(interestingSymbolIds)) {
            throw new RuntimeException("Not every term marked as interesting in DAG " + this.label + " is from symbolIds\n\tInteresting symbols(" + issc.size() + "): " + issc + "\n\tsymbolIds(" + interestingSymbolIds.size() + "): " + interestingSymbolIds);
        }
        if (this.rankSymbolId != null && this.rankSymbolId.keySet().size() > 0) {
            int maxRank = interestingSymbolIds.size();
            int[] ranksUsed = new int[maxRank + 1];
            for (int i = 0; i < maxRank; ++i) {
                ranksUsed[i] = 0;
            }
            for (String symbolId : interestingSymbolIds) {
                Integer rank = this.rankSymbolId.get(symbolId);
                if (rank == null || rank <= 0 || rank > maxRank) {
                    throw new RuntimeException("Invalid rank for symbolId:" + symbolId + ", rank:" + rank + "(should be [1," + maxRank + "]");
                }
                int n = rank;
                ranksUsed[n] = ranksUsed[n] + 1;
            }
            for (int rank = 1; rank < maxRank; ++rank) {
                if (ranksUsed[rank] == 1) continue;
                throw new RuntimeException("Rank number " + rank + " is used " + ranksUsed[rank] + " times (should be used exactly 1 time)");
            }
        }
    }

    public GoTerm disjointSet(List<GoTerm> goTermList, int activeSets) {
        GoTerm gtUnion = new GoTerm("UNION", null, null, null);
        GoTerm gtIntersect = new GoTerm("INTERSECTION", null, null, null);
        int i = 0;
        boolean firstIntersection = true;
        for (GoTerm goTerm : goTermList) {
            boolean biti;
            boolean bl = biti = ((long)activeSets & 1L << i) > 0L;
            if (biti) {
                if (firstIntersection) {
                    gtIntersect.union(goTerm);
                    firstIntersection = false;
                } else {
                    gtIntersect.intersection(goTerm);
                    if (gtIntersect.getTotalCount() <= 0) {
                        return gtIntersect;
                    }
                }
            } else {
                gtUnion.union(goTerm);
            }
            ++i;
        }
        gtIntersect.setMinus(gtUnion);
        return gtIntersect;
    }

    GoTerm findOrCreate(String symbolId) {
        GoTerm gt = this.getGoTerm(symbolId);
        if (gt == null) {
            gt = new GoTerm(symbolId, this, this.nameSpace, "");
        }
        this.goTermsByGoTermAcc.put(gt.getAcc(), gt);
        return gt;
    }

    public GoTerm getGoTerm(String goTermAcc) {
        return this.goTermsByGoTermAcc.get(goTermAcc);
    }

    public HashMap<String, GoTerm> getGoTermsByGoTermAcc() {
        return this.goTermsByGoTermAcc;
    }

    public HashMap<String, Set<GoTerm>> getGoTermsBySymbolId() {
        return this.goTermsBySymbolId;
    }

    public Set<GoTerm> getGoTermsBySymbolId(String symbolId) {
        return this.goTermsBySymbolId.get(symbolId);
    }

    public HashSet<String> getInterestingSymbolIdsSet() {
        return this.interestingSymbolIdsSet;
    }

    public int getInterestingSymbolIdsSize() {
        return this.interestingSymbolIdsSet.size();
    }

    public String getLabel() {
        return this.label;
    }

    public int getMaxRank() {
        return this.maxRank;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public int getRank(String symbolId) {
        Integer rank = this.rankSymbolId.get(symbolId);
        if (rank == null) {
            return 0;
        }
        return rank;
    }

    public HashMap<String, Integer> getRankSymbolId() {
        return this.rankSymbolId;
    }

    @Override
    public Iterator<GoTerm> iterator() {
        return this.goTermsByGoTermAcc.values().iterator();
    }

    public Set<String> keySet() {
        return this.goTermsByGoTermAcc.keySet();
    }

    public int levels() {
        int maxLevel = 0;
        for (GoTerm gt : this) {
            maxLevel = Math.max(maxLevel, gt.getLevel());
        }
        return maxLevel;
    }

    public List<GoTerm> listTopTerms(int numberToSelect) {
        LinkedList<GoTerm> list2 = new LinkedList<GoTerm>();
        LinkedList<GoTerm> ll = new LinkedList<GoTerm>();
        for (String go : this.goTermsByGoTermAcc.keySet()) {
            ll.add(this.goTermsByGoTermAcc.get(go));
        }
        Collections.sort(ll);
        int i = 0;
        for (GoTerm goTerm : ll) {
            if (i++ >= numberToSelect) break;
            list2.add(goTerm);
        }
        return list2;
    }

    public int numberOfInterestingSymbols() {
        HashSet<String> intSym = new HashSet<String>();
        for (GoTerm gt : this) {
            intSym.addAll(gt.getInterestingSymbolIdSet());
        }
        return intSym.size();
    }

    public int numberOfNodes() {
        return this.goTermsByGoTermAcc.keySet().size();
    }

    public int numberOfNodesWithOneInterestingSymbol() {
        int num = 0;
        for (GoTerm gt : this) {
            if (gt.getInterestingSymbolIdsSize() < 1) continue;
            ++num;
        }
        return num;
    }

    public int numberOfNodesWithOneSymbol() {
        int num = 0;
        for (GoTerm gt : this) {
            if (gt.getTotalCount() < 1) continue;
            ++num;
        }
        return num;
    }

    public int numberOfSymbols() {
        HashSet<String> syms = new HashSet<String>();
        for (GoTerm gt : this) {
            syms.addAll(gt.getSymbolIdSet());
        }
        return syms.size();
    }

    public void readGeneAssocFile(String goGenesFile, boolean useGeneId) {
        try {
            String line;
            System.err.println("Reading gene association file: '" + goGenesFile + "'");
            HashSet<String> notFound = new HashSet<String>();
            BufferedReader inFile = Gpr.reader(goGenesFile);
            int lineNum = 1;
            while ((line = inFile.readLine()) != null) {
                if (!line.startsWith("!")) {
                    String[] items = line.split("\t");
                    if (items.length > 4) {
                        String geneName = useGeneId ? items[1] : items[2];
                        String goTermAcc = items[4];
                        GoTerm goTerm = this.getGoTerm(goTermAcc);
                        if (goTerm == null) {
                            notFound.add(goTermAcc);
                        } else {
                            this.addSymbolId(goTerm, geneName);
                        }
                    } else {
                        System.err.println("Ignoring line " + lineNum + ": '" + line + "'");
                    }
                }
                ++lineNum;
            }
            inFile.close();
            if (notFound.size() > 0) {
                LinkedList ll = new LinkedList(notFound);
                Collections.sort(ll);
                System.err.println("WARNING: Couldn't find some GOTerms while reading file '" + goGenesFile + "'\n\tNot found (" + notFound.size() + ") : " + ll);
            }
            if (verbose) {
                System.err.println("Finished reding GoGenes file '" + goGenesFile + "' : " + lineNum + " lines.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readInterestingSymbolIdsFile(String fileName) {
        int lineNum;
        System.err.println("Reading 'interesting' genes from file: '" + fileName + "'");
        this.resetInterestingSymbolIds();
        HashSet<String> noGoTermFound = new HashSet<String>();
        HashSet symbolNotFound = new HashSet();
        if (fileName.equals("-")) {
            return;
        }
        try {
            String line;
            BufferedReader inFile = new BufferedReader(new FileReader(fileName));
            lineNum = 1;
            while ((line = inFile.readLine()) != null) {
                String symbolName = line.trim();
                this.addInterestingSymbol(symbolName, lineNum, noGoTermFound);
                ++lineNum;
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (symbolNotFound.size() > 0 || noGoTermFound.size() > 0) {
            LinkedList<String> ngtfs = new LinkedList<String>(noGoTermFound);
            Collections.sort(ngtfs);
            System.err.println("WARNING: There were some missing values while reading interesting symbolIds file: '" + fileName + "'" + "\n\tGenes's list size: " + lineNum + "\n\tFound: " + this.getInterestingSymbolIdsSize() + "\n\tNo GOTerm found for symbolIds (" + ngtfs.size() + "): " + ngtfs);
        }
    }

    public void readOboFile(String oboFile, boolean removeObsolete) {
        try {
            String line;
            BufferedReader inFile = Gpr.reader(oboFile);
            int found = 0;
            int removed = 0;
            String goTermAcc = null;
            String isa = null;
            GoTerm goTerm = null;
            HashSet goNotFound = new HashSet();
            int lineNum = 0;
            while ((line = inFile.readLine()) != null) {
                if (line.startsWith("id: ")) {
                    goTermAcc = line.substring(4);
                    goTerm = goTermAcc.startsWith("GO:") ? this.findOrCreate(goTermAcc) : null;
                } else if (goTerm != null) {
                    if (line.startsWith("namespace: ")) {
                        String termNameSpace = line.substring(11);
                        goTerm.setNameSpace(termNameSpace);
                        if (this.nameSpace != null && !this.nameSpace.equals(termNameSpace)) {
                            goTermAcc = null;
                        }
                    } else if (line.startsWith("name: ")) {
                        goTerm.setSescription(line.substring(6).trim());
                    } else if (line.startsWith("is_obsolete: ") && removeObsolete) {
                        this.removeGOTerm(goTermAcc);
                        ++removed;
                    } else if (goTermAcc != null && line.startsWith("is_a: ")) {
                        isa = line.substring(6, 16);
                        GoTerm parent = this.findOrCreate(isa);
                        parent.addChild(goTerm);
                    }
                }
                ++lineNum;
            }
            inFile.close();
            if (goNotFound.size() > 0) {
                LinkedList ll = new LinkedList(goNotFound);
                Collections.sort(ll);
                System.err.println("WARNING: Some GO-Terms were not found while loading OBO file '" + oboFile + "':\n\tNot found: " + goNotFound.size() + "\n\tFound:" + found + "\n\tNot found GOTerms: " + ll);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeGOTerm(String goTermAcc) {
        this.goTermsByGoTermAcc.remove(goTermAcc);
    }

    public void resetInterestingSymbolIds() {
        this.maxRank = 0;
        for (GoTerm gt : this) {
            gt.resetInterestingSymbolIdSet();
        }
    }

    public Set<GoTerm> rootNodes() {
        HashSet<GoTerm> roots = new HashSet<GoTerm>();
        for (GoTerm gt : this) {
            roots.add(gt.rootNode());
        }
        return roots;
    }

    public void saveGseaGeneSets(String fileName) {
        StringBuffer out = new StringBuffer();
        for (GoTerm gt : this) {
            if (gt.getSymbolIdSet().size() <= 0) continue;
            out.append(gt.getAcc() + "\t" + gt.getDescription() + "\t");
            for (String symbolId : gt.getSymbolIdSet()) {
                out.append(symbolId + "\t");
            }
            out.append("\n");
        }
        Gpr.toFile(fileName, out);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        LinkedList<GoTerm> ll = new LinkedList<GoTerm>();
        for (String go : this.goTermsByGoTermAcc.keySet()) {
            ll.add(this.goTermsByGoTermAcc.get(go));
        }
        Collections.sort(ll);
        for (GoTerm goTerm : ll) {
            stb.append(goTerm.toStringAll() + "\n");
        }
        return stb.toString();
    }

    public Collection<GoTerm> values() {
        return this.goTermsByGoTermAcc.values();
    }
}

