/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class GenBank
extends Features {
    public static final int FEATURE_NAME_FIELD_LEN = 20;

    public GenBank(LineFileIterator lineFileIterator) {
        super(lineFileIterator);
    }

    public GenBank(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        int end = Math.min(20, line.length());
        String featName = line.substring(0, end).trim();
        if (featName.isEmpty()) {
            return false;
        }
        return Gpr.parseIntSafe(featName = featName.split(" ")[0]) <= 0;
    }

    protected void parseFieldLine(String name, String valueOri, int fieldLineNum) {
        String value2 = valueOri.trim();
        if (name.equals("LOCUS")) {
            String[] subfields = value2.split(" ");
            this.locusName = subfields[0];
            if (subfields.length > 1) {
                this.sequenceLength = Gpr.parseIntSafe(subfields[1]);
            }
            if (subfields.length > 2) {
                this.moleculeType = subfields[2];
            }
            if (subfields.length > 3) {
                this.shape = subfields[3];
            }
            if (subfields.length > 4) {
                this.division = subfields[4];
            }
            if (subfields.length > 5) {
                this.date = subfields[5];
            }
        } else if (name.equals("DEFINITION")) {
            this.definition = this.definition + value2;
        } else if (name.equals("ACCESSION")) {
            this.accession = this.accession + value2;
        } else if (name.equals("VERSION")) {
            this.version = this.version + value2;
        } else if (name.equals("KEYWORDS")) {
            this.keywords = this.keywords + value2;
        } else if (name.equals("SOURCE")) {
            this.source = this.source + value2;
        } else if (name.equals("REFERENCE")) {
            if (fieldLineNum == 0) {
                this.references.add(new StringBuffer());
            }
            ((StringBuffer)this.references.get(this.references.size() - 1)).append(value2 + "\n");
        } else if (name.equals("FEATURES")) {
            if (fieldLineNum > 0) {
                this.featuresStr.append(valueOri + "\n");
            }
        } else if (name.equals("ORIGIN")) {
            String[] seq2 = value2.split(" ", 2);
            if (seq2.length > 1) {
                String s = seq2[1].replaceAll("\\s", "");
                this.sequence.append(s);
            }
        } else if (debug) {
            System.err.println("Ignored feature '" + name + "'");
        }
    }

    @Override
    public void readFile() {
        int fieldLineNum = 0;
        String name = null;
        String value2 = "";
        if (debug) {
            Gpr.debug("NAME: " + name + "\tvalue: " + value2);
        }
        for (String line : this.lineFileIterator) {
            if (line.startsWith("//")) break;
            value2 = line;
            if (!line.startsWith(" ")) {
                String[] kv = line.split(" ", 2);
                name = kv[0];
                String string2 = value2 = kv.length > 1 ? kv[1] : "";
                if (debug) {
                    Gpr.debug("Line: " + line + "\n\tNAME: " + name + "\tvalue: " + value2);
                }
                fieldLineNum = 0;
            }
            if (name == null) continue;
            this.parseFieldLine(name, value2, fieldLineNum);
            ++fieldLineNum;
        }
        this.parseFeatures();
    }
}

