/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.genBank.FeatureCoordinates;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Features
implements Iterable<Feature> {
    public static boolean debug = false;
    public static final int MAX_LEN_TO_SHOW = 200;
    public static final String COMPLEMENT = "complement";
    public static final String JOIN = "join";
    public static final String ORDER = "order";
    String locusName;
    String moleculeType;
    String shape;
    String division;
    String date;
    int sequenceLength;
    String definition = "";
    String accession = "";
    String version = "";
    String keywords = "";
    String source = "";
    String organism = "";
    StringBuffer featuresStr;
    StringBuffer sequence;
    ArrayList<Feature> features;
    ArrayList<StringBuffer> references = new ArrayList();
    LineFileIterator lineFileIterator;

    public Features(LineFileIterator lineFileIterator) {
        this.featuresStr = new StringBuffer();
        this.sequence = new StringBuffer();
        this.features = new ArrayList();
        this.lineFileIterator = lineFileIterator;
        this.readFile();
    }

    public Features(String fileName) {
        this.featuresStr = new StringBuffer();
        this.sequence = new StringBuffer();
        this.features = new ArrayList();
        this.open(fileName);
        this.readFile();
    }

    void addFeature(String typeStr, StringBuilder values2, int lineNum) {
        Feature.Type type = Feature.Type.parse(typeStr);
        if (type == null) {
            if (debug) {
                Gpr.debug("WARNING: Unknown feature '" + typeStr + "', not added.");
            }
            return;
        }
        try {
            Feature newFeature = this.featureFactory(type, values2.toString(), lineNum);
            this.features.add(newFeature);
        }
        catch (Exception e) {
            Gpr.debug("Error parsing feature type '" + typeStr + "' -> '" + (Object)((Object)type) + "':\n" + values2);
            throw new RuntimeException(e);
        }
    }

    Feature featureFactory(Feature.Type type, String def, int lineNum) {
        boolean complement = false;
        int firstLine = def.indexOf("\n");
        String locStr = firstLine >= 0 ? def.substring(0, firstLine) : def;
        Tuple<String, Boolean> stripped = this.strip(locStr);
        locStr = (String)stripped.first;
        complement = (Boolean)stripped.second;
        String[] locs = locStr.split(",");
        LinkedList<FeatureCoordinates> fcList = new LinkedList<FeatureCoordinates>();
        int startMin = Integer.MAX_VALUE;
        int endMax = 0;
        for (String loc : locs) {
            int end;
            int start;
            stripped = this.strip(loc);
            loc = (String)stripped.first;
            complement |= ((Boolean)stripped.second).booleanValue();
            String[] startEnd = (loc = loc.replaceAll("[<>()]", "")).split("[\\.]+");
            if (startEnd.length == 2) {
                start = Gpr.parseIntSafe(startEnd[0]);
                end = Gpr.parseIntSafe(startEnd[1]);
            } else if (startEnd.length == 1) {
                end = start = Gpr.parseIntSafe(startEnd[0]);
            } else {
                throw new RuntimeException("Cannot calculate start & end coordinates: '" + loc + "'");
            }
            startMin = Math.min(startMin, start);
            endMax = Math.max(endMax, end);
            fcList.add(new FeatureCoordinates(start, end, complement));
        }
        Feature feature = new Feature(type, def, startMin, endMax, complement, lineNum);
        if (fcList.size() > 1) {
            for (FeatureCoordinates fc : fcList) {
                feature.add(fc);
            }
        }
        return feature;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getDate() {
        return this.date;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDivision() {
        return this.division;
    }

    public ArrayList<Feature> getFeatures() {
        return this.features;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLocusName() {
        return this.locusName;
    }

    public String getMoleculeType() {
        return this.moleculeType;
    }

    public String getOrganism() {
        return this.organism;
    }

    public ArrayList<StringBuffer> getReferences() {
        return this.references;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public String getShape() {
        return this.shape;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    protected abstract boolean isNewFeature(String var1);

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    protected void open(String fileName) {
        if (!Gpr.canRead(fileName)) {
            throw new RuntimeException("Cannot read file '" + fileName + "'");
        }
        if (this.lineFileIterator != null) {
            this.lineFileIterator.close();
        }
        this.lineFileIterator = new LineFileIterator(fileName);
    }

    protected void parseFeatures() {
        if (this.featuresStr.length() <= 0) {
            return;
        }
        String type = null;
        String value2 = "";
        StringBuilder values2 = new StringBuilder();
        int lineNum = 0;
        for (String line : this.featuresStr.toString().split("\n")) {
            ++lineNum;
            if (this.isNewFeature(line)) {
                String[] kv = line.trim().split(" ", 2);
                if (kv.length > 1) {
                    if (type != null) {
                        this.addFeature(type, values2, lineNum);
                    }
                    type = kv[0];
                    value2 = kv[1].trim();
                } else {
                    type = line.trim();
                    value2 = "";
                }
                values2 = new StringBuilder();
            } else {
                value2 = line.trim();
            }
            if (value2.startsWith("/")) {
                values2.append("\n");
            }
            values2.append(value2);
        }
        this.addFeature(type, values2, lineNum);
    }

    protected abstract void readFile();

    String removeStartStr(String str, String startStr) {
        if (str.startsWith(startStr)) {
            return str.substring(startStr.length() + 1, str.length());
        }
        return str;
    }

    Tuple<String, Boolean> strip(String loc) {
        String locPrev = "";
        boolean complement = false;
        while (!loc.equals(locPrev)) {
            locPrev = loc;
            if (loc.startsWith(COMPLEMENT)) {
                complement = true;
                loc = this.removeStartStr(loc, COMPLEMENT);
            }
            loc = this.removeStartStr(loc, JOIN);
            loc = this.removeStartStr(loc, ORDER);
        }
        return new Tuple<String, Boolean>(loc, complement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name            : " + this.locusName + "\n");
        sb.append("Sequence length : " + this.sequence.length() + "\n");
        for (StringBuffer refsb : this.references) {
            sb.append("Reference       :\n");
            for (String l : refsb.toString().split("\n")) {
                sb.append("                 " + l + "\n");
            }
        }
        if (this.sequence.length() <= 200) {
            sb.append("Sequence        : " + this.sequence + "\n");
        } else {
            sb.append("Sequence        : " + this.sequence.substring(0, 200) + "..." + "\n");
        }
        for (Feature f2 : this.features) {
            sb.append(f2);
        }
        return sb.toString();
    }
}

