/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.genBank.FeatureCoordinates;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Feature
implements Iterable<FeatureCoordinates> {
    static final String FEATURE_REGEX = "/([^=/\\s]*)(=?[^=\\n]*)";
    static final Pattern FEATURE_PATTERN = Pattern.compile("/([^=/\\s]*)(=?[^=\\n]*)");
    public static final String COMPLEMENT_STRING = "complement";
    Type type;
    int start;
    int end;
    int lineNum;
    HashMap<String, String> qualifiers;
    boolean complement;
    List<FeatureCoordinates> featureCoordinates;

    public Feature(Type type, String def) {
        this.type = type;
        this.qualifiers = new HashMap();
        this.start = -1;
        this.end = -1;
        this.complement = false;
        this.parse(def);
    }

    public Feature(Type type, String def, int start, int end, boolean complement, int lineNum) {
        this.type = type;
        this.qualifiers = new HashMap();
        this.complement = complement;
        if (end < start) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        this.start = start;
        this.end = end;
        this.lineNum = lineNum;
        this.parse(def);
        if (start < 0) {
            throw new RuntimeException("Feature starts with negative coordinates!\n\t" + this);
        }
    }

    public void add(FeatureCoordinates fc) {
        if (this.featureCoordinates == null) {
            this.featureCoordinates = new LinkedList<FeatureCoordinates>();
        }
        this.featureCoordinates.add(fc);
    }

    public String get(String name) {
        return this.qualifiers.get(name);
    }

    public String getAasequence() {
        return this.get("translation");
    }

    public int getEnd() {
        return this.end;
    }

    public String getGeneId() {
        String geneId = this.get("id");
        if (geneId != null) {
            return geneId;
        }
        geneId = this.get("locus_tag");
        if (geneId != null) {
            return geneId;
        }
        return null;
    }

    public String getGeneName() {
        String geneName = this.get("gene");
        if (geneName != null) {
            return geneName;
        }
        geneName = this.get("gene_synonym");
        if (geneName != null) {
            return geneName;
        }
        return this.getGeneId();
    }

    public int getStart() {
        return this.start;
    }

    public String getTranscriptId() {
        String trId = this.get("transcript_id");
        if (trId != null) {
            return trId;
        }
        trId = this.get("locus_tag");
        if (trId != null) {
            return trId;
        }
        trId = this.get("protein_id");
        if (trId != null) {
            return trId;
        }
        trId = this.get("db_xref");
        if (trId != null) {
            return trId;
        }
        trId = this.get("product");
        if (trId != null) {
            trId = trId.replaceAll("\\s", "_");
        }
        return trId;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasMultipleCoordinates() {
        return this.featureCoordinates != null;
    }

    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public Iterator<FeatureCoordinates> iterator() {
        return this.featureCoordinates.iterator();
    }

    void parse(String def) {
        int firstLine = def.indexOf("\n");
        if (this.start < 0 && this.end < 0) {
            String loc = def.substring(0, firstLine);
            this.parseLocation(loc);
        }
        def = def.substring(firstLine + 1);
        Matcher matcher = FEATURE_PATTERN.matcher(def);
        while (matcher.find()) {
            if (matcher.groupCount() < 2) continue;
            String key = matcher.group(1).toLowerCase();
            String value2 = matcher.group(2);
            if (value2 == null) {
                value2 = "";
            }
            if (value2.startsWith("=")) {
                value2 = value2.substring(1);
            }
            if (value2.startsWith("\"") && value2.endsWith("\"")) {
                value2 = value2.substring(1, value2.length() - 1);
            }
            this.qualifiers.put(key, value2.trim());
        }
    }

    void parseLocation(String loc) {
        String[] se;
        if ((loc = loc.replaceAll("[<>()]", "")).startsWith(COMPLEMENT_STRING)) {
            this.complement = true;
            loc = loc.substring(COMPLEMENT_STRING.length());
        }
        if ((se = loc.split("[\\.]+")).length > 1) {
            this.start = Gpr.parseIntSafe(se[0]);
            this.end = Gpr.parseIntSafe(se[1]);
        }
    }

    String removeQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String toString() {
        String format2 = "\t%-20s: \"%s\"\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Feature (line " + this.lineNum + "): '" + (Object)((Object)this.type) + "' [ " + this.start + ", " + this.end + " ]\t" + (this.complement ? COMPLEMENT_STRING : "") + "\n");
        if (this.featureCoordinates != null) {
            sb.append(String.format(format2, "coordinates", "join"));
            for (FeatureCoordinates fc : this.featureCoordinates) {
                sb.append(String.format(format2, "", fc));
            }
        }
        for (Map.Entry<String, String> e : this.qualifiers.entrySet()) {
            sb.append(String.format(format2, e.getKey(), e.getValue()));
        }
        return sb.toString();
    }

    public static enum Type {
        SOURCE,
        ID,
        CDS,
        GENE,
        MRNA,
        TRNA,
        RRNA,
        MISC_RNA,
        REPEAT_UNIT,
        REPEAT_REGION,
        MISC_FEATURE,
        UTR_3,
        UTR_5;


        public static Type parse(String typeStr) {
            typeStr = typeStr.toUpperCase();
            if ((typeStr = typeStr.replaceAll("[^A-Za-z0-9]", "_")).equals("5_UTR")) {
                return UTR_5;
            }
            if (typeStr.equals("3_UTR")) {
                return UTR_3;
            }
            if (typeStr.equals("SQ")) {
                return SOURCE;
            }
            try {
                return Type.valueOf(typeStr);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

