/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.parser.Parser;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class VcfFileIterator
extends MarkerFileIterator<VcfEntry>
implements Parser<VcfEntry> {
    public static final String MISSING = ".";
    private static final String EMPTY = "";
    boolean parseNow = true;
    boolean headeSection = false;
    boolean errorIfUnsorted = false;
    VcfHeader header = new VcfHeader();
    String chrPrev = "";
    int posPrev = -1;

    public VcfFileIterator(BufferedReader reader) {
        super(reader, 1);
    }

    public VcfFileIterator(String fileName) {
        super(fileName, 1);
    }

    public VcfFileIterator(String fileName, Genome genome) {
        super(fileName, genome, 1);
    }

    public List<String> getSampleNames() {
        return this.header.getSampleNames();
    }

    public VcfHeader getVcfHeader() {
        return this.header;
    }

    public boolean isHeadeSection() {
        return this.headeSection;
    }

    @Override
    public Collection<VcfEntry> parse(String str) {
        LinkedList<VcfEntry> list2 = new LinkedList<VcfEntry>();
        list2.add(this.parseVcfLine(str));
        return list2;
    }

    protected VcfEntry parseVcfLine(String line) {
        try {
            if (line.startsWith("#")) {
                this.header.addLine(line);
            } else if (line.length() > 0 && !line.startsWith("#")) {
                return new VcfEntry(this, line, this.lineNum, this.parseNow);
            }
        }
        catch (Throwable t) {
            Gpr.debug("Fatal error reading file '" + this.fileName + "' (line: " + this.lineNum + "):\n" + line);
            throw new RuntimeException(t);
        }
        return null;
    }

    public String readField(String[] fields, int fieldNum) {
        if (fields.length > fieldNum) {
            if (fields[fieldNum].equals(MISSING)) {
                return EMPTY;
            }
            return fields[fieldNum];
        }
        return EMPTY;
    }

    public VcfHeader readHeader() {
        if (this.nextLine != null && !this.nextLine.startsWith("#")) {
            return this.header;
        }
        try {
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (!this.line.startsWith("#")) {
                    this.nextLine = this.line;
                    return this.header;
                }
                this.header.addLine(this.line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return this.header;
    }

    @Override
    protected VcfEntry readNext() {
        try {
            this.headeSection = false;
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                VcfEntry vcfEntry = this.parseVcfLine(this.line);
                if (vcfEntry != null) {
                    if (this.errorIfUnsorted && vcfEntry.getChromosomeName().equals(this.chrPrev) && vcfEntry.getStart() < this.posPrev) {
                        throw new RuntimeException("VCF file " + (this.fileName != null ? this.fileName : EMPTY) + "' is not sorted, genomic position " + this.chrPrev + ":" + (this.posPrev + 1) + " is before " + this.chrPrev + ":" + (vcfEntry.getStart() + 1));
                    }
                    if (this.debug) {
                        String err2 = vcfEntry.check();
                        if (vcfEntry.getChromosomeName().equals(this.chrPrev) && vcfEntry.getStart() < this.posPrev) {
                            err2 = err2 + "File is not sorted: Position '" + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1) + "' after position '" + this.chrPrev + ":" + (this.posPrev + 1) + "'";
                        }
                        if (!err2.isEmpty()) {
                            System.err.println("WARNING: Malformed VCF entry" + (this.fileName != null ? "file '" + this.fileName + "'" : EMPTY) + ", line " + this.lineNum + ":\n" + "\tEntry  : " + vcfEntry + "\n" + "\tErrors :\n" + Gpr.prependEachLine("\t\t", err2));
                        }
                    }
                    this.chrPrev = vcfEntry.getChromosomeName();
                    this.posPrev = vcfEntry.getStart();
                    return vcfEntry;
                }
                this.headeSection |= true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return null;
    }

    @Override
    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setErrorIfUnsorted(boolean errorIfUnsorted) {
        this.errorIfUnsorted = errorIfUnsorted;
    }

    @Override
    public void setInOffset(int inOffset) {
        throw new RuntimeException("Cannot set input offset on VCF file!");
    }

    public void setParseNow(boolean parseNow) {
        this.parseNow = parseNow;
    }
}

